/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.MultivariateSummarizer;
import org.apache.spark.examples.mllib.MultivariateSummarizer$Params$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class MultivariateSummarizer$ {
    public static final MultivariateSummarizer$ MODULE$ = new MultivariateSummarizer$();

    public void main(String[] args) {
        MultivariateSummarizer.Params defaultParams = new MultivariateSummarizer.Params(MultivariateSummarizer$Params$.MODULE$.apply$default$1());
        OptionParser<MultivariateSummarizer.Params> parser = new OptionParser<MultivariateSummarizer.Params>(defaultParams){
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MultivariateSummarizer: an example app for MultivariateOnlineSummarizer"}));
                this.opt("input", Read$.MODULE$.stringRead()).text("Input path to labeled examples in LIBSVM format, default: " + defaultParams$1.input()).action((Function2 & Serializable)(x, c) -> c.copy((String)x));
                this.note(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |For example, the following command runs this app on a synthetic dataset:\n        |\n        | bin/spark-submit --class org.apache.spark.examples.mllib.MultivariateSummarizer \\\n        |  examples/target/scala-*/spark-examples-*.jar \\\n        |  --input data/mllib/sample_linear_regression_data.txt\n        ")));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.mllib.MultivariateSummarizer$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            MultivariateSummarizer.Params params = (MultivariateSummarizer.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(MultivariateSummarizer.Params params) {
        SparkConf conf = new SparkConf().setAppName("MultivariateSummarizer with " + params);
        SparkContext sc = new SparkContext(conf);
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input()).cache();
        Predef$.MODULE$.println((Object)("Summary of data file: " + params.input()));
        Predef$.MODULE$.println((Object)(examples.count() + " data points"));
        MultivariateOnlineSummarizer labelSummary = (MultivariateOnlineSummarizer)examples.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2 & Serializable)(summary, lp) -> summary.add(Vectors$.MODULE$.dense(lp.label(), (scala.collection.immutable.Seq)Nil$.MODULE$)), (Function2 & Serializable)(sum1, sum2) -> sum1.merge(sum2), ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        MultivariateOnlineSummarizer featureSummary = (MultivariateOnlineSummarizer)examples.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2 & Serializable)(summary, lp) -> summary.add(lp.features()), (Function2 & Serializable)(sum1, sum2) -> sum1.merge(sum2), ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Summary statistics");
        Predef$.MODULE$.println((Object)"\tLabel\tFeatures");
        Predef$.MODULE$.println((Object)("mean\t" + labelSummary.mean().apply(0) + "\t" + Predef$.MODULE$.wrapDoubleArray(featureSummary.mean().toArray()).mkString("\t")));
        Predef$.MODULE$.println((Object)("var\t" + labelSummary.variance().apply(0) + "\t" + Predef$.MODULE$.wrapDoubleArray(featureSummary.variance().toArray()).mkString("\t")));
        Predef$.MODULE$.println((Object)("nnz\t" + labelSummary.numNonzeros().apply(0) + "\t" + Predef$.MODULE$.wrapDoubleArray(featureSummary.numNonzeros().toArray()).mkString("\t")));
        Predef$.MODULE$.println((Object)("max\t" + labelSummary.max().apply(0) + "\t" + Predef$.MODULE$.wrapDoubleArray(featureSummary.max().toArray()).mkString("\t")));
        Predef$.MODULE$.println((Object)("min\t" + labelSummary.min().apply(0) + "\t" + Predef$.MODULE$.wrapDoubleArray(featureSummary.min().toArray()).mkString("\t")));
        Predef$.MODULE$.println();
        sc.stop();
    }

    private MultivariateSummarizer$() {
    }
}

