/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import java.io.Serializable;
import org.apache.spark.ml.linalg.JsonMatrixConverter$;
import org.apache.spark.ml.linalg.JsonVectorConverter$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001B\u0010!\u0001-B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0003\"A!\n\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003B\u0011!a\u0005A!b\u0001\n\u0003\u0001\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u00119\u0003!Q1A\u0005\u0002=C\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\tE\u0002\u0011)\u0019!C\u0001G\"Aq\r\u0001B\u0001B\u0003%A\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003i\u0001\u0011\u0005\u0011\u000fC\u0003i\u0001\u0011\u0005a\u000f\u0003\u0004i\u0001\u0011\u0005\u00111\u0001\u0005\u0007Q\u0002!\t!a\u0003\t\r!\u0004A\u0011AA\u000b\u0011!\ti\u0002\u0001C\u0001A\u0005}\u0001bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!a\u0011\u0001\t\u0003\t)\u0005\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA'\u0011\u001d\tY\u0006\u0001C#\u0003;Bq!a\u0018\u0001\t\u000b\n\t\u0007C\u0004\u0002j\u0001!)%a\u001b\b\u0011\u0005E\u0004\u0005#\u0001#\u0003g2qa\b\u0011\t\u0002\t\n)\b\u0003\u0004i7\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003\u0007ZB\u0011AAB\u0011%\tiiGA\u0001\n\u0013\tyIA\u0003QCJ\fWN\u0003\u0002\"E\u0005)\u0001/\u0019:b[*\u00111\u0005J\u0001\u0003[2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001+\taSkE\u0002\u0001[M\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012a!\u00118z%\u00164\u0007C\u0001\u001b=\u001d\t)$H\u0004\u00027s5\tqG\u0003\u00029U\u00051AH]8pizJ\u0011\u0001M\u0005\u0003w=\nq\u0001]1dW\u0006<W-\u0003\u0002>}\ta1+\u001a:jC2L'0\u00192mK*\u00111hL\u0001\u0007a\u0006\u0014XM\u001c;\u0016\u0003\u0005\u0003\"A\u0011$\u000f\u0005\r#\u0005C\u0001\u001c0\u0013\t)u&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#0\u0003\u001d\u0001\u0018M]3oi\u0002\nAA\\1nK\u0006)a.Y7fA\u0005\u0019Am\\2\u0002\t\u0011|7\rI\u0001\bSN4\u0016\r\\5e+\u0005\u0001\u0006\u0003\u0002\u0018R'zK!AU\u0018\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001+V\u0019\u0001!QA\u0016\u0001C\u0002]\u0013\u0011\u0001V\t\u00031n\u0003\"AL-\n\u0005i{#a\u0002(pi\"Lgn\u001a\t\u0003]qK!!X\u0018\u0003\u0007\u0005s\u0017\u0010\u0005\u0002/?&\u0011\u0001m\f\u0002\b\u0005>|G.Z1o\u0003!I7OV1mS\u0012\u0004\u0013!\u00033bi\u0006\u001cE.Y:t+\u0005!\u0007c\u0001\"f'&\u0011a\r\u0013\u0002\u0006\u00072\f7o]\u0001\u000bI\u0006$\u0018m\u00117bgN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004kY6tw\u000e\u001d\t\u0004W\u0002\u0019V\"\u0001\u0011\t\u000b}Z\u0001\u0019A!\t\u000b)[\u0001\u0019A!\t\u000b1[\u0001\u0019A!\t\u000b9[\u0001\u0019\u0001)\t\u000b\t\\\u0001\u0019\u00013\u0015\u000b)\u00148\u000f^;\t\u000b}b\u0001\u0019A!\t\u000b)c\u0001\u0019A!\t\u000b1c\u0001\u0019A!\t\u000b9c\u0001\u0019\u0001)\u0015\r)<hp`A\u0001\u0011\u0015yT\u00021\u0001y!\tIH0D\u0001{\u0015\tY(%\u0001\u0003vi&d\u0017BA?{\u00051IE-\u001a8uS\u001aL\u0017M\u00197f\u0011\u0015QU\u00021\u0001B\u0011\u0015aU\u00021\u0001B\u0011\u0015qU\u00021\u0001Q)\u001dQ\u0017QAA\u0004\u0003\u0013AQa\u0010\bA\u0002\u0005CQA\u0013\bA\u0002\u0005CQ\u0001\u0014\bA\u0002\u0005#\u0012B[A\u0007\u0003\u001f\t\t\"a\u0005\t\u000b}z\u0001\u0019A!\t\u000b){\u0001\u0019A!\t\u000b1{\u0001\u0019A!\t\u000b\t|\u0001\u0019\u00013\u0015\u000f)\f9\"!\u0007\u0002\u001c!)q\b\u0005a\u0001q\")!\n\u0005a\u0001\u0003\")A\n\u0005a\u0001\u0003\u0006Aa/\u00197jI\u0006$X\r\u0006\u0003\u0002\"\u0005\u001d\u0002c\u0001\u0018\u0002$%\u0019\u0011QE\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003S\t\u0002\u0019A*\u0002\u000bY\fG.^3\u0002\u0003]$B!a\f\u00026A!1.!\rT\u0013\r\t\u0019\u0004\t\u0002\n!\u0006\u0014\u0018-\u001c)bSJDa!!\u000b\u0013\u0001\u0004\u0019\u0016A\u0004\u0013nS:,8\u000fJ4sK\u0006$XM\u001d\u000b\u0005\u0003_\tY\u0004\u0003\u0004\u0002*M\u0001\raU\u0001\u000bUN|g.\u00128d_\u0012,GcA!\u0002B!1\u0011\u0011\u0006\u000bA\u0002M\u000b!B[:p]\u0012+7m\u001c3f)\r\u0019\u0016q\t\u0005\u0007\u0003\u0013*\u0002\u0019A!\u0002\t)\u001cxN\\\u0001\u0015gR\u0014\u0018N\\4SKB\u0014Xm]3oi\u0006$\u0018n\u001c8\u0011\t\u0005=\u0013\u0011L\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005!A.\u00198h\u0015\t\t9&\u0001\u0003kCZ\f\u0017bA$\u0002R\u0005AAo\\*ue&tw\rF\u0001B\u0003!A\u0017m\u001d5D_\u0012,GCAA2!\rq\u0013QM\u0005\u0004\u0003Oz#aA%oi\u00061Q-];bYN$2AXA7\u0011\u0019\ty'\u0007a\u00017\u0006\u0019qN\u00196\u0002\u000bA\u000b'/Y7\u0011\u0005-\\2\u0003B\u000e.\u0003o\u0002B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0005\u0003{\n)&\u0001\u0002j_&\u0019Q(a\u001f\u0015\u0005\u0005MT\u0003BAC\u0003\u0013#B!a\"\u0002\fB\u0019A+!#\u0005\u000bYk\"\u0019A,\t\r\u0005%S\u00041\u0001B\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\t\n\u0005\u0003\u0002P\u0005M\u0015\u0002BAK\u0003#\u0012aa\u00142kK\u000e$\b")
public class Param<T>
implements Serializable {
    private final String parent;
    private final String name;
    private final String doc;
    private final Function1<T, Object> isValid;
    private final Class<T> dataClass;
    private final String stringRepresentation;

    public String parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public String doc() {
        return this.doc;
    }

    public Function1<T, Object> isValid() {
        return this.isValid;
    }

    public Class<T> dataClass() {
        return this.dataClass;
    }

    public void validate(T value) {
        if (!BoxesRunTime.unboxToBoolean((Object)this.isValid().apply(value))) {
            String string;
            T t = value;
            if (ScalaRunTime$.MODULE$.isArray(t, 1)) {
                T t2 = t;
                string = Predef$.MODULE$.genericWrapArray(t2).mkString("[", ",", "]");
            } else {
                string = value.toString();
            }
            String valueToString = string;
            throw new IllegalArgumentException(this.parent() + " parameter " + this.name() + " given invalid value " + valueToString + ".");
        }
    }

    public ParamPair<T> w(T value) {
        return this.$minus$greater(value);
    }

    public ParamPair<T> $minus$greater(T value) {
        return new ParamPair<T>(this, value);
    }

    public String jsonEncode(T value) {
        T t = value;
        if (t instanceof String) {
            String string = (String)t;
            return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)new JString(string), JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3()));
        }
        if (t instanceof Vector) {
            Vector vector = (Vector)t;
            return JsonVectorConverter$.MODULE$.toJson(vector);
        }
        if (t instanceof Matrix) {
            Matrix matrix = (Matrix)t;
            return JsonMatrixConverter$.MODULE$.toJson(matrix);
        }
        throw new UnsupportedOperationException("The default jsonEncode only supports string, vector and matrix. " + this.getClass().getName() + " must override jsonEncode for " + value.getClass().getName() + ".");
    }

    public T jsonDecode(String json) {
        return Param$.MODULE$.jsonDecode(json);
    }

    public final String toString() {
        return this.stringRepresentation;
    }

    public final int hashCode() {
        return Statics.anyHash((Object)this.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Param)) return false;
        Param param = (Param)object;
        String string = param.parent();
        String string2 = this.parent();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = param.name();
        String string4 = this.name();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public Param(String parent, String name, String doc, Function1<T, Object> isValid, Class<T> dataClass) {
        this.parent = parent;
        this.name = name;
        this.doc = doc;
        this.isValid = isValid;
        this.dataClass = dataClass;
        this.stringRepresentation = parent + "__" + name;
    }

    public Param(String parent, String name, String doc, Function1<T, Object> isValid) {
        this(parent, name, doc, isValid, null);
    }

    public Param(Identifiable parent, String name, String doc, Function1<T, Object> isValid) {
        this(parent.uid(), name, doc, isValid);
    }

    public Param(String parent, String name, String doc) {
        this(parent, name, doc, ParamValidators$.MODULE$.alwaysTrue());
    }

    public Param(String parent, String name, String doc, Class<T> dataClass) {
        this(parent, name, doc, ParamValidators$.MODULE$.alwaysTrue(), dataClass);
    }

    public Param(Identifiable parent, String name, String doc) {
        this(parent.uid(), name, doc);
    }
}

