/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.NoopFilters;
import org.apache.spark.sql.catalyst.OrderedFilters;
import org.apache.spark.sql.catalyst.StructFilters;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser$;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LazyBadRecordCauseWrapper;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t%h\u0001B\u001a5\u0001\u0005C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005\u001f\"Aa\u000b\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003Y\u0011!i\u0006A!A!\u0002\u0013q\u0006\"\u00029\u0001\t\u0003\t\b\"\u00029\u0001\t\u00039\b\"\u00029\u0001\t\u0003YX!B@\u0001\t\u0005\u0005\u0001\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\ti\u0003\u0001Q\u0001\n\u0005\u0005\u0002bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003wAq!!\u0010\u0001A\u0003%q\nC\u0005\u0002@\u0001\u0011\r\u0011\"\u0001\u0002B!A\u0011\u0011\f\u0001!\u0002\u0013\t\u0019\u0005C\u0005\u0002\\\u0001\u0011\r\u0011\"\u0003\u0002^!A\u0011\u0011\u000f\u0001!\u0002\u0013\ty\u0006C\u0005\u0002t\u0001\u0011\r\u0011\"\u0003\u0002v!A\u0011Q\u0010\u0001!\u0002\u0013\t9\b\u0003\u0006\u0002\u0000\u0001A)\u0019!C\u0005\u0003\u0003C!\"a$\u0001\u0011\u000b\u0007I\u0011BAA\u0011)\t\t\n\u0001EC\u0002\u0013%\u00111\u0013\u0005\n\u00037\u0003!\u0019!C\u0005\u0003;C\u0001\"a*\u0001A\u0003%\u0011q\u0014\u0005\n\u0003S\u0003!\u0019!C\u0005\u0003cA\u0001\"a+\u0001A\u0003%\u00111\u0007\u0005\n\u0003[\u0003!\u0019!C\u0005\u0003cA\u0001\"a,\u0001A\u0003%\u00111\u0007\u0005\b\u0003c\u0003A\u0011BAZ\u0011%\t\u0019\r\u0001b\u0001\n\u0013\t)\r\u0003\u0005\u0002N\u0002\u0001\u000b\u0011BAd\u0011%\ty\r\u0001b\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002f\u0002\u0001\u000b\u0011BAj\u0011\u001d\t9\u000f\u0001C\u0001\u0003SD\u0011\"!@\u0001#\u0003%\t!a@\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018!9!\u0011\u0006\u0001\u0005\n\t-\u0002\"\u0003B\u001a\u0001\t\u0007I\u0011\u0001B\u001b\u0011!\u0011)\u0005\u0001Q\u0001\n\t]\u0002\"\u0003B$\u0001\t\u0007I\u0011\u0002B%\u0011!\u0011\t\u0006\u0001Q\u0001\n\t-\u0003b\u0002B*\u0001\u0011%!QK\u0004\t\u00057\"\u0004\u0012\u0001\u001d\u0003^\u001991\u0007\u000eE\u0001q\t}\u0003B\u00029.\t\u0003\u0011\t\u0007C\u0004\u0003d5\"\tA!\u001a\t\u000f\t\u001dU\u0006\"\u0001\u0003\n\"9!qT\u0017\u0005\n\t\u0005\u0006b\u0002Bm[\u0011\u0005!1\u001c\u0002\u0010+:Lgo\\2jif\u0004\u0016M]:fe*\u0011QGN\u0001\u0004GN4(BA\u001c9\u0003!\u0019\u0017\r^1msN$(BA\u001d;\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003wq\nQa\u001d9be.T!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO\u000e\u00011c\u0001\u0001C\u0011B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n1\u0011I\\=SK\u001a\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u001e\u0002\u0011%tG/\u001a:oC2L!!\u0014&\u0003\u000f1{wmZ5oO\u0006QA-\u0019;b'\u000eDW-\\1\u0011\u0005A\u001bV\"A)\u000b\u0005IC\u0014!\u0002;za\u0016\u001c\u0018B\u0001+R\u0005)\u0019FO];diRK\b/Z\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0003\u001dy\u0007\u000f^5p]N,\u0012\u0001\u0017\t\u00033jk\u0011\u0001N\u0005\u00037R\u0012!bQ*W\u001fB$\u0018n\u001c8t\u0003!y\u0007\u000f^5p]N\u0004\u0013a\u00024jYR,'o\u001d\t\u0004?\u001eTgB\u00011f\u001d\t\tG-D\u0001c\u0015\t\u0019\u0007)\u0001\u0004=e>|GOP\u0005\u0002\u000b&\u0011a\rR\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0017NA\u0002TKFT!A\u001a#\u0011\u0005-tW\"\u00017\u000b\u00055D\u0014aB:pkJ\u001cWm]\u0005\u0003_2\u0014aAR5mi\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003sgR,h\u000f\u0005\u0002Z\u0001!)aJ\u0002a\u0001\u001f\")QK\u0002a\u0001\u001f\")aK\u0002a\u00011\")QL\u0002a\u0001=R!!\u000f_={\u0011\u0015qu\u00011\u0001P\u0011\u0015)v\u00011\u0001P\u0011\u00151v\u00011\u0001Y)\r\u0011HP \u0005\u0006{\"\u0001\raT\u0001\u0007g\u000eDW-\\1\t\u000bYC\u0001\u0019\u0001-\u0003\u001dY\u000bG.^3D_:4XM\u001d;feB91)a\u0001\u0002\b\u0005]\u0011bAA\u0003\t\nIa)\u001e8di&|g.\r\t\u0005\u0003\u0013\t\tB\u0004\u0003\u0002\f\u00055\u0001CA1E\u0013\r\ty\u0001R\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0011Q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=A\tE\u0002D\u00033I1!a\u0007E\u0005\r\te._\u0001\u000ei>\\WM\\%oI\u0016D\u0018I\u001d:\u0016\u0005\u0005\u0005\u0002#B\"\u0002$\u0005\u001d\u0012bAA\u0013\t\n)\u0011I\u001d:bsB\u00191)!\u000b\n\u0007\u0005-BIA\u0002J]R\fa\u0002^8lK:Le\u000eZ3y\u0003J\u0014\b%A\u0007d_2,XN\u001c)sk:LgnZ\u000b\u0003\u0003g\u00012aQA\u001b\u0013\r\t9\u0004\u0012\u0002\b\u0005>|G.Z1o\u00031\u0001\u0018M]:fIN\u001b\u0007.Z7b+\u0005y\u0015!\u00049beN,GmU2iK6\f\u0007%A\u0005u_.,g.\u001b>feV\u0011\u00111\t\t\u0005\u0003\u000b\n)&\u0004\u0002\u0002H)\u0019Q'!\u0013\u000b\t\u0005-\u0013QJ\u0001\ba\u0006\u00148/\u001a:t\u0015\u0011\ty%!\u0015\u0002\u0013Ut\u0017N^8dSRL(BAA*\u0003\r\u0019w.\\\u0005\u0005\u0003/\n9EA\u0005DgZ\u0004\u0016M]:fe\u0006QAo\\6f]&TXM\u001d\u0011\u0002\u0017I,\u0017/^5sK\u0012\u0014vn^\u000b\u0003\u0003?\u0002RaQA1\u0003KJ1!a\u0019E\u0005\u0011\u0019v.\\3\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b7\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005=\u0014\u0011\u000e\u0002\u0013\u000f\u0016tWM]5d\u0013:$XM\u001d8bYJ{w/\u0001\u0007sKF,\u0018N]3e%><\b%\u0001\u0004o_J{wo]\u000b\u0003\u0003or1aQA=\u0013\r\tY\bR\u0001\u0005\u001d>tW-A\u0004o_J{wo\u001d\u0011\u0002%QLW.Z:uC6\u0004hi\u001c:nCR$XM]\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u00133\u0014\u0001B;uS2LA!!$\u0002\b\n\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0003U!\u0018.\\3ti\u0006l\u0007O\u0014+[\r>\u0014X.\u0019;uKJ\fQ\u0002Z1uK\u001a{'/\\1ui\u0016\u0014XCAAK!\u0011\t))a&\n\t\u0005e\u0015q\u0011\u0002\u000e\t\u0006$XMR8s[\u0006$H/\u001a:\u0002\u0015\r\u001chOR5mi\u0016\u00148/\u0006\u0002\u0002 B!\u0011\u0011UAR\u001b\u00051\u0014bAASm\ti1\u000b\u001e:vGR4\u0015\u000e\u001c;feN\f1bY:w\r&dG/\u001a:tA\u0005)SM\\1cY\u0016\u0004\u0016M]:j]\u001e4\u0015\r\u001c7cC\u000e\\gi\u001c:US6,7\u000f^1naRK\b/Z\u0001'K:\f'\r\\3QCJ\u001c\u0018N\\4GC2d'-Y2l\r>\u0014H+[7fgR\fW\u000e\u001d+za\u0016\u0004\u0013\u0001I3oC\ndW\rU1sg&twMR1mY\n\f7m\u001b$pe\u0012\u000bG/\u001a+za\u0016\f\u0011%\u001a8bE2,\u0007+\u0019:tS:<g)\u00197mE\u0006\u001c7NR8s\t\u0006$X\rV=qK\u0002\nqbZ3u\u0007V\u0014(/\u001a8u\u0013:\u0004X\u000f^\u000b\u0003\u0003k\u0003B!a.\u0002@6\u0011\u0011\u0011\u0018\u0006\u0004%\u0006m&bAA_u\u00051QO\\:bM\u0016LA!!1\u0002:\nQQ\u000b\u0016$9'R\u0014\u0018N\\4\u0002\u001fY\fG.^3D_:4XM\u001d;feN,\"!a2\u0011\u000b\r\u000b\u0019#!3\u0011\u0007\u0005-\u0017\"D\u0001\u0001\u0003A1\u0018\r\\;f\u0007>tg/\u001a:uKJ\u001c\b%A\u0007eK\u000eLW.\u00197QCJ\u001cXM]\u000b\u0003\u0003'\u0004raQA\u0002\u0003\u000f\t)\u000e\u0005\u0003\u0002X\u0006\u0005XBAAm\u0015\u0011\tY.!8\u0002\t5\fG\u000f\u001b\u0006\u0003\u0003?\fAA[1wC&!\u00111]Am\u0005)\u0011\u0015n\u001a#fG&l\u0017\r\\\u0001\u000fI\u0016\u001c\u0017.\\1m!\u0006\u00148/\u001a:!\u00035i\u0017m[3D_:4XM\u001d;feRA\u0011\u0011ZAv\u0003_\fI\u0010C\u0004\u0002n\u000e\u0002\r!a\u0002\u0002\t9\fW.\u001a\u0005\b\u0003c\u001c\u0003\u0019AAz\u0003!!\u0017\r^1UsB,\u0007c\u0001)\u0002v&\u0019\u0011q_)\u0003\u0011\u0011\u000bG/\u0019+za\u0016D\u0011\"a?$!\u0003\u0005\r!a\r\u0002\u00119,H\u000e\\1cY\u0016\fq#\\1lK\u000e{gN^3si\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0005!\u0006BA\u001a\u0005\u0007Y#A!\u0002\u0011\t\t\u001d!\u0011C\u0007\u0003\u0005\u0013QAAa\u0003\u0003\u000e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001f!\u0015AC1o]>$\u0018\r^5p]&!!1\u0003B\u0005\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000e]VdGnU1gK\u0012\u000bG/^7\u0015\u0015\te!q\u0004B\u0012\u0005K\u00119\u0003\u0006\u0003\u0002\u0018\tm\u0001b\u0002B\u000fK\u0001\u0007\u0011\u0011Z\u0001\nG>tg/\u001a:uKJDqA!\t&\u0001\u0004\t9!A\u0003eCR,X\u000eC\u0004\u0002n\u0016\u0002\r!a\u0002\t\u000f\u0005mX\u00051\u0001\u00024!)a+\na\u00011\u0006I\u0001/\u0019:tK2Kg.\u001a\u000b\u0005\u0005[\u0011y\u0003E\u0003D\u0003G\t9\u0001C\u0004\u00032\u0019\u0002\r!a\u0002\u0002\t1Lg.Z\u0001\u0006a\u0006\u00148/Z\u000b\u0003\u0005o\u0001raQA\u0002\u0003\u000f\u0011I\u0004E\u0003D\u0005w\u0011y$C\u0002\u0003>\u0011\u0013aa\u00149uS>t\u0007\u0003BAQ\u0005\u0003J1Aa\u00117\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\rA\f'o]3!\u0003!9W\r\u001e+pW\u0016tWC\u0001B&!%\u0019%Q\nB\u0017\u0003O\t9!C\u0002\u0003P\u0011\u0013\u0011BR;oGRLwN\u001c\u001a\u0002\u0013\u001d,G\u000fV8lK:\u0004\u0013aB2p]Z,'\u000f\u001e\u000b\u0005\u0005s\u00119\u0006C\u0004\u0003Z-\u0002\rA!\f\u0002\rQ|7.\u001a8t\u0003=)f.\u001b<pG&$\u0018\u0010U1sg\u0016\u0014\bCA-.'\ti#\t\u0006\u0002\u0003^\u0005qAo\\6f]&TXm\u0015;sK\u0006lGC\u0003B4\u0005[\u0012iH!!\u0003\u0004B)qL!\u001b\u0003.%\u0019!1N5\u0003\u0011%#XM]1u_JDqAa\u001c0\u0001\u0004\u0011\t(A\u0006j]B,Ho\u0015;sK\u0006l\u0007\u0003\u0002B:\u0005sj!A!\u001e\u000b\t\t]\u0014Q\\\u0001\u0003S>LAAa\u001f\u0003v\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\u0011yh\fa\u0001\u0003g\t\u0001c\u001d5pk2$GI]8q\u0011\u0016\fG-\u001a:\t\u000f\u0005}r\u00061\u0001\u0002D!9!QQ\u0018A\u0002\u0005\u001d\u0011\u0001C3oG>$\u0017N\\4\u0002\u0017A\f'o]3TiJ,\u0017-\u001c\u000b\u000b\u0005\u0017\u0013iIa$\u0003\u0014\nu\u0005#B0\u0003j\t}\u0002b\u0002B8a\u0001\u0007!\u0011\u000f\u0005\u0007\u0005#\u0003\u0004\u0019\u0001:\u0002\rA\f'o]3s\u0011\u001d\u0011)\n\ra\u0001\u0005/\u000bQ\u0002[3bI\u0016\u00148\t[3dW\u0016\u0014\bcA-\u0003\u001a&\u0019!1\u0014\u001b\u0003!\r\u001bf\u000bS3bI\u0016\u00148\t[3dW\u0016\u0014\b\"B?1\u0001\u0004y\u0015!D2p]Z,'\u000f^*ue\u0016\fW.\u0006\u0003\u0003$\nMFC\u0003BS\u0005\u0007\u0014)Ma2\u0003XR!!q\u0015B`%\u0015\u0011IK\u0011BW\r\u0019\u0011Y+\r\u0001\u0003(\naAH]3gS:,W.\u001a8u}A)qL!\u001b\u00030B!!\u0011\u0017BZ\u0019\u0001!qA!.2\u0005\u0004\u00119LA\u0001U#\u0011\u0011I,a\u0006\u0011\u0007\r\u0013Y,C\u0002\u0003>\u0012\u0013qAT8uQ&tw\rC\u0004\u0003TE\u0002\rA!1\u0011\u000f\r\u000b\u0019A!\f\u00030\"9!qN\u0019A\u0002\tE\u0004bBA c\u0001\u0007\u00111\t\u0005\b\u0005\u0013\f\u0004\u0019\u0001Bf\u00031A\u0017M\u001c3mK\"+\u0017\rZ3s!\u0015\u0019%Q\u001aBi\u0013\r\u0011y\r\u0012\u0002\n\rVt7\r^5p]B\u00022a\u0011Bj\u0013\r\u0011)\u000e\u0012\u0002\u0005+:LG\u000fC\u0004\u0003\u0006F\u0002\r!a\u0002\u0002\u001bA\f'o]3Ji\u0016\u0014\u0018\r^8s))\u0011YI!8\u0003d\n\u0015(q\u001d\u0005\b\u0005?\u0014\u0004\u0019\u0001Bq\u0003\u0015a\u0017N\\3t!\u0015y&\u0011NA\u0004\u0011\u0019\u0011\tJ\ra\u0001e\"9!Q\u0013\u001aA\u0002\t]\u0005\"B?3\u0001\u0004y\u0005")
public class UnivocityParser
implements Logging {
    private TimestampFormatter timestampFormatter;
    private TimestampFormatter timestampNTZFormatter;
    private DateFormatter dateFormatter;
    private final StructType dataSchema;
    private final StructType requiredSchema;
    private final CSVOptions options;
    private final int[] tokenIndexArr;
    private final StructType parsedSchema;
    private final CsvParser tokenizer;
    private final Some<GenericInternalRow> requiredRow;
    private final None$ noRows;
    private final StructFilters csvFilters;
    private final boolean enableParsingFallbackForTimestampType;
    private final boolean enableParsingFallbackForDateType;
    private final Function1<String, Object>[] valueConverters;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function1<String, Option<InternalRow>> parse;
    private final Function2<String[], Object, String> getToken;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Iterator<InternalRow> parseIterator(Iterator<String> lines, UnivocityParser parser, CSVHeaderChecker headerChecker, StructType schema) {
        return UnivocityParser$.MODULE$.parseIterator(lines, parser, headerChecker, schema);
    }

    public static Iterator<InternalRow> parseStream(InputStream inputStream, UnivocityParser parser, CSVHeaderChecker headerChecker, StructType schema) {
        return UnivocityParser$.MODULE$.parseStream(inputStream, parser, headerChecker, schema);
    }

    public static Iterator<String[]> tokenizeStream(InputStream inputStream, boolean shouldDropHeader, CsvParser tokenizer, String encoding) {
        return UnivocityParser$.MODULE$.tokenizeStream(inputStream, shouldDropHeader, tokenizer, encoding);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CSVOptions options() {
        return this.options;
    }

    private int[] tokenIndexArr() {
        return this.tokenIndexArr;
    }

    private boolean columnPruning() {
        return this.options().isColumnPruningEnabled(this.requiredSchema);
    }

    private StructType parsedSchema() {
        return this.parsedSchema;
    }

    public CsvParser tokenizer() {
        return this.tokenizer;
    }

    private Some<GenericInternalRow> requiredRow() {
        return this.requiredRow;
    }

    private None$ noRows() {
        return this.noRows;
    }

    private TimestampFormatter timestampFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.timestampFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampFormatInRead(), this.options().zoneId(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampFormatter() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.timestampFormatter$lzycompute();
        }
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampNTZFormatInRead(), this.options().zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.timestampNTZFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.timestampNTZFormatter$lzycompute();
        }
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dateFormatter = DateFormatter$.MODULE$.apply(this.options().dateFormatInRead(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.dateFormatter$lzycompute();
        }
        return this.dateFormatter;
    }

    private StructFilters csvFilters() {
        return this.csvFilters;
    }

    private boolean enableParsingFallbackForTimestampType() {
        return this.enableParsingFallbackForTimestampType;
    }

    private boolean enableParsingFallbackForDateType() {
        return this.enableParsingFallbackForDateType;
    }

    private UTF8String getCurrentInput() {
        if (this.tokenizer().getContext() == null) {
            return null;
        }
        String currentContent = this.tokenizer().getContext().currentParsedContent();
        if (currentContent == null) {
            return null;
        }
        return UTF8String.fromString((String)StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(currentContent)));
    }

    private Function1<String, Object>[] valueConverters() {
        return this.valueConverters;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    public Function1<String, Object> makeConverter(String name, DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof ByteType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(x$2))));
        }
        if (dataType2 instanceof ShortType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$3))));
        }
        if (dataType2 instanceof IntegerType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4))));
        }
        if (dataType2 instanceof LongType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$5))));
        }
        if (dataType2 instanceof FloatType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x0$1 -> {
                String string = x0$1;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return BoxesRunTime.boxToFloat((float)Float.NaN);
                }
                String string4 = this.options().negativeInf();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY);
                }
                String string6 = this.options().positiveInf();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    return BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY);
                }
                return BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(string)));
            });
        }
        if (dataType2 instanceof DoubleType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x0$2 -> {
                String string = x0$2;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return BoxesRunTime.boxToDouble((double)Double.NaN);
                }
                String string4 = this.options().negativeInf();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY);
                }
                String string6 = this.options().positiveInf();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    return BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY);
                }
                return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(string)));
            });
        }
        if (dataType2 instanceof BooleanType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$6))));
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> Decimal$.MODULE$.apply((BigDecimal)this.decimalParser().apply(datum), decimalType.precision(), decimalType.scale()));
        }
        if (dataType2 instanceof DateType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToInteger((int)this.dateFormatter().parse(datum));
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        if (!this.enableParsingFallbackForDateType()) {
                            throw throwable2;
                        }
                        UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)datum));
                        object = DateTimeUtils$.MODULE$.stringToDate(str).getOrElse((Function0 & Serializable)() -> {
                            throw throwable2;
                        });
                    }
                    throw throwable;
                }
                return object;
            });
        }
        if (dataType2 instanceof TimestampType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToLong((long)this.timestampFormatter().parse(datum));
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        if (!this.enableParsingFallbackForTimestampType()) {
                            throw throwable2;
                        }
                        UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)datum));
                        object = DateTimeUtils$.MODULE$.stringToTimestamp(str, this.options().zoneId()).getOrElse((Function0 & Serializable)() -> {
                            throw throwable2;
                        });
                    }
                    throw throwable;
                }
                return object;
            });
        }
        if (dataType2 instanceof TimestampNTZType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> BoxesRunTime.boxToLong((long)UnivocityParser.$anonfun$makeConverter$24(this, datum)));
        }
        if (dataType2 instanceof StringType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1));
        }
        if (dataType2 instanceof BinaryType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$7 -> x$7.getBytes());
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)datum)));
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.castStringToYMInterval(UTF8String.fromString((String)datum), yearMonthIntervalType.startField(), yearMonthIntervalType.endField())));
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.castStringToDTInterval(UTF8String.fromString((String)datum), dayTimeIntervalType.startField(), dayTimeIntervalType.endField())));
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.makeConverter(name, userDefinedType.sqlType(), nullable);
        }
        throw ExecutionErrors$.MODULE$.unsupportedDataTypeError(dataType);
    }

    public boolean makeConverter$default$3() {
        return true;
    }

    private Object nullSafeDatum(String datum, String name, boolean nullable, CSVOptions options, Function1<String, Object> converter) {
        String string = datum;
        String string2 = options.nullValue();
        if (!(string == null ? string2 != null : !string.equals(string2)) || datum == null) {
            if (!nullable) {
                throw QueryExecutionErrors$.MODULE$.foundNullValueForNotNullableFieldError(name);
            }
            return null;
        }
        return converter.apply((Object)datum);
    }

    private String[] parseLine(String line) {
        String[] stringArray;
        try {
            stringArray = this.tokenizer().parseLine(line);
        }
        catch (Throwable throwable) {
            TextParsingException textParsingException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof TextParsingException && (textParsingException = (TextParsingException)throwable2).getCause() instanceof ArrayIndexOutOfBoundsException) {
                throw new SparkRuntimeException("MALFORMED_CSV_RECORD", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"badRecord"), (Object)line)})), (Throwable)textParsingException, SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
            }
            throw throwable;
        }
        return stringArray;
    }

    public Function1<String, Option<InternalRow>> parse() {
        return this.parse;
    }

    private Function2<String[], Object, String> getToken() {
        return this.getToken;
    }

    public Option<InternalRow> org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(String[] tokens) {
        if (tokens == null) {
            throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable)() -> this.getCurrentInput(), (Function0<InternalRow[]>)(Function0 & Serializable)() -> (InternalRow[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class)), new LazyBadRecordCauseWrapper((Function0<Throwable>)(Function0 & Serializable)() -> QueryExecutionErrors$.MODULE$.malformedCSVRecordError("")));
        }
        UTF8String currentInput = this.getCurrentInput();
        None$ badRecordException = tokens.length != this.parsedSchema().length() ? new Some((Object)new LazyBadRecordCauseWrapper((Function0<Throwable>)(Function0 & Serializable)() -> QueryExecutionErrors$.MODULE$.malformedCSVRecordError(currentInput.toString()))) : None$.MODULE$;
        GenericInternalRow row = (GenericInternalRow)this.requiredRow().get();
        boolean skipRow = false;
        for (int i = 0; i < this.requiredSchema.length(); ++i) {
            try {
                if (skipRow) {
                    row.setNullAt(i);
                    continue;
                }
                row.update(i, this.valueConverters()[i].apply(this.getToken().apply((Object)tokens, (Object)BoxesRunTime.boxToInteger((int)i))));
                if (!this.csvFilters().skipRow(row, i)) continue;
                skipRow = true;
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 instanceof SparkUpgradeException) {
                    SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable3;
                    throw sparkUpgradeException;
                }
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    badRecordException = badRecordException.orElse((Function0 & Serializable)() -> new Some((Object)throwable2));
                    row.update(i, ResolveDefaultColumns$.MODULE$.existenceDefaultValues(this.requiredSchema)[i]);
                    continue;
                }
                throw throwable;
            }
        }
        if (skipRow) {
            return this.noRows();
        }
        if (badRecordException.isDefined()) {
            throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable)() -> currentInput, (Function0<InternalRow[]>)(Function0 & Serializable)() -> (InternalRow[])((Object[])new InternalRow[]{(InternalRow)this.requiredRow().get()}), (Throwable)badRecordException.get());
        }
        return this.requiredRow();
    }

    public static final /* synthetic */ long $anonfun$makeConverter$24(UnivocityParser $this, String datum) {
        return $this.timestampNTZFormatter().parseWithoutTimeZone(datum, false);
    }

    public static final /* synthetic */ String $anonfun$getToken$1(String[] tokens, int index) {
        return tokens[index];
    }

    public static final /* synthetic */ String $anonfun$getToken$2(UnivocityParser $this, String[] tokens, int index) {
        return tokens[$this.tokenIndexArr()[index]];
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options, Seq<Filter> filters) {
        this.dataSchema = dataSchema;
        this.requiredSchema = requiredSchema;
        this.options = options;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(requiredSchema.toSet().subsetOf((Set)dataSchema.toSet()), (Function0 & Serializable)() -> "requiredSchema (" + $this.requiredSchema.catalogString() + ") should be the subset of dataSchema (" + $this.dataSchema.catalogString() + ").");
        this.tokenIndexArr = (int[])((IterableOnceOps)requiredSchema.map((Function1 & Serializable)f -> BoxesRunTime.boxToInteger((int)this.dataSchema.indexOf((Object)f)))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        this.parsedSchema = this.columnPruning() ? requiredSchema : dataSchema;
        CsvParserSettings parserSetting = options.asParserSettings();
        Object object = this.parsedSchema().length() < dataSchema.length() ? parserSetting.selectIndexes((Integer[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(this.tokenIndexArr()), (Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), ClassTag$.MODULE$.apply(Integer.class))) : BoxedUnit.UNIT;
        this.tokenizer = new CsvParser(parserSetting);
        this.requiredRow = new Some((Object)new GenericInternalRow(requiredSchema.length()));
        this.noRows = None$.MODULE$;
        this.csvFilters = SQLConf$.MODULE$.get().csvFilterPushDown() ? new OrderedFilters(filters, requiredSchema) : new NoopFilters();
        this.enableParsingFallbackForTimestampType = BoxesRunTime.unboxToBoolean((Object)options.enableDateTimeParsingFallback().orElse((Function0 & Serializable)() -> SQLConf$.MODULE$.get().csvEnableDateTimeParsingFallback()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
            Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
            return !(value == null ? value2 != null : !value.equals(value2)) || this.options().timestampFormatInRead().isEmpty();
        }));
        this.enableParsingFallbackForDateType = BoxesRunTime.unboxToBoolean((Object)options.enableDateTimeParsingFallback().orElse((Function0 & Serializable)() -> SQLConf$.MODULE$.get().csvEnableDateTimeParsingFallback()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
            Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
            return !(value == null ? value2 != null : !value.equals(value2)) || this.options().dateFormatOption().isEmpty();
        }));
        this.valueConverters = (Function1[])((IterableOnceOps)requiredSchema.map((Function1 & Serializable)f -> this.makeConverter(f.name(), f.dataType(), f.nullable()))).toArray(ClassTag$.MODULE$.apply(Function1.class));
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.parse = this.columnPruning() && requiredSchema.isEmpty() ? (Function1 & Serializable)x$8 -> new Some((Object)InternalRow$.MODULE$.empty()) : (Function1 & Serializable)input -> this.org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(this.parseLine((String)input));
        this.getToken = this.columnPruning() ? (Function2 & Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$1(tokens, BoxesRunTime.unboxToInt((Object)index)) : (Function2 & Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$2(this, tokens, BoxesRunTime.unboxToInt((Object)index));
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options) {
        this(dataSchema, requiredSchema, options, (Seq<Filter>)((Seq)package$.MODULE$.Seq().empty()));
    }

    public UnivocityParser(StructType schema, CSVOptions options) {
        this(schema, schema, options);
    }
}

