/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import java.util.regex.Pattern;
import uk.me.parabola.mkgmap.osmstyle.actions.ValueFilter;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.scan.SyntaxException;

public class PartFilter
extends ValueFilter {
    private String separator;
    private int partnumber;
    private boolean isLt = false;
    private boolean isGt = false;

    public PartFilter(String arg) {
        String[] temp;
        if (arg.contains(":")) {
            temp = arg.split(":");
        } else if (arg.contains(">")) {
            temp = arg.split(">");
            this.isGt = true;
        } else if (arg.contains("<")) {
            temp = arg.split("<");
            this.isLt = true;
        } else {
            temp = new String[]{arg};
        }
        this.partnumber = 1;
        try {
            if (temp.length > 1) {
                this.partnumber = Integer.parseInt(temp[1]);
            }
            this.separator = temp[0].length() > 0 ? temp[0] : ";";
        }
        catch (NumberFormatException e) {
            throw new SyntaxException("Not valid numbers in style part command: " + arg);
        }
        if (this.partnumber == 0) {
            throw new SyntaxException("Not valid numbers in style part command: " + arg);
        }
    }

    @Override
    public String doFilter(String value, Element el) {
        int i;
        int idx;
        if (value == null || this.partnumber == 0) {
            return null;
        }
        String[] temp = value.split(Pattern.quote(this.separator));
        if (temp.length < Math.abs(this.partnumber)) {
            return null;
        }
        int n = idx = this.partnumber > 0 ? this.partnumber - 1 : temp.length + this.partnumber;
        if (!this.isLt && !this.isGt) {
            return temp[idx].trim();
        }
        StringBuilder returnValue = new StringBuilder();
        if (this.isLt) {
            for (i = 0; i < idx; ++i) {
                returnValue.append(temp[i]).append(this.separator);
            }
        }
        if (this.isGt) {
            for (i = idx + 1; i < temp.length; ++i) {
                returnValue.append(temp[i]).append(this.separator);
            }
        }
        return returnValue.toString();
    }
}

