/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import java.util.List;
import uk.me.parabola.imgfmt.app.Exit;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.ExitFacility;
import uk.me.parabola.imgfmt.app.lbl.Zip;

public class POIRecord {
    static final int HAS_STREET_NUM = 1;
    static final int HAS_STREET = 2;
    static final int HAS_CITY = 4;
    static final int HAS_ZIP = 8;
    static final int HAS_PHONE = 16;
    static final int HAS_EXIT = 32;
    static final int HAS_TIDE_PREDICTION = 64;
    private int offset = -1;
    private Label poiName;
    private final SimpleStreetPhoneNumber simpleStreetNumber = new SimpleStreetPhoneNumber();
    private final SimpleStreetPhoneNumber simplePhoneNumber = new SimpleStreetPhoneNumber();
    private Label streetName;
    private Label streetNumberName;
    private Label complexPhoneNumber;
    private City city;
    private Zip zip;
    private Exit exit;

    public void setLabel(Label label) {
        this.poiName = label;
    }

    public void setStreetName(Label label) {
        this.streetName = label;
    }

    public boolean setSimpleStreetNumber(String streetNumber) {
        return this.simpleStreetNumber.set(streetNumber);
    }

    public void setComplexStreetNumber(Label label) {
        this.streetNumberName = label;
    }

    public boolean setSimplePhoneNumber(String phone) {
        return this.simplePhoneNumber.set(phone);
    }

    public void setComplexPhoneNumber(Label label) {
        this.complexPhoneNumber = label;
    }

    public void setZip(Zip zip) {
        this.zip = zip;
    }

    public void setCity(City city) {
        this.city = city;
    }

    public void setExit(Exit exit) {
        this.exit = exit;
    }

    void write(ImgFileWriter writer, int POIGlobalFlags, int realofs, int cityPtrSize, int zipPtrSize, int highwayPtrSize, int exitFacilityPtrSize) {
        int labOff;
        assert (this.offset == realofs) : "offset = " + this.offset + " realofs = " + realofs;
        int ptr = this.poiName.getOffset();
        if (POIGlobalFlags != this.getPOIFlags()) {
            ptr |= 0x800000;
        }
        writer.put3u(ptr);
        if (POIGlobalFlags != this.getPOIFlags()) {
            writer.put1u(this.getWrittenPOIFlags(POIGlobalFlags));
        }
        if (this.streetNumberName != null) {
            labOff = this.streetNumberName.getOffset();
            writer.put1u(labOff >> 16);
            writer.put2u(labOff & 0xFFFF);
        } else if (this.simpleStreetNumber.isUsed()) {
            this.simpleStreetNumber.write(writer);
        }
        if (this.streetName != null) {
            writer.put3u(this.streetName.getOffset());
        }
        if (this.city != null) {
            writer.putNu(cityPtrSize, this.city.getIndex());
        }
        if (this.zip != null) {
            writer.putNu(zipPtrSize, this.zip.getIndex());
        }
        if (this.complexPhoneNumber != null) {
            labOff = this.complexPhoneNumber.getOffset();
            writer.put1u(labOff >> 16);
            writer.put2u(labOff & 0xFFFF);
        } else if (this.simplePhoneNumber.isUsed()) {
            this.simplePhoneNumber.write(writer);
        }
        if (this.exit != null) {
            Label description = this.exit.getDescription();
            int val = 0;
            if (description != null) {
                val = description.getOffset();
                assert (val < 0x400000) : "Exit description label offset too large";
            }
            if (this.exit.getOvernightParking()) {
                val |= 0x400000;
            }
            List<ExitFacility> facilites = this.exit.getFacilities();
            ExitFacility ef = null;
            if (!facilites.isEmpty()) {
                ef = facilites.get(0);
            }
            if (ef != null) {
                val |= 0x800000;
            }
            writer.put3u(val);
            int highwayIndex = this.exit.getHighway().getIndex();
            writer.putNu(highwayPtrSize, highwayIndex);
            if (ef != null) {
                int exitFacilityIndex = ef.getIndex();
                writer.putNu(exitFacilityPtrSize, exitFacilityIndex);
            }
        }
    }

    int getPOIFlags() {
        int b = 0;
        if (this.streetName != null) {
            b |= 2;
        }
        if (this.simpleStreetNumber.isUsed() || this.streetNumberName != null) {
            b |= 1;
        }
        if (this.city != null) {
            b |= 4;
        }
        if (this.zip != null) {
            b |= 8;
        }
        if (this.simplePhoneNumber.isUsed() || this.complexPhoneNumber != null) {
            b |= 0x10;
        }
        if (this.exit != null) {
            b |= 0x20;
        }
        return b;
    }

    int getWrittenPOIFlags(int POIGlobalFlags) {
        int flag = 0;
        int j = 0;
        int usedFields = this.getPOIFlags();
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            int mask = 1 << i;
            if ((mask & POIGlobalFlags) != mask) continue;
            if ((mask & usedFields) == mask) {
                flag |= 1 << j;
            }
            ++j;
        }
        return flag |= 0x80;
    }

    int calcOffset(int ofs, int POIGlobalFlags, int cityPtrSize, int zipPtrSize, int highwayPtrSize, int exitFacilityPtrSize) {
        this.offset = ofs;
        int size = 3;
        if (this.exit != null) {
            size += 3;
            size += highwayPtrSize;
            if (!this.exit.getFacilities().isEmpty()) {
                size += exitFacilityPtrSize;
            }
        }
        if (POIGlobalFlags != this.getPOIFlags()) {
            ++size;
        }
        if (this.simpleStreetNumber.isUsed()) {
            size += this.simpleStreetNumber.getSize();
        }
        if (this.streetNumberName != null) {
            size += 3;
        }
        if (this.simplePhoneNumber.isUsed()) {
            size += this.simplePhoneNumber.getSize();
        }
        if (this.complexPhoneNumber != null) {
            size += 3;
        }
        if (this.streetName != null) {
            size += 3;
        }
        if (this.city != null) {
            size += cityPtrSize;
        }
        if (this.zip != null) {
            size += zipPtrSize;
        }
        return size;
    }

    public int getOffset() {
        if (this.offset == -1) {
            throw new IllegalStateException("Offset not known yet.");
        }
        return this.offset;
    }

    public Label getNameLabel() {
        return this.poiName;
    }

    public City getCity() {
        return this.city;
    }

    class SimpleStreetPhoneNumber {
        private byte[] encodedNumber;
        private int encodedSize;

        SimpleStreetPhoneNumber() {
        }

        public boolean set(String str) {
            String number = str.trim();
            this.encodedNumber = new byte[number.length() / 2 + 2];
            int i = 0;
            int j = 0;
            while (i < number.length()) {
                int c2;
                int c1 = this.decodeChar(number.charAt(i++));
                int n = c2 = i < number.length() ? this.decodeChar(number.charAt(i++)) : 10;
                if (c1 < 0 || c1 > 10 || c2 < 0 || c2 > 10) {
                    return false;
                }
                int val = c1 * 11 + c2;
                if (j == 0) {
                    val |= 0x80;
                }
                this.encodedNumber[j++] = (byte)val;
            }
            if (j == 0) {
                return false;
            }
            if (j == 1) {
                this.encodedNumber[j++] = -8;
            } else {
                int n = j - 1;
                this.encodedNumber[n] = (byte)(this.encodedNumber[n] | 0x80);
            }
            this.encodedSize = j;
            return true;
        }

        public void write(ImgFileWriter writer) {
            writer.put(this.encodedNumber, 0, this.encodedSize);
        }

        public boolean isUsed() {
            return this.encodedSize > 0;
        }

        public int getSize() {
            return this.encodedSize;
        }

        private int decodeChar(char ch) {
            if (ch == '-') {
                return 10;
            }
            if (ch >= '0' && ch <= '9') {
                return ch - 48;
            }
            return -1;
        }
    }
}

