/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.writer;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.writer.AbstractOSMWriter;

public class OSMXMLWriter
extends AbstractOSMWriter {
    private final DecimalFormat numberFormat = new DecimalFormat("0.#######;-0.#######", new DecimalFormatSymbols(Locale.US));
    private Writer writer;
    private int index;
    private final char[] charBuf = new char[4096];

    public OSMXMLWriter(Area bounds, File outputDir, int mapId, int extra) {
        super(bounds, outputDir, mapId, extra);
    }

    @Override
    public void initForWrite() {
        String filename = String.format(Locale.ROOT, "%08d.osm.gz", this.mapId);
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.outputDir, filename));
            GZIPOutputStream zos = new GZIPOutputStream(fos);
            this.writer = new OutputStreamWriter((OutputStream)zos, StandardCharsets.UTF_8);
            this.writeHeader();
        }
        catch (IOException e) {
            System.out.println("Could not open or write file header. Reason: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void writeHeader() throws IOException {
        this.writeString("<?xml version='1.0' encoding='UTF-8'?>\n");
        String apiVersion = this.versionMethod == 1 ? "version='0.5'" : "version='0.6'";
        this.writeString("<osm " + apiVersion + " generator='splitter' upload='false'>\n");
        this.writeString("<bounds minlat='");
        this.writeLongDouble(Utils.toDegrees(this.bounds.getMinLat()));
        this.writeString("' minlon='");
        this.writeLongDouble(Utils.toDegrees(this.bounds.getMinLong()));
        this.writeString("' maxlat='");
        this.writeLongDouble(Utils.toDegrees(this.bounds.getMaxLat()));
        this.writeString("' maxlon='");
        this.writeLongDouble(Utils.toDegrees(this.bounds.getMaxLong()));
        this.writeString("'/>\n");
    }

    @Override
    public void finishWrite() {
        try {
            this.writeString("</osm>\n");
            this.flush();
            this.writer.close();
            this.writer = null;
        }
        catch (IOException e) {
            System.out.println("Could not write end of file: " + e);
        }
    }

    @Override
    public void write(Node node) throws IOException {
        this.writeString("<node id='");
        this.writeLong(node.getId());
        this.writeString("' lat='");
        this.writeDouble(node.getLat());
        this.writeString("' lon='");
        this.writeDouble(node.getLon());
        if (this.versionMethod != 1) {
            this.writeString("' version='" + this.getWriteVersion(node));
        }
        if (node.hasTags()) {
            this.writeString("'>\n");
            this.writeTags(node);
            this.writeString("</node>\n");
        } else {
            this.writeString("'/>\n");
        }
    }

    @Override
    public void write(Way way) throws IOException {
        this.writeString("<way id='");
        this.writeLong(way.getId());
        if (this.versionMethod != 1) {
            this.writeString("' version='" + this.getWriteVersion(way));
        }
        this.writeString("'>\n");
        LongArrayList refs = way.getRefs();
        for (int i = 0; i < refs.size(); ++i) {
            this.writeString("<nd ref='");
            this.writeLong(refs.get(i));
            this.writeString("'/>\n");
        }
        if (way.hasTags()) {
            this.writeTags(way);
        }
        this.writeString("</way>\n");
    }

    @Override
    public void write(Relation rel) throws IOException {
        this.writeString("<relation id='");
        this.writeLong(rel.getId());
        if (this.versionMethod != 1) {
            this.writeString("' version='" + this.getWriteVersion(rel));
        }
        this.writeString("'>\n");
        List<Relation.Member> memlist = rel.getMembers();
        for (Relation.Member m : memlist) {
            if (m.getType() == null || m.getRef() == 0L) {
                System.err.println("Invalid relation member found in relation " + rel.getId() + ": member type=" + m.getType() + ", ref=" + m.getRef() + ", role=" + m.getRole() + ". Ignoring this member");
                continue;
            }
            this.writeString("<member type='");
            this.writeAttribute(m.getType());
            this.writeString("' ref='");
            this.writeLong(m.getRef());
            this.writeString("' role='");
            if (m.getRole() != null) {
                this.writeAttribute(m.getRole());
            }
            this.writeString("'/>\n");
        }
        if (rel.hasTags()) {
            this.writeTags(rel);
        }
        this.writeString("</relation>\n");
    }

    private void writeTags(Element element) throws IOException {
        Iterator<Element.Tag> it = element.tagsIterator();
        while (it.hasNext()) {
            Element.Tag entry = it.next();
            this.writeString("<tag k='");
            this.writeAttribute(entry.getKey());
            this.writeString("' v='");
            this.writeAttribute(entry.getValue());
            this.writeString("'/>\n");
        }
    }

    private void writeAttribute(String value) throws IOException {
        block8: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\'': {
                    this.writeString("&apos;");
                    continue block8;
                }
                case '&': {
                    this.writeString("&amp;");
                    continue block8;
                }
                case '<': {
                    this.writeString("&lt;");
                    continue block8;
                }
                case '\n': {
                    this.writeString("&#xa;");
                    continue block8;
                }
                case '\r': {
                    this.writeString("&#xd;");
                    continue block8;
                }
                case '\t': {
                    this.writeString("&#9;");
                    continue block8;
                }
                default: {
                    this.writeChar(c);
                }
            }
        }
    }

    private void checkFlush(int i) throws IOException {
        if (this.charBuf.length - this.index < i) {
            this.flush();
        }
    }

    private void flush() throws IOException {
        this.writer.write(this.charBuf, 0, this.index);
        this.index = 0;
    }

    private void writeString(String value) throws IOException {
        int len;
        int start = 0;
        int end = value.length();
        while ((len = this.charBuf.length - this.index) < end - start) {
            value.getChars(start, start + len, this.charBuf, this.index);
            start += len;
            this.index = this.charBuf.length;
            this.flush();
        }
        value.getChars(start, end, this.charBuf, this.index);
        this.index += end - start;
    }

    private void writeLongDouble(double value) throws IOException {
        this.checkFlush(22);
        this.writeString(Double.toString(value));
    }

    private void writeDouble(double value) throws IOException {
        this.checkFlush(22);
        if (value < -200.0 || value > 200.0 || value > -1.0 && value < 1.0) {
            this.writeString(this.numberFormat.format(value));
        } else {
            if (value < 0.0) {
                this.charBuf[this.index++] = 45;
                value = -value;
            }
            int val = (int)Math.round(value * 1.0E7);
            StringBuilder s = new StringBuilder(Integer.toString(val));
            s.insert(s.length() - 7, '.');
            this.writeString(s.toString());
        }
    }

    private void writeLong(long value) throws IOException {
        this.checkFlush(20);
        this.writeString(Long.toString(value));
    }

    private void writeChar(char value) throws IOException {
        this.checkFlush(1);
        this.charBuf[this.index++] = value;
    }
}

