/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.tools;

import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.Arrays;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.tools.BitReader;
import uk.me.parabola.splitter.tools.BitWriter;

public final class SparseLong2IntMap {
    private static final boolean SELF_TEST = false;
    private static final int CHUNK_SIZE = 64;
    private static final int CHUNK_SHIFT = Integer.numberOfTrailingZeros(64);
    private static final int MAX_BYTES_FOR_VAL = 4;
    private static final int MAX_STORED_BYTES_FOR_CHUNK = 256;
    private static final int CHUNK_STORE_BITS_FOR_X = 32 - Integer.numberOfLeadingZeros(255);
    private static final int CHUNK_STORE_BITS_FOR_Z = 8;
    private static final int CHUNK_STORE_BITS_FOR_Y = 32 - (CHUNK_STORE_BITS_FOR_X + 8);
    private static final int CHUNK_STORE_ELEMS = 256;
    private static final int CHUNK_STORE_X_MASK = (1 << CHUNK_STORE_BITS_FOR_X) - 1;
    private static final int CHUNK_STORE_Y_MASK = (1 << CHUNK_STORE_BITS_FOR_Y) - 1;
    private static final int CHUNK_STORE_Z_MASK = 255;
    private static final int CHUNK_STORE_Y_SHIFT = CHUNK_STORE_BITS_FOR_X;
    private static final int CHUNK_STORE_Z_SHIFT = CHUNK_STORE_BITS_FOR_X + CHUNK_STORE_BITS_FOR_Y;
    private static final int BYTES_FOR_MASK = 8;
    private static final int TOP_ID_SHIFT = 27;
    private static final long CHUNK_ID_MASK = 0x7FFFFFFL;
    private static final int LARGE_VECTOR_SIZE = 0x200000;
    private static final int MAX_Y_VAL = 8193;
    private static final long CHUNK_OFFSET_MASK = 63L;
    private static final long OLD_CHUNK_ID_MASK = -64L;
    private static final long INVALID_CHUNK_ID = 1L;
    private int unassigned = Integer.MIN_VALUE;
    private long size;
    private long modCount;
    private long oldModCount;
    private long currentChunkId;
    private ChunkMem currentMem;
    private final int[] currentChunk = new int[64];
    private final int[] testChunk = new int[64];
    private final int[] maskedChunk = new int[64];
    private final int[] tmpChunk = new int[128];
    private static final int MAX_BYTES_FOR_RLE_CHUNK = 320;
    private final ByteBuffer bufEncoded = ByteBuffer.allocate(320);
    private static final int FLAG1_USED_BYTES_MASK = 3;
    private static final int FLAG1_RUNLEN_MASK = 28;
    private static final int FLAG1_DICTIONARY = 32;
    private static final int FLAG1_COMP_METHOD_BITS = 64;
    private static final int FLAG1_COMP_METHOD_RLE = 128;
    private static final int FLAG2_BITS_FOR_VALS = 31;
    private static final int FLAG2_ALL_POSITIVE = 32;
    private static final int FLAG2_ALL_NEGATIVE = 64;
    private static final int FLAG2_DICT_SIZE_IS_2 = 128;
    private static final int FLAG_BITS_FOR_DICT_SIZE = 32 - Integer.numberOfLeadingZeros(63);
    private static final int SINGLE_VAL_CHUNK_LEN_NO_FLAG = 3;
    private final String dataDesc;
    private Long2ObjectOpenHashMap<ChunkMem> topMap;
    static final long MAX_MEM = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
    static final int POINTER_SIZE = MAX_MEM < 32768L ? 4 : 8;
    private Integer bias1;
    private final BitWriter bitWriter = new BitWriter(1000);

    public SparseLong2IntMap(String dataDesc) {
        long reserve = ((1L << CHUNK_STORE_BITS_FOR_Y) - 1L) * 64L - 0x200000L;
        assert (reserve > 0L) : "Bad combination of constants";
        this.dataDesc = dataDesc;
        System.out.println(dataDesc + " Map: uses " + this.getClass().getSimpleName());
        this.clear();
    }

    private static int countUnder(long mask, int lowest) {
        return Long.bitCount(mask & (1L << lowest) - 1L);
    }

    static void putVal(ByteBuffer buf, int val, int bytesToUse) {
        switch (bytesToUse) {
            case 1: {
                assert (val >= -128 && val <= 127) : val + " of out Byte range";
                buf.put((byte)val);
                break;
            }
            case 2: {
                buf.putShort((short)val);
                break;
            }
            case 3: {
                buf.put((byte)(val & 0xFF));
                buf.putShort((short)(val >> 8));
                break;
            }
            default: {
                buf.putInt(val);
            }
        }
    }

    static int getVal(ByteBuffer buf, int bytesToUse) {
        switch (bytesToUse) {
            case 1: {
                return buf.get();
            }
            case 2: {
                return buf.getShort();
            }
            case 3: {
                byte b1 = buf.get();
                short s = buf.getShort();
                return b1 & 0xFF | s << 8;
            }
        }
        return buf.getInt();
    }

    private static int bitsNeeded(int val) {
        return 64 - Long.numberOfLeadingZeros(Math.abs(val)) + 1;
    }

    private ChunkMem getMem(long key) {
        long topID = key >> 27;
        if (this.currentMem == null || this.currentMem.topId != topID) {
            this.currentMem = this.topMap.get(topID);
        }
        return this.currentMem;
    }

    private void chunkCompress(int numVals, int minVal, int maxVal) {
        boolean useRLE;
        int flag1 = 64;
        int opos = 0;
        int maxRunLen = 0;
        int numCounts = 0;
        Int2IntLinkedOpenHashMap dict = new Int2IntLinkedOpenHashMap(32, 0.25f);
        dict.defaultReturnValue(-1);
        for (int i = 0; i < numVals; ++i) {
            int runLength = 1;
            while (i + 1 < numVals && this.maskedChunk[i] == this.maskedChunk[i + 1]) {
                ++runLength;
                ++i;
            }
            ++numCounts;
            int v = this.maskedChunk[i];
            if (dict.get(v) == dict.defaultReturnValue()) {
                dict.put(v, dict.size());
            }
            this.tmpChunk[opos++] = v;
            this.tmpChunk[opos++] = runLength;
            if (maxRunLen >= runLength) continue;
            maxRunLen = runLength;
        }
        int bias2 = this.maskedChunk[0];
        int bits = Math.max(SparseLong2IntMap.bitsNeeded(minVal - bias2), SparseLong2IntMap.bitsNeeded(maxVal - bias2));
        int sign = SparseLong2IntMap.getSign(minVal - bias2, maxVal - bias2);
        int bitsForRLE = SparseLong2IntMap.bitsNeeded(maxRunLen - 1) - 1;
        int bitsForVal = bits - Math.abs(sign);
        int bitsForPos = SparseLong2IntMap.bitsNeeded(dict.size() - 1) - 1;
        int bitsForDictFlag = dict.size() > 2 ? FLAG_BITS_FOR_DICT_SIZE : 0;
        int bitsForDict = bitsForDictFlag + (dict.size() - 1) * bitsForVal;
        int len1 = SparseLong2IntMap.toBytes((numVals - 1) * bitsForVal);
        int len2 = SparseLong2IntMap.toBytes(bitsForRLE + (numCounts - 1) * (bitsForRLE + bitsForVal));
        int len3 = SparseLong2IntMap.toBytes(bitsForDict + (numVals - 1) * bitsForPos);
        int len4 = SparseLong2IntMap.toBytes(bitsForDict + bitsForRLE + (numCounts - 1) * (bitsForRLE + (dict.size() > 2 ? bitsForPos : 0)));
        boolean bl = useRLE = numCounts < 5 && maxRunLen > 1 && Math.min(len2, len4) < Math.min(len1, len3);
        boolean useDict = useRLE ? len2 > len4 : len1 > len3;
        this.bitWriter.clear();
        if (useDict) {
            flag1 |= 0x20;
            if (dict.size() > 2) {
                this.bitWriter.putn(dict.size() - 1, FLAG_BITS_FOR_DICT_SIZE);
            }
            IntBidirectionalIterator iter = dict.keySet().iterator();
            iter.next();
            while (iter.hasNext()) {
                this.storeVal(iter.nextInt() - bias2, bits, sign);
            }
        }
        if (useRLE) {
            flag1 |= 0x80;
            flag1 |= bitsForRLE << 2 & 0x1C;
            boolean writeIndex = useDict && dict.size() > 2;
            int pos = 1;
            this.bitWriter.putn(this.tmpChunk[pos++] - 1, bitsForRLE);
            while (pos < opos) {
                int v = this.tmpChunk[pos++];
                if (!useDict) {
                    this.storeVal(v - bias2, bits, sign);
                } else if (writeIndex) {
                    int idx = dict.get(v);
                    this.bitWriter.putn(idx, bitsForPos);
                }
                this.bitWriter.putn(this.tmpChunk[pos++] - 1, bitsForRLE);
            }
        } else {
            for (int i = 1; i < numVals; ++i) {
                if (useDict) {
                    int v = this.maskedChunk[i];
                    this.bitWriter.putn(dict.get(v), bitsForPos);
                    continue;
                }
                this.storeVal(this.maskedChunk[i] - bias2, bits, sign);
            }
        }
        int bytesForBias = 0;
        bytesForBias = SparseLong2IntMap.bytesNeeded(bias2, bias2);
        flag1 |= bytesForBias - 1 & 3;
        int bwLen = this.bitWriter.getLength();
        int len = 2 + this.bitWriter.getLength() + bytesForBias;
        if (len < 256) {
            this.bufEncoded.put((byte)flag1);
            int flag2 = bits - 1 & 0x1F;
            if (sign > 0) {
                flag2 |= 0x20;
            } else if (sign < 0) {
                flag2 |= 0x40;
            }
            if (dict.size() == 2) {
                flag2 |= 0x80;
            }
            this.bufEncoded.put((byte)flag2);
            SparseLong2IntMap.putVal(this.bufEncoded, bias2, bytesForBias);
            this.bufEncoded.put(this.bitWriter.getBytes(), 0, this.bitWriter.getLength());
        } else {
            for (int i = 0; i < numVals; ++i) {
                SparseLong2IntMap.putVal(this.bufEncoded, this.currentChunk[i], 4);
            }
        }
    }

    private static int toBytes(int nBits) {
        return (nBits + 7) / 8;
    }

    private void storeVal(int val, int nb, int sign) {
        if (sign == 0) {
            this.bitWriter.sputn(val, nb);
        } else if (sign == 1) {
            this.bitWriter.putn(val, nb - 1);
        } else {
            this.bitWriter.putn(-val, nb - 1);
        }
    }

    private static int readVal(BitReader br, int bits, int sign) {
        if (sign == 0) {
            return br.sget(bits);
        }
        if (sign > 0) {
            return br.get(bits - 1);
        }
        return -br.get(bits - 1);
    }

    private static int getSign(int v1, int v2) {
        assert (v1 != v2);
        if (v1 < 0) {
            return v2 <= 0 ? -1 : 0;
        }
        if (v1 > 0) {
            return v2 >= 0 ? 1 : 0;
        }
        return v2 < 0 ? -1 : 1;
    }

    private void saveCurrentChunk() {
        if (this.currentChunkId == 1L || this.modCount == this.oldModCount) {
            return;
        }
        long mask = 0L;
        int simpleLen = 0;
        long elementMask = 1L;
        if (this.bias1 == null) {
            this.bias1 = this.findBias1();
        }
        int maxVal = Integer.MIN_VALUE;
        int minVal = Integer.MAX_VALUE;
        for (int i = 0; i < 64; ++i) {
            if (this.currentChunk[i] != this.unassigned) {
                int v = this.currentChunk[i] - this.bias1;
                if (minVal > v) {
                    minVal = v;
                }
                if (maxVal < v) {
                    maxVal = v;
                }
                this.maskedChunk[simpleLen++] = v;
                mask |= elementMask;
            }
            elementMask <<= 1;
        }
        this.bufEncoded.clear();
        this.bufEncoded.putLong(mask);
        if (minVal == maxVal) {
            int bytesFor1st = SparseLong2IntMap.bytesNeeded(minVal, maxVal);
            if (bytesFor1st > 3) {
                this.bufEncoded.put((byte)(bytesFor1st - 1));
            }
            SparseLong2IntMap.putVal(this.bufEncoded, this.maskedChunk[0], bytesFor1st);
        } else {
            this.chunkCompress(simpleLen, minVal, maxVal);
            assert (this.bufEncoded.position() > 3);
        }
        this.bufEncoded.flip();
        ChunkMem mem = this.getMem(this.currentChunkId);
        if (mem == null) {
            long topID = this.currentChunkId >> 27;
            mem = new ChunkMem(topID);
            this.topMap.put(topID, mem);
            this.currentMem = mem;
        }
        mem.putChunk(this.currentChunkId, this.bufEncoded);
    }

    static int bytesNeeded(long minVal, long maxVal) {
        if (minVal >= -128L && maxVal <= 127L) {
            return 1;
        }
        if (minVal >= -32768L && maxVal <= 32767L) {
            return 2;
        }
        if (minVal >= -8388608L && maxVal <= 0x7FFFFFL) {
            return 3;
        }
        return 4;
    }

    private int findBias1() {
        int minVal = Integer.MAX_VALUE;
        int maxVal = Integer.MIN_VALUE;
        for (int i = 0; i < 64; ++i) {
            if (this.currentChunk[i] == this.unassigned) continue;
            if (minVal > this.currentChunk[i]) {
                minVal = this.currentChunk[i];
            }
            if (maxVal >= this.currentChunk[i]) continue;
            maxVal = this.currentChunk[i];
        }
        int avg = minVal + (maxVal - minVal) / 2;
        if (avg < 0 && avg - Integer.MIN_VALUE < 127) {
            return -2147483521;
        }
        if (avg > 0 && Integer.MAX_VALUE - avg < 127) {
            return 2147483520;
        }
        return avg;
    }

    public boolean containsKey(long key) {
        return this.get(key) != this.unassigned;
    }

    public int put(long key, int val) {
        if (val == this.unassigned) {
            throw new IllegalArgumentException("Cannot store the value that is reserved as being unassigned. val=" + val);
        }
        long chunkId = key & 0xFFFFFFFFFFFFFFC0L;
        if (this.currentChunkId != chunkId) {
            this.replaceCurrentChunk(key);
        }
        int chunkoffset = (int)(key & 0x3FL);
        int out = this.currentChunk[chunkoffset];
        this.currentChunk[chunkoffset] = val;
        if (out == this.unassigned) {
            ++this.size;
        }
        if (out != val) {
            ++this.modCount;
        }
        return out;
    }

    private int decodeStoredChunk(long key, int[] targetChunk, int chunkOffset) {
        boolean isSingleValueChunk;
        long elementmask;
        ChunkMem mem = this.getMem(key);
        if (mem == null) {
            return this.unassigned;
        }
        ByteBuffer inBuf = mem.getStoredChunk(key, targetChunk == this.currentChunk);
        if (inBuf == null) {
            return this.unassigned;
        }
        long chunkMask = inBuf.getLong();
        if (targetChunk == null && (chunkMask & (elementmask = 1L << chunkOffset)) == 0L) {
            return this.unassigned;
        }
        int chunkLenNoMask = inBuf.remaining();
        byte flag = 0;
        int bytesToUse = 4;
        if (chunkLenNoMask == 256) {
            if (targetChunk == null) {
                inBuf.position(inBuf.position() + chunkOffset * bytesToUse);
                return SparseLong2IntMap.getVal(inBuf, bytesToUse);
            }
            for (int i = 0; i < 64; ++i) {
                targetChunk[i] = SparseLong2IntMap.getVal(inBuf, bytesToUse);
            }
            return this.unassigned;
        }
        if (chunkLenNoMask <= 3) {
            bytesToUse = chunkLenNoMask;
        } else {
            flag = inBuf.get();
            if ((flag & 0x40) != 0) {
                inBuf.position(inBuf.position() - 1);
                return this.decodeBits(chunkMask, targetChunk, chunkOffset, inBuf);
            }
            bytesToUse = (flag & 3) + 1;
        }
        int start = this.bias1 + SparseLong2IntMap.getVal(inBuf, bytesToUse);
        boolean bl = isSingleValueChunk = chunkLenNoMask <= 3 || chunkLenNoMask == 1 + bytesToUse;
        assert (isSingleValueChunk);
        if (targetChunk == null) {
            return start;
        }
        this.maskedChunk[0] = start;
        this.updateTargetChunk(targetChunk, chunkMask, isSingleValueChunk);
        return this.unassigned;
    }

    private void updateTargetChunk(int[] targetChunk, long chunkMask, boolean singleValueChunk) {
        if (targetChunk == null) {
            return;
        }
        int j = 0;
        int opos = 0;
        while (chunkMask != 0L) {
            if ((chunkMask & 1L) != 0L) {
                targetChunk[opos] = this.maskedChunk[j];
                if (!singleValueChunk) {
                    ++j;
                }
            }
            ++opos;
            chunkMask >>>= 1;
        }
    }

    private int decodeBits(long chunkMask, int[] targetChunk, int chunkOffset, ByteBuffer inBuf) {
        boolean readIndex;
        int dictSize;
        int val;
        boolean dictSizeIs2;
        byte flag1 = inBuf.get();
        assert ((flag1 & 0x40) != 0);
        int index = 65;
        if (targetChunk == null) {
            index = SparseLong2IntMap.countUnder(chunkMask, chunkOffset);
        }
        boolean useDict = (flag1 & 0x20) != 0;
        byte flag2 = inBuf.get();
        int bits = (flag2 & 0x1F) + 1;
        int sign = 0;
        if ((flag2 & 0x20) != 0) {
            sign = 1;
        } else if ((flag2 & 0x40) != 0) {
            sign = -1;
        }
        boolean bl = dictSizeIs2 = (flag2 & 0x80) != 0;
        assert (bits >= 1);
        int bias = this.bias1;
        int bytesFor1st = (flag1 & 3) + 1;
        bias = val = SparseLong2IntMap.getVal(inBuf, bytesFor1st) + bias;
        BitReader br = new BitReader(inBuf.array(), inBuf.position());
        if (index == 0) {
            return val;
        }
        int n = dictSize = dictSizeIs2 ? 2 : 1;
        if (useDict && !dictSizeIs2) {
            dictSize = br.get(FLAG_BITS_FOR_DICT_SIZE) + 1;
        }
        int[] dict = new int[dictSize];
        if (useDict) {
            dict[0] = val;
            for (int i = 1; i < dictSize; ++i) {
                dict[i] = SparseLong2IntMap.readVal(br, bits, sign) + bias;
            }
        }
        boolean useRLE = (flag1 & 0x80) != 0;
        int bitsForPos = SparseLong2IntMap.bitsNeeded(dictSize - 1) - 1;
        if (targetChunk == null && !useRLE) {
            if (useDict) {
                br.skip((index - 1) * bitsForPos);
                int dictPos = br.get(bitsForPos);
                return dict[dictPos];
            }
            int bitsToUse = bits - Math.abs(sign);
            br.skip((index - 1) * bitsToUse);
            return SparseLong2IntMap.readVal(br, bits, sign) + bias;
        }
        int bitsForRLE = useRLE ? (flag1 & 0x1C) >> 2 : 0;
        int mPos = 0;
        int dictPos = 0;
        int nVals = 0;
        int n2 = Long.bitCount(chunkMask);
        boolean bl2 = readIndex = dictSize > 2 || !useRLE;
        while (true) {
            if (useRLE) {
                int runLength = br.get(bitsForRLE) + 1;
                nVals += runLength;
            } else {
                ++nVals;
            }
            if (index < nVals) {
                return val;
            }
            if (targetChunk != null) {
                do {
                    this.maskedChunk[mPos++] = val;
                } while (mPos < nVals);
            }
            if (nVals >= n2) break;
            if (useDict) {
                dictPos = readIndex ? br.get(bitsForPos) : (dictPos == 0 ? 1 : 0);
                val = dict[dictPos];
                continue;
            }
            val = SparseLong2IntMap.readVal(br, bits, sign) + bias;
        }
        this.updateTargetChunk(targetChunk, chunkMask, false);
        return this.unassigned;
    }

    private void replaceCurrentChunk(long key) {
        this.saveCurrentChunk();
        Arrays.fill(this.currentChunk, this.unassigned);
        this.oldModCount = this.modCount;
        this.currentChunkId = key & 0xFFFFFFFFFFFFFFC0L;
        this.decodeStoredChunk(key, this.currentChunk, -1);
    }

    public int get(long key) {
        long chunkId = key & 0xFFFFFFFFFFFFFFC0L;
        int chunkoffset = (int)(key & 0x3FL);
        if (this.currentChunkId == chunkId) {
            return this.currentChunk[chunkoffset];
        }
        return this.decodeStoredChunk(key, null, chunkoffset);
    }

    public void clear() {
        this.topMap = new Long2ObjectOpenHashMap(16, 0.25f);
        Arrays.fill(this.currentChunk, 0);
        Arrays.fill(this.maskedChunk, 0);
        this.currentChunkId = 1L;
        this.currentMem = null;
        this.bias1 = null;
        this.size = 0L;
    }

    public long size() {
        return this.size;
    }

    public int defaultReturnValue() {
        return this.unassigned;
    }

    public void defaultReturnValue(int arg0) {
        this.unassigned = arg0;
    }

    public void stats(int msgLevel) {
        if (this.size() == 0L) {
            System.out.println(this.dataDesc + " Map is empty");
            return;
        }
        long totalBytes = (long)this.currentChunk.length * 4L;
        long totalChunks = 1L;
        for (ChunkMem mem : this.topMap.values()) {
            totalChunks += (long)mem.getChunkCount();
            totalBytes += mem.estimatedBytes;
        }
        long bytesPerKey = Math.round((double)totalBytes / (double)this.size());
        System.out.println(this.dataDesc + " Map: " + Utils.format(this.size()) + " stored long/int pairs require ca. " + bytesPerKey + " bytes per pair. " + Utils.format(totalChunks) + " chunks are used, the avg. number of values in one " + 64 + "-chunk is " + (totalChunks == 0L ? 0L : this.size() / totalChunks) + ".");
        if (msgLevel >= 0) {
            String details = this.dataDesc + " Map details: ~" + SparseLong2IntMap.bytesToMB(totalBytes) + ", including " + this.topMap.size() + " array(s) with " + SparseLong2IntMap.bytesToMB(0x800000L);
            System.out.println(details);
        }
        System.out.println();
    }

    private static String bytesToMB(long bytes) {
        return (bytes + 524288L >>> 20) + " MB";
    }

    static class ChunkMem {
        private final long topId;
        private long estimatedBytes;
        private int[] largeVector;
        private Int2ObjectOpenHashMap<IntArrayList> reusableChunks;
        private byte[][][] chunkStore;
        private final int[] freePosInStore;
        private int chunkCount;
        private int lastFlag;
        private long lastChunkId = 1L;
        private boolean checkReuse;

        public ChunkMem(long topID) {
            this.topId = topID;
            this.chunkStore = new byte[256][][];
            this.freePosInStore = new int[256];
            this.reusableChunks = new Int2ObjectOpenHashMap(0, 0.25f);
            this.largeVector = new int[0x200000];
            this.estimatedBytes = 8391990L;
        }

        private void grow(int x) {
            int newCapacity;
            int oldCapacity = this.chunkStore[x].length;
            int n = newCapacity = oldCapacity < 1024 ? oldCapacity * 2 : oldCapacity + (oldCapacity >> 1);
            if (newCapacity >= 8193) {
                newCapacity = 8193;
            }
            if (newCapacity <= oldCapacity) {
                return;
            }
            this.resize(x, newCapacity);
        }

        private void resize(int x, int newCapacity) {
            int oldCapacity = this.chunkStore[x].length;
            if (newCapacity < oldCapacity) assert (this.chunkStore[x][newCapacity] == null);
            this.chunkStore[x] = (byte[][])Arrays.copyOf(this.chunkStore[x], newCapacity);
            this.estimatedBytes += (long)((newCapacity - oldCapacity) * 8);
        }

        private void putChunk(long chunkId, ByteBuffer bufEncoded) {
            byte[] store;
            int z;
            int y;
            int len = bufEncoded.limit();
            int x = len - 9;
            if (this.chunkStore[x] == null) {
                this.chunkStore[x] = new byte[2][];
                this.estimatedBytes += 40L;
            }
            IntArrayList reusableChunk = null;
            int reuseFlag = 0;
            int lastX = -1;
            if (this.lastChunkId != (chunkId & 0xFFFFFFFFFFFFFFC0L)) {
                ++this.chunkCount;
            } else {
                lastX = this.lastFlag & CHUNK_STORE_X_MASK;
                if (x == lastX) {
                    reuseFlag = this.lastFlag;
                } else {
                    reusableChunk = this.reusableChunks.get(lastX);
                    if (reusableChunk == null) {
                        reusableChunk = new IntArrayList(8);
                        this.reusableChunks.put(lastX, reusableChunk);
                        this.estimatedBytes += (long)(60 + POINTER_SIZE + 16);
                        this.estimatedBytes += 20L;
                    }
                    reusableChunk.add(this.lastFlag);
                    this.checkReuse = true;
                }
            }
            if (x != lastX && this.checkReuse && (reusableChunk = this.reusableChunks.get(x)) != null && !reusableChunk.isEmpty()) {
                reuseFlag = reusableChunk.removeInt(reusableChunk.size() - 1);
            }
            if (reuseFlag != 0) {
                y = reuseFlag >> CHUNK_STORE_Y_SHIFT & CHUNK_STORE_Y_MASK;
                z = reuseFlag >> CHUNK_STORE_Z_SHIFT & 0xFF;
                store = this.chunkStore[x][--y];
            } else {
                int n = x;
                this.freePosInStore[n] = this.freePosInStore[n] + 1;
                y = this.freePosInStore[n] / 256;
                if (y >= this.chunkStore[x].length) {
                    this.grow(x);
                }
                if (this.chunkStore[x][y] == null) {
                    int numChunks = len < 16 ? 256 : 8;
                    this.chunkStore[x][y] = new byte[numChunks * len + 1];
                    this.estimatedBytes += (long)(24 + numChunks * len + 1);
                    int padding = 8 - (numChunks & 7);
                    if (padding < 8) {
                        this.estimatedBytes += (long)padding;
                    }
                }
                store = this.chunkStore[x][y];
                byte by = store[0];
                store[0] = (byte)(by + 1);
                z = by & 0xFF;
                if (len * (z + 1) + 1 > store.length) {
                    int newNum = Math.min(256, z + 8);
                    store = Arrays.copyOf(store, newNum * len + 1);
                    this.chunkStore[x][y] = store;
                    this.estimatedBytes += (long)((newNum - z) * len);
                }
            }
            ByteBuffer storeBuf = ByteBuffer.wrap(store, z * len + 1, len);
            storeBuf.put(bufEncoded);
            ++y;
            assert (x < 1 << CHUNK_STORE_BITS_FOR_X);
            assert (y < 1 << CHUNK_STORE_BITS_FOR_Y);
            assert (z < 256);
            int flag = (z & 0xFF) << CHUNK_STORE_Z_SHIFT | (y & CHUNK_STORE_Y_MASK) << CHUNK_STORE_Y_SHIFT | x & CHUNK_STORE_X_MASK;
            assert (flag != 0);
            int vectorPos = ChunkMem.getVectorPos(chunkId);
            this.largeVector[vectorPos] = flag;
        }

        private static int getVectorPos(long chunkId) {
            return (int)(chunkId & 0x7FFFFFFL) >> CHUNK_SHIFT;
        }

        private int getFlag(long chunkId) {
            int vectorPos = ChunkMem.getVectorPos(chunkId);
            return this.largeVector[vectorPos];
        }

        public int getChunkCount() {
            return this.chunkCount;
        }

        public ByteBuffer getStoredChunk(long key, boolean forUpdate) {
            int flag = this.getFlag(key);
            if (flag == 0) {
                return null;
            }
            int x = flag & CHUNK_STORE_X_MASK;
            int y = flag >> CHUNK_STORE_Y_SHIFT & CHUNK_STORE_Y_MASK;
            --y;
            int z = flag >> CHUNK_STORE_Z_SHIFT & 0xFF;
            int chunkLenWithMask = x + 1 + 8;
            int startPos = z * chunkLenWithMask + 1;
            if (forUpdate) {
                this.lastChunkId = key & 0xFFFFFFFFFFFFFFC0L;
                this.lastFlag = flag;
            }
            return ByteBuffer.wrap(this.chunkStore[x][y], startPos, chunkLenWithMask);
        }
    }
}

