/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.tools;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

public class OSMId2ObjectMap<V> {
    public static final long LOW_ID_MASK = 0x7FFFFFFL;
    public static final long TOP_ID_MASK = -134217728L;
    private static final int TOP_ID_SHIFT = Long.numberOfTrailingZeros(-134217728L);
    private Long2ObjectOpenHashMap<Int2ObjectOpenHashMap<V>> topMap = new Long2ObjectOpenHashMap();
    private int size;

    public V put(long key, V object) {
        int midId;
        V old;
        long topId = key >> TOP_ID_SHIFT;
        Int2ObjectOpenHashMap<V> midMap = this.topMap.get(topId);
        if (midMap == null) {
            midMap = new Int2ObjectOpenHashMap();
            this.topMap.put(topId, (Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<V>>)midMap);
        }
        if ((old = midMap.put(midId = (int)(key & 0x7FFFFFFL), object)) == null) {
            ++this.size;
        }
        return old;
    }

    public V get(long key) {
        long topId = key >> TOP_ID_SHIFT;
        Int2ObjectOpenHashMap<V> midMap = this.topMap.get(topId);
        if (midMap == null) {
            return null;
        }
        int midId = (int)(key & 0x7FFFFFFL);
        return midMap.get(midId);
    }

    public V remove(long key) {
        long topId = key >> TOP_ID_SHIFT;
        Int2ObjectOpenHashMap<V> midMap = this.topMap.get(topId);
        if (midMap == null) {
            return null;
        }
        int midId = (int)(key & 0x7FFFFFFL);
        V old = midMap.remove(midId);
        if (old == null) {
            return null;
        }
        if (midMap.isEmpty()) {
            this.topMap.remove(topId);
        }
        --this.size;
        return old;
    }

    public void clear() {
        this.topMap.clear();
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }
}

