/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.tools;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.tools.Long2IntClosedMapFunction;

public class Long2IntClosedMap
implements Long2IntClosedMapFunction {
    private static final long LOW_ID_MASK = 0x3FFFFFFFL;
    private static final long TOP_ID_MASK = -1073741824L;
    private static final int TOP_ID_SHIFT = Long.numberOfTrailingZeros(-1073741824L);
    private File tmpFile;
    private final String name;
    private LongArrayList index;
    private IntArrayList bounds;
    private int[] keys;
    private int[] vals;
    private final int maxSize;
    private final int unassigned;
    private int size;
    private long currentKey = Long.MIN_VALUE;
    private long oldTopId = Long.MIN_VALUE;
    private int currentVal;
    private DataInputStream dis;

    public Long2IntClosedMap(String name, int maxSize, int unassigned) {
        this.name = name;
        this.maxSize = maxSize;
        this.index = new LongArrayList();
        this.bounds = new IntArrayList();
        this.keys = new int[maxSize];
        this.unassigned = unassigned;
    }

    @Override
    public int add(long key, int val) {
        if (key == 0L || key == Long.MAX_VALUE) {
            throw new IllegalArgumentException("Error: Cannot store " + this.name + " id " + key + ", this value is reserved.");
        }
        if (this.keys == null) {
            throw new IllegalArgumentException(this.name + ": Add on read-only map requested");
        }
        if (this.size > 0 && this.currentKey >= key) {
            throw new IllegalArgumentException("New " + this.name + " id " + key + " is not higher than last id " + this.currentKey);
        }
        if (this.size + 1 > this.maxSize) {
            throw new IllegalArgumentException(this.name + " Map is full.");
        }
        long topId = key >> TOP_ID_SHIFT;
        if (topId != this.oldTopId) {
            this.index.add(topId);
            this.bounds.add(this.size);
            this.oldTopId = topId;
        }
        this.keys[this.size] = (int)(key & 0x3FFFFFFFL);
        if (val != this.unassigned) {
            if (this.vals == null) {
                this.allocVals();
            }
            this.vals[this.size] = val;
        }
        this.currentKey = key;
        ++this.size;
        return this.size - 1;
    }

    @Override
    public void switchToSeqAccess(File directory) throws IOException {
        this.tmpFile = File.createTempFile(this.name, null, directory);
        this.tmpFile.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(this.tmpFile);
             BufferedOutputStream stream = new BufferedOutputStream(fos);
             DataOutputStream dos = new DataOutputStream(stream);){
            long lastKey = Long.MIN_VALUE;
            if (this.vals != null) {
                for (int indexPos = 0; indexPos < this.index.size(); ++indexPos) {
                    long topId = this.index.getLong(indexPos);
                    int lowerBound = this.bounds.getInt(indexPos);
                    int upperBound = this.size;
                    if (indexPos + 1 < this.index.size()) {
                        upperBound = this.bounds.getInt(indexPos + 1);
                    }
                    long topVal = topId << TOP_ID_SHIFT;
                    for (int i = lowerBound; i < upperBound; ++i) {
                        long key = topVal | (long)this.keys[i] & 0x3FFFFFFFL;
                        int val = this.vals[i];
                        assert (i == 0 || lastKey < key);
                        lastKey = key;
                        if (val == this.unassigned) continue;
                        dos.writeLong(key);
                        dos.writeInt(val);
                    }
                }
            }
            dos.writeLong(Long.MAX_VALUE);
            dos.writeInt(Integer.MAX_VALUE);
            this.keys = null;
            this.vals = null;
            this.index = null;
            this.bounds = null;
            this.currentKey = Long.MIN_VALUE;
            System.out.println("Wrote " + this.size + " " + this.name + " pairs to " + this.tmpFile.getAbsolutePath());
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public int defaultReturnValue() {
        return this.unassigned;
    }

    @Override
    public int getRandom(long key) {
        if (this.vals == null) {
            return this.unassigned;
        }
        int pos = this.getKeyPos(key);
        if (pos >= 0) {
            return this.vals[pos];
        }
        return this.unassigned;
    }

    @Override
    public int getKeyPos(long key) {
        if (this.keys == null) {
            throw new IllegalArgumentException("random access on sequential-only map requested");
        }
        long topId = key >> TOP_ID_SHIFT;
        int indexPos = Arrays.binarySearch(this.index.toLongArray(), 0, this.index.size(), topId);
        if (indexPos < 0) {
            return -1;
        }
        int lowerBound = this.bounds.getInt(indexPos);
        int upperBound = this.size;
        if (this.bounds.size() > indexPos + 1) {
            upperBound = this.bounds.getInt(indexPos + 1);
        }
        int lowId = (int)(key & 0x3FFFFFFFL);
        int pos = Arrays.binarySearch(this.keys, lowerBound, upperBound, lowId);
        return pos;
    }

    @Override
    public int getSeq(long id) {
        if (this.currentKey == Long.MIN_VALUE) {
            this.dis = null;
            this.readPair();
        }
        while (id > this.currentKey) {
            this.readPair();
        }
        if (id < this.currentKey || id == Long.MAX_VALUE) {
            return this.unassigned;
        }
        return this.currentVal;
    }

    private void readPair() {
        try {
            if (this.dis == null) {
                this.open();
            }
            this.currentKey = this.dis.readLong();
            this.currentVal = this.dis.readInt();
        }
        catch (IOException e) {
            System.out.println(e);
            throw new SplitFailedException("Failed to read from temp file " + this.tmpFile);
        }
    }

    private void open() throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(this.tmpFile);
        BufferedInputStream stream = new BufferedInputStream(fis);
        this.dis = new DataInputStream(stream);
    }

    @Override
    public void finish() {
        if (this.tmpFile != null && this.tmpFile.exists()) {
            this.close();
            this.tmpFile.delete();
            System.out.println("temporary file " + this.tmpFile.getAbsolutePath() + " was deleted");
        }
    }

    @Override
    public void close() {
        this.currentKey = Long.MIN_VALUE;
        this.currentVal = this.unassigned;
        if (this.dis != null) {
            try {
                this.dis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int replace(long key, int val) {
        if (this.keys == null) {
            throw new IllegalArgumentException("replace on read-only map requested");
        }
        int pos = this.getKeyPos(key);
        if (pos < 0) {
            throw new IllegalArgumentException("replace on unknown key requested");
        }
        if (this.vals == null) {
            this.allocVals();
        }
        int oldVal = this.vals[pos];
        this.vals[pos] = val;
        return oldVal;
    }

    @Override
    public void stats(String prefix) {
        System.out.println(prefix + this.name + "WriterMap contains " + Utils.format(this.size) + " pairs.");
    }

    private void allocVals() {
        this.vals = new int[this.maxSize];
        Arrays.fill(this.vals, this.unassigned);
    }
}

