/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.solver;

import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.splitter.solver.Tile;

public class Solution {
    private final List<Tile> tiles;
    private final long maxNodes;
    private double worstAspectRatio = -1.0;
    private int numLowCount;
    private long worstMinNodes = Long.MAX_VALUE;

    public Solution(long maxNodes) {
        this.tiles = new ArrayList<Tile>();
        this.maxNodes = maxNodes;
    }

    public Solution copy() {
        Solution s = new Solution(this.maxNodes);
        this.tiles.forEach(s::add);
        return s;
    }

    public boolean add(Tile tile) {
        this.tiles.add(tile);
        double aspectRatio = tile.getAspectRatio();
        if (aspectRatio < 1.0) {
            aspectRatio = 1.0 / aspectRatio;
        }
        this.worstAspectRatio = Math.max(aspectRatio, this.worstAspectRatio);
        this.worstMinNodes = Math.min(tile.getCount(), this.worstMinNodes);
        if (tile.getCount() < this.maxNodes / 3L) {
            ++this.numLowCount;
        }
        return true;
    }

    public void merge(Solution other) {
        if (other.tiles.isEmpty()) {
            return;
        }
        if (this.tiles.isEmpty()) {
            this.worstAspectRatio = other.worstAspectRatio;
            this.worstMinNodes = other.worstMinNodes;
        } else {
            if (other.worstAspectRatio > this.worstAspectRatio) {
                this.worstAspectRatio = other.worstAspectRatio;
            }
            if (this.worstMinNodes > other.worstMinNodes) {
                this.worstMinNodes = other.worstMinNodes;
            }
        }
        this.numLowCount += other.numLowCount;
        this.tiles.addAll(other.tiles);
    }

    public List<Tile> getTiles() {
        return this.tiles;
    }

    public long getWorstMinNodes() {
        return this.worstMinNodes;
    }

    public double getWorstAspectRatio() {
        return this.worstAspectRatio;
    }

    public boolean isEmpty() {
        return this.tiles.isEmpty();
    }

    public int size() {
        return this.tiles.size();
    }

    public int compareTo(Solution other) {
        if (other == null) {
            return -1;
        }
        if (other == this) {
            return 0;
        }
        if (this.isEmpty() != other.isEmpty()) {
            return this.isEmpty() ? 1 : -1;
        }
        int d = Boolean.compare(this.isNice(), other.isNice());
        if (d != 0) {
            return -d;
        }
        if (this.worstMinNodes != other.worstMinNodes && Math.max(this.worstMinNodes, other.worstMinNodes) > 1000L) {
            return this.worstMinNodes > other.worstMinNodes ? -1 : 1;
        }
        double tileRatio = (double)this.tiles.size() / (double)other.tiles.size();
        double arRatio = this.worstAspectRatio / other.worstAspectRatio;
        if (tileRatio < 1.0 && tileRatio > 0.99 && arRatio > 1.5) {
            return 1;
        }
        if (tileRatio < 1.01 && tileRatio > 1.0 && arRatio < 0.66666) {
            return -1;
        }
        if (this.tiles.size() != other.tiles.size()) {
            return this.tiles.size() < other.tiles.size() ? -1 : 1;
        }
        if (this.worstAspectRatio != other.worstAspectRatio) {
            return this.worstAspectRatio < other.worstAspectRatio ? -1 : 1;
        }
        return 0;
    }

    public void trimOuterTiles() {
        boolean trimmedAny;
        do {
            trimmedAny = false;
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (Tile tile : this.tiles) {
                if (minX > tile.x) {
                    minX = tile.x;
                }
                if (minY > tile.y) {
                    minY = tile.y;
                }
                if ((double)maxX < tile.getMaxX()) {
                    maxX = (int)tile.getMaxX();
                }
                if (!((double)maxY < tile.getMaxY())) continue;
                maxY = (int)tile.getMaxY();
            }
            for (sides side : sides.values()) {
                block19: for (int direction = -1; direction <= 1; direction += 2) {
                    boolean trimmed;
                    int trimToPos = -1;
                    switch (side) {
                        case LEFT: 
                        case BOTTOM: {
                            trimToPos = Integer.MAX_VALUE;
                            break;
                        }
                        case TOP: 
                        case RIGHT: {
                            trimToPos = -1;
                        }
                    }
                    do {
                        RectangularShape candidate = null;
                        trimmed = false;
                        for (Tile tile : this.tiles) {
                            if (tile.getCount() == 0L) continue;
                            switch (side) {
                                case LEFT: {
                                    if (minX != tile.x || candidate != null && (direction >= 0 || ((Tile)candidate).y <= tile.y) && (direction <= 0 || !(candidate.getMaxY() < tile.getMaxY()))) break;
                                    candidate = tile;
                                    break;
                                }
                                case RIGHT: {
                                    if ((double)maxX != tile.getMaxX() || candidate != null && (direction >= 0 || ((Tile)candidate).y <= tile.y) && (direction <= 0 || !(candidate.getMaxY() < tile.getMaxY()))) break;
                                    candidate = tile;
                                    break;
                                }
                                case BOTTOM: {
                                    if (minY != tile.y || candidate != null && (direction >= 0 || ((Tile)candidate).x <= tile.x) && (direction <= 0 || !(candidate.getMaxX() < tile.getMaxX()))) break;
                                    candidate = tile;
                                    break;
                                }
                                case TOP: {
                                    if ((double)maxY != tile.getMaxY() || candidate != null && (direction >= 0 || ((Tile)candidate).x <= tile.x) && (direction <= 0 || !(candidate.getMaxX() < tile.getMaxX()))) break;
                                    candidate = tile;
                                }
                            }
                        }
                        if (candidate == null) continue block19;
                        Rectangle before = new Rectangle((Rectangle)candidate);
                        switch (side) {
                            case LEFT: {
                                while (((Tile)candidate).x < trimToPos && ((Tile)candidate).getColSum(0) == 0L) {
                                    ++((Tile)candidate).x;
                                    --((Tile)candidate).width;
                                }
                                if (((Tile)candidate).x >= trimToPos) break;
                                trimToPos = ((Tile)candidate).x;
                                break;
                            }
                            case RIGHT: {
                                while (candidate.getMaxX() > (double)trimToPos && ((Tile)candidate).getColSum(((Tile)candidate).width - 1) == 0L) {
                                    --((Tile)candidate).width;
                                }
                                if (!(candidate.getMaxX() > (double)trimToPos)) break;
                                trimToPos = (int)candidate.getMaxX();
                                break;
                            }
                            case BOTTOM: {
                                while (((Tile)candidate).y < trimToPos && ((Tile)candidate).getRowSum(0) == 0L) {
                                    ++((Tile)candidate).y;
                                    --((Tile)candidate).height;
                                }
                                if (((Tile)candidate).y >= trimToPos) break;
                                trimToPos = ((Tile)candidate).y;
                                break;
                            }
                            case TOP: {
                                while (candidate.getMaxY() > (double)trimToPos && ((Tile)candidate).getRowSum(((Tile)candidate).height - 1) == 0L) {
                                    --((Tile)candidate).height;
                                }
                                if (!(candidate.getMaxX() > (double)trimToPos)) break;
                                trimToPos = (int)candidate.getMaxY();
                            }
                        }
                        if (before.equals(candidate)) continue;
                        trimmed = true;
                        trimmedAny = true;
                    } while (trimmed);
                }
            }
        } while (trimmedAny);
    }

    public boolean isNice() {
        if (this.isEmpty() || this.worstAspectRatio > 4.0) {
            return false;
        }
        long low = this.maxNodes / 3L;
        if (this.tiles.size() == 1 || this.worstMinNodes >= low || this.numLowCount <= 2 && this.tiles.size() > 20 || this.numLowCount == 1 && this.tiles.size() > 4) {
            return true;
        }
        double lowRatio = 100.0 * (double)this.numLowCount / (double)this.tiles.size();
        return lowRatio < 3.0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "is empty";
        }
        long percentage = 100L * this.worstMinNodes / this.maxNodes;
        return this.tiles.size() + " tile(s). The smallest node count is " + this.worstMinNodes + " (" + percentage + " %)";
    }

    public boolean isSmallerOrBetter(Solution other) {
        if (this.isEmpty()) {
            return false;
        }
        if (other == null || other.isEmpty() && !this.isEmpty()) {
            return true;
        }
        if (other.size() > this.size()) {
            return true;
        }
        if (other.size() == this.size()) {
            return this.compareTo(other) < 0;
        }
        return false;
    }

    private static enum sides {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

