/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.solver;

import crosby.binary.file.BlockInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.xmlpull.v1.XmlPullParserException;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.parser.BinaryMapParser;
import uk.me.parabola.splitter.parser.OSMXMLParser;
import uk.me.parabola.splitter.solver.DensityMapCollector;

public class PrecompSeaReader {
    private static final int PRECOMP_RASTER = 32768;
    private static final byte SEA_TILE = 115;
    private static final byte LAND_TILE = 108;
    private static final byte MIXED_TILE = 109;
    private static final int MIN_LAT = Utils.toMapUnit(-90.0);
    private static final int MAX_LAT = Utils.toMapUnit(90.0);
    private static final int MIN_LON = Utils.toMapUnit(-180.0);
    private static final int MAX_LON = Utils.toMapUnit(180.0);
    private static final Pattern keySplitter = Pattern.compile(Pattern.quote("_"));
    private final Area bounds;
    private final File precompSeaDir;
    private byte[][] precompIndex;
    private String precompSeaExt;
    private String precompSeaPrefix;
    private String precompZipFileInternalPath;
    private ZipFile zipFile;

    public PrecompSeaReader(Area bounds, File precompSeaDir) {
        this.bounds = bounds;
        this.precompSeaDir = precompSeaDir;
        this.init();
    }

    public void processMap(DensityMapCollector processor) throws XmlPullParserException {
        for (String tileName : this.getPrecompKeyNames()) {
            InputStream is = this.getStream(tileName);
            if (is == null) continue;
            try {
                if (tileName.endsWith(".pbf")) {
                    BinaryMapParser binParser = new BinaryMapParser(processor, null, 0);
                    BlockInputStream blockinput = new BlockInputStream(is, binParser);
                    blockinput.process();
                    blockinput.close();
                    continue;
                }
                InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    OSMXMLParser parser = new OSMXMLParser(processor, true);
                    parser.setReader(reader);
                    parser.parse();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SplitFailedException(e.getMessage());
            }
        }
    }

    private void init() {
        if (this.precompSeaDir.exists()) {
            String internalPath = null;
            String indexFileName = "index.txt.gz";
            try {
                if (this.precompSeaDir.isDirectory()) {
                    File indexFile = new File(this.precompSeaDir, indexFileName);
                    if (!indexFile.exists()) {
                        indexFileName = "index.txt";
                        indexFile = new File(this.precompSeaDir, indexFileName);
                    }
                    if (indexFile.exists()) {
                        try (FileInputStream indexStream = new FileInputStream(indexFile);){
                            this.loadIndex(indexStream, indexFileName);
                        }
                    }
                    throw new IllegalArgumentException("Cannot find required index.txt[.gz] in " + this.precompSeaDir);
                }
                if (this.precompSeaDir.getName().endsWith(".zip")) {
                    this.zipFile = new ZipFile(this.precompSeaDir);
                    internalPath = "sea/";
                    ZipEntry entry = this.zipFile.getEntry(internalPath + indexFileName);
                    if (entry == null) {
                        indexFileName = "index.txt";
                        entry = this.zipFile.getEntry(internalPath + indexFileName);
                    }
                    if (entry == null) {
                        internalPath = "";
                        indexFileName = "index.txt.gz";
                        entry = this.zipFile.getEntry(internalPath + indexFileName);
                    }
                    if (entry != null) {
                        try (InputStream indexStream = this.zipFile.getInputStream(entry);){
                            this.precompZipFileInternalPath = internalPath;
                            this.loadIndex(indexStream, indexFileName);
                        }
                    }
                    throw new SplitFailedException("Don't know how to read " + this.precompSeaDir);
                }
                throw new SplitFailedException("Don't know how to read " + this.precompSeaDir);
            }
            catch (IOException exp) {
                exp.printStackTrace();
                throw new SplitFailedException("Cannot read index file " + indexFileName);
            }
        } else {
            throw new SplitFailedException("Directory or zip file with precompiled sea does not exist: " + this.precompSeaDir.getName());
        }
    }

    private void loadIndex(InputStream indexStream, String indexFileName) throws IOException {
        if (indexFileName.endsWith(".gz")) {
            try (GZIPInputStream stream = new GZIPInputStream(indexStream);){
                this.loadIndexFromStream(stream);
                return;
            }
        }
        this.loadIndexFromStream(indexStream);
    }

    private void loadIndexFromStream(InputStream fileStream) throws IOException {
        int indexWidth = (PrecompSeaReader.getPrecompTileStart(MAX_LON) - PrecompSeaReader.getPrecompTileStart(MIN_LON)) / 32768;
        int indexHeight = (PrecompSeaReader.getPrecompTileStart(MAX_LAT) - PrecompSeaReader.getPrecompTileStart(MIN_LAT)) / 32768;
        LineNumberReader indexReader = new LineNumberReader(new InputStreamReader(fileStream));
        Pattern csvSplitter = Pattern.compile(Pattern.quote(";"));
        String indexLine = null;
        byte[][] indexGrid = new byte[indexWidth + 1][indexHeight + 1];
        boolean detectExt = true;
        String prefix = null;
        String ext = null;
        while ((indexLine = indexReader.readLine()) != null) {
            int prePos;
            if (indexLine.startsWith("#")) continue;
            String[] items = csvSplitter.split(indexLine);
            if (items.length != 2) {
                throw new IllegalArgumentException("Invalid format in index file name: " + indexLine);
            }
            String precompKey = items[0];
            byte type = PrecompSeaReader.updatePrecompSeaTileIndex(precompKey, items[1], indexGrid);
            if (type == 63) {
                throw new IllegalArgumentException("Invalid format in index file name: " + indexLine);
            }
            if (type != 109 || (prePos = items[1].indexOf(items[0])) < 0) continue;
            if (detectExt) {
                prefix = items[1].substring(0, prePos);
                ext = items[1].substring(prePos + items[0].length());
                detectExt = false;
                continue;
            }
            StringBuilder sb = new StringBuilder(prefix);
            sb.append(precompKey);
            sb.append(ext);
            if (items[1].equals(sb.toString())) continue;
            throw new IllegalArgumentException("Unexpected file name in index file: " + indexLine);
        }
        this.precompIndex = indexGrid;
        this.precompSeaPrefix = prefix;
        this.precompSeaExt = ext;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getStream(String tileName) {
        Object var2_2 = null;
        try {
            void var2_5;
            if (this.zipFile != null) {
                ZipEntry entry = this.zipFile.getEntry(this.precompZipFileInternalPath + tileName);
                if (entry == null) throw new IOException("Preompiled sea tile " + tileName + " not found.");
                InputStream inputStream = this.zipFile.getInputStream(entry);
                return var2_5;
            } else {
                File precompTile = new File(this.precompSeaDir, tileName);
                FileInputStream fileInputStream = new FileInputStream(precompTile);
            }
            return var2_5;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw new SplitFailedException(exp.getMessage());
        }
    }

    private static int getPrecompTileStart(int value) {
        int rem = value % 32768;
        if (rem == 0) {
            return value;
        }
        if (value >= 0) {
            return value - rem;
        }
        return value - 32768 - rem;
    }

    private static int getPrecompTileEnd(int value) {
        int rem = value % 32768;
        if (rem == 0) {
            return value;
        }
        if (value >= 0) {
            return value + 32768 - rem;
        }
        return value - rem;
    }

    private List<String> getPrecompKeyNames() {
        ArrayList<String> precompKeys = new ArrayList<String>();
        for (int lat = PrecompSeaReader.getPrecompTileStart(this.bounds.getMinLat()); lat < PrecompSeaReader.getPrecompTileEnd(this.bounds.getMaxLat()); lat += 32768) {
            for (int lon = PrecompSeaReader.getPrecompTileStart(this.bounds.getMinLong()); lon < PrecompSeaReader.getPrecompTileEnd(this.bounds.getMaxLong()); lon += 32768) {
                int lonIndex = (MAX_LON - lon) / 32768;
                int latIndex = (MAX_LAT - lat) / 32768;
                byte type = this.precompIndex[lonIndex][latIndex];
                if (type != 109) continue;
                precompKeys.add(this.precompSeaPrefix + lat + "_" + lon + this.precompSeaExt);
            }
        }
        return precompKeys;
    }

    private static byte updatePrecompSeaTileIndex(String precompKey, String fileName, byte[][] indexGrid) {
        String[] tileCoords = keySplitter.split(precompKey);
        int type = 63;
        if (tileCoords.length == 2) {
            int lat = Integer.parseInt(tileCoords[0]);
            int lon = Integer.parseInt(tileCoords[1]);
            int latIndex = (MAX_LAT - lat) / 32768;
            int lonIndex = (MAX_LON - lon) / 32768;
            type = "sea".equals(fileName) ? 115 : ("land".equals(fileName) ? 108 : 109);
            indexGrid[lonIndex][latIndex] = type;
        }
        return (byte)type;
    }
}

