/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.solver;

import java.awt.Rectangle;
import java.util.BitSet;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.solver.DensityMap;

public class EnhancedDensityMap {
    private final DensityMap densityMap;
    private int[][] xyMap;
    private int[][] yxMap;
    private BitSet xyOutsidePolygon = new BitSet();
    private double[] aspectRatioFactor;
    private int minAspectRatioFactorPos;
    private int maxNodesInDensityMapGridElement = Integer.MIN_VALUE;
    private int maxNodesInDensityMapGridElementInPoly = Integer.MIN_VALUE;
    private java.awt.geom.Area polygonArea;

    public EnhancedDensityMap(DensityMap densities, java.awt.geom.Area polygonArea) {
        this.densityMap = densities;
        this.polygonArea = polygonArea;
        this.prepare();
    }

    private void prepare() {
        this.aspectRatioFactor = new double[this.densityMap.getHeight() + 1];
        int minLat = this.densityMap.getBounds().getMinLat();
        int maxLat = this.densityMap.getBounds().getMaxLat();
        int lat = 0;
        double maxAspectRatioFactor = Double.MIN_VALUE;
        int minPos = Integer.MAX_VALUE;
        for (int i = 0; i < this.aspectRatioFactor.length; ++i) {
            lat = minLat + i * (1 << this.densityMap.getShift());
            assert (lat <= maxLat);
            this.aspectRatioFactor[i] = Math.cos(Math.toRadians(Utils.toDegrees(lat)));
            if (!(maxAspectRatioFactor < this.aspectRatioFactor[i])) continue;
            maxAspectRatioFactor = this.aspectRatioFactor[i];
            minPos = i;
        }
        this.minAspectRatioFactorPos = minPos;
        assert (lat == maxLat);
        int width = this.densityMap.getWidth();
        int height = this.densityMap.getHeight();
        this.xyMap = new int[width][];
        int shift = this.densityMap.getShift();
        for (int x = 0; x < width; ++x) {
            int polyXPos = this.densityMap.getBounds().getMinLong() + (x << shift);
            int[] xCol = null;
            xCol = new int[height];
            boolean colNeeded = false;
            for (int y = 0; y < height; ++y) {
                int count = this.densityMap.getNodeCount(x, y);
                if (this.polygonArea != null) {
                    int polyYPos = this.densityMap.getBounds().getMinLat() + (y << shift);
                    if (this.polygonArea.intersects(polyXPos, polyYPos, 1 << shift, 1 << shift)) {
                        this.maxNodesInDensityMapGridElementInPoly = Math.max(count, this.maxNodesInDensityMapGridElementInPoly);
                    } else {
                        this.xyOutsidePolygon.set(x * height + y);
                    }
                }
                if (count <= 0) continue;
                this.maxNodesInDensityMapGridElement = Math.max(count, this.maxNodesInDensityMapGridElement);
                xCol[y] = count;
                colNeeded = true;
            }
            if (!colNeeded) continue;
            this.xyMap[x] = xCol;
        }
        this.yxMap = new int[height][];
        for (int y = 0; y < height; ++y) {
            boolean rowNeeded = false;
            int[] yRow = new int[width];
            for (int x = 0; x < width; ++x) {
                int count = 0;
                if (this.xyMap[x] != null) {
                    count = this.xyMap[x][y];
                }
                if (count <= 0) continue;
                rowNeeded = true;
                yRow[x] = count;
            }
            if (!rowNeeded) continue;
            this.yxMap[y] = yRow;
        }
    }

    public boolean isGridElemInPolygon(int x, int y) {
        if (this.polygonArea == null || this.xyOutsidePolygon.isEmpty()) {
            return true;
        }
        return !this.xyOutsidePolygon.get(x * this.densityMap.getHeight() + y);
    }

    public double getAspectRatio(Rectangle r) {
        double maxWidth;
        if (r.y < this.minAspectRatioFactorPos && r.y + r.height > this.minAspectRatioFactorPos) {
            maxWidth = r.width;
        } else {
            double width1 = (double)r.width * this.aspectRatioFactor[r.y];
            double width2 = (double)r.width * this.aspectRatioFactor[r.y + r.height];
            maxWidth = Math.max(width1, width2);
        }
        double ratio = maxWidth / (double)r.height;
        return ratio;
    }

    public Area getBounds() {
        return this.densityMap.getBounds();
    }

    public DensityMap getDensityMap() {
        return this.densityMap;
    }

    public long getNodeCount() {
        return this.densityMap.getNodeCount();
    }

    public int[] getMapRow(int mapRow) {
        return this.yxMap[mapRow];
    }

    public int[] getMapCol(int mapCol) {
        return this.xyMap[mapCol];
    }

    public double[] getAspectRatioFactor() {
        return this.aspectRatioFactor;
    }

    public int getMinAspectRatioFactorPos() {
        return this.minAspectRatioFactorPos;
    }

    public int getMaxNodesInDensityMapGridElement() {
        return this.maxNodesInDensityMapGridElement;
    }

    public int getMaxNodesInDensityMapGridElementInPoly() {
        return this.maxNodesInDensityMapGridElementInPoly;
    }

    public java.awt.geom.Area getPolygonArea() {
        return this.polygonArea;
    }

    public boolean allInsidePolygon() {
        return this.polygonArea == null || this.xyOutsidePolygon.isEmpty();
    }
}

