/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.solver;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.osmosis.core.filter.common.PolygonFileReader;
import org.xmlpull.v1.XmlPullParserException;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.OSMFileHandler;
import uk.me.parabola.splitter.RoundingUtils;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.args.SplitterParams;
import uk.me.parabola.splitter.solver.DensityMap;
import uk.me.parabola.splitter.solver.DensityMapCollector;
import uk.me.parabola.splitter.solver.PolygonDesc;
import uk.me.parabola.splitter.solver.PolygonDescProcessor;
import uk.me.parabola.splitter.solver.PrecompSeaReader;
import uk.me.parabola.splitter.solver.SplittableDensityArea;

public class AreasCalculator {
    private final List<PolygonDesc> polygons = new ArrayList<PolygonDesc>();
    private final int resolution;
    private final int numTiles;
    private final SplitterParams mainOptions;
    private final DensityMapCollector pass1Collector;
    private Area exactArea;

    public AreasCalculator(SplitterParams mainOptions, int numTiles) {
        this.mainOptions = mainOptions;
        this.resolution = mainOptions.getResolution();
        this.numTiles = numTiles;
        this.pass1Collector = new DensityMapCollector(mainOptions);
        this.readPolygonFile(mainOptions.getPolygonFile(), mainOptions.getMapid());
        this.readPolygonDescFile(mainOptions.getPolygonDescFile());
        int numPolygons = this.polygons.size();
        if (numPolygons > 0) {
            if (!this.checkPolygons()) {
                System.out.println("Warning: Bounding polygon is complex. Splitter might not be able to fit all tiles into the polygon!");
            }
            if (numTiles > 0) {
                System.out.println("Warning: bounding polygons are ignored because --num-tiles is used");
            }
        }
    }

    public boolean checkPolygons() {
        return this.polygons.stream().allMatch(pd -> AreasCalculator.checkPolygon(pd.getArea(), this.resolution));
    }

    private static boolean checkPolygon(java.awt.geom.Area mapPolygonArea, int resolution) {
        List<List<Point>> shapes = Utils.areaToShapes(mapPolygonArea);
        int shift = 24 - resolution;
        long rectangleWidth = 1L << shift;
        for (List<Point> shape : shapes) {
            int estimatedPoints = 0;
            Point p1 = shape.get(0);
            for (int i = 1; i < shape.size(); ++i) {
                Point p2 = shape.get(i);
                if (p1.x != p2.x && p1.y != p2.y) {
                    int width = Math.abs(p1.x - p2.x);
                    int height = Math.abs(p1.y - p2.y);
                    estimatedPoints = (int)((long)estimatedPoints + (long)Math.min(width, height) / rectangleWidth * 2L);
                }
                if (estimatedPoints > 40) {
                    return false;
                }
                p1 = p2;
            }
        }
        return true;
    }

    private void readPolygonFile(String polygonFile, int mapId) {
        if (polygonFile == null) {
            return;
        }
        this.polygons.clear();
        File f = new File(polygonFile);
        if (!f.exists()) {
            throw new IllegalArgumentException("polygon file doesn't exist: " + polygonFile);
        }
        PolygonFileReader polyReader = new PolygonFileReader(f);
        java.awt.geom.Area polygonInDegrees = polyReader.loadPolygon();
        PolygonDesc pd = new PolygonDesc(polyReader.getPolygonName(), Utils.AreaDegreesToMapUnit(polygonInDegrees), mapId);
        this.polygons.add(pd);
    }

    private void readPolygonDescFile(String polygonDescFile) {
        if (polygonDescFile == null) {
            return;
        }
        this.polygons.clear();
        if (!new File(polygonDescFile).exists()) {
            throw new IllegalArgumentException("polygon desc file doesn't exist: " + polygonDescFile);
        }
        PolygonDescProcessor polygonDescProcessor = new PolygonDescProcessor(this.resolution);
        OSMFileHandler polyDescHandler = new OSMFileHandler();
        polyDescHandler.setFileNames(Arrays.asList(polygonDescFile));
        polyDescHandler.setMixed(false);
        polyDescHandler.process(polygonDescProcessor);
        this.polygons.addAll(polygonDescProcessor.getPolygons());
    }

    public void fillDensityMap(OSMFileHandler osmFileHandler, File fileOutputDir) {
        long start = System.currentTimeMillis();
        File densityData = new File("densities.txt");
        File densityOutData = null;
        if (densityData.exists() && densityData.isFile()) {
            System.err.println("reading density data from " + densityData.getAbsolutePath());
            this.pass1Collector.readMap(densityData.getAbsolutePath());
        } else {
            osmFileHandler.execute(this.pass1Collector);
            densityOutData = new File(fileOutputDir, "densities-out.txt");
        }
        this.exactArea = this.pass1Collector.getExactArea();
        if (this.exactArea == null) {
            throw new SplitFailedException("no usable data in input file(s)");
        }
        System.out.println("Fill-densities-map pass took " + (System.currentTimeMillis() - start) + " ms");
        System.out.println("Exact map coverage read from input file(s) is " + this.exactArea);
        if (densityOutData != null) {
            this.pass1Collector.saveMap(densityOutData.getAbsolutePath());
        }
        if (this.polygons.size() == 1) {
            Rectangle polgonsBoundingBox = this.polygons.get(0).getArea().getBounds();
            this.exactArea = Area.calcArea(this.exactArea, polgonsBoundingBox);
            if (this.exactArea != null) {
                System.out.println("Exact map coverage after applying bounding box of polygon-file is " + this.exactArea);
            } else {
                throw new SplitFailedException("Exact map coverage after applying bounding box of polygon-file is an empty area");
            }
        }
        this.addPrecompSeaDensityData();
    }

    private void addPrecompSeaDensityData() {
        String precompSeaDir = this.mainOptions.getPrecompSea();
        if (precompSeaDir != null) {
            System.out.println("Counting nodes of precompiled sea data ...");
            long startSea = System.currentTimeMillis();
            DensityMapCollector seaCollector = new DensityMapCollector(this.mainOptions);
            PrecompSeaReader precompSeaReader = new PrecompSeaReader(this.exactArea, new File(precompSeaDir));
            try {
                precompSeaReader.processMap(seaCollector);
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            this.pass1Collector.mergeSeaData(seaCollector, !this.mainOptions.isNoTrim(), this.mainOptions.getResolution());
            System.out.println("Precompiled sea data pass took " + (System.currentTimeMillis() - startSea) + " ms");
        }
    }

    public List<Area> calcAreas() {
        List<Area> areas;
        Area roundedBounds = RoundingUtils.round(this.exactArea, this.mainOptions.getResolution());
        DensityMap densityMap = this.pass1Collector.getDensityMap();
        boolean trim = !this.mainOptions.isNoTrim();
        SplittableDensityArea splittableArea = new SplittableDensityArea(densityMap.subset(roundedBounds), this.mainOptions.getSearchLimit(), trim);
        if (!splittableArea.hasData()) {
            System.out.println("input file(s) have no data inside calculated bounding box");
            return Collections.emptyList();
        }
        System.out.println("Rounded map coverage is " + splittableArea.getBounds());
        splittableArea.setMapId(this.mainOptions.getMapid());
        long startSplit = System.currentTimeMillis();
        if (this.numTiles >= 2) {
            System.out.println("Splitting nodes into " + this.numTiles + " areas");
            areas = splittableArea.split(this.numTiles);
        } else {
            System.out.println("Splitting nodes into areas containing a maximum of " + Utils.format(this.mainOptions.getMaxNodes()) + " nodes each...");
            splittableArea.setMaxNodes(this.mainOptions.getMaxNodes());
            areas = splittableArea.split(this.polygons);
        }
        if (areas != null && !areas.isEmpty()) {
            System.out.println("Creating the initial areas took " + (System.currentTimeMillis() - startSplit) + " ms");
        }
        return areas;
    }

    public List<PolygonDesc> getPolygons() {
        return Collections.unmodifiableList(this.polygons);
    }
}

