/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.parser;

import org.xmlpull.v1.XmlPullParserException;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Convert;
import uk.me.parabola.splitter.MapProcessor;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.parser.ElementCounter;
import uk.me.parabola.splitter.xml.parser.AbstractXppParser;

public class OSMXMLParser
extends AbstractXppParser {
    private Node currentNode = new Node();
    private Way currentWay = new Way();
    private Relation currentRelation = new Relation();
    private final MapProcessor processor;
    private final ElementCounter elemCounter = new ElementCounter();
    private final boolean mixed;
    private boolean skipTags;
    private boolean skipNodes;
    private boolean skipWays;
    private boolean skipRels;
    private State state = State.None;
    private static final String[] BOUND_ATTRS = new String[]{"minlat", "minlon", "maxlat", "maxlon"};

    public OSMXMLParser(MapProcessor processor, boolean mixed) throws XmlPullParserException {
        this.processor = processor;
        this.mixed = mixed;
        this.skipTags = processor.skipTags();
        this.skipNodes = processor.skipNodes();
        this.skipWays = processor.skipWays();
        this.skipRels = processor.skipRels();
    }

    @Override
    public boolean startElement(String name) {
        switch (this.state) {
            case None: {
                String action = this.getAttr("action");
                if (action != null && action.equals("delete")) {
                    return false;
                }
                if (name.equals("node")) {
                    this.startNode();
                    break;
                }
                if (name.equals("way")) {
                    if (!this.skipWays) {
                        this.startWay();
                        break;
                    }
                    if (this.mixed || !this.skipRels) break;
                    return true;
                }
                if (name.equals("relation")) {
                    if (!this.skipRels) {
                        this.startRelation();
                        break;
                    }
                    if (this.mixed) break;
                    return true;
                }
                if (!name.equals("bounds") && !name.equals("bound")) break;
                this.processBounds();
                break;
            }
            case Node: {
                if (this.skipNodes) break;
                this.processNode(name);
                break;
            }
            case Way: {
                if (this.skipWays) break;
                this.processWay(name);
                break;
            }
            case Relation: {
                if (this.skipRels) break;
                this.processRelation(name);
            }
        }
        return false;
    }

    private void startNode() {
        String idStr = this.getAttr("id");
        String latStr = this.getAttr("lat");
        String lonStr = this.getAttr("lon");
        if (idStr == null || latStr == null || lonStr == null) {
            System.err.println("Node encountered with missing data. Bad/corrupt osm file? id=" + idStr + ", lat=" + latStr + ", lon=" + lonStr + ". Ignoring this node");
            return;
        }
        long id = Long.parseLong(idStr);
        double lat = Convert.parseDouble(latStr);
        double lon = Convert.parseDouble(lonStr);
        this.currentNode = new Node();
        this.currentNode.set(id, lat, lon);
        this.currentNode.setVersion(this.parseVersion());
        this.state = State.Node;
    }

    private void startWay() {
        this.currentWay = new Way();
        this.currentWay.setId(this.getLongAttr("id"));
        this.currentWay.setVersion(this.parseVersion());
        this.state = State.Way;
    }

    private void startRelation() {
        this.currentRelation = new Relation();
        this.currentRelation.setId(this.getLongAttr("id"));
        this.currentRelation.setVersion(this.parseVersion());
        this.state = State.Relation;
    }

    private int parseVersion() {
        String versionStr = this.getAttr("version");
        if (versionStr == null) {
            return 0;
        }
        return Integer.parseInt(versionStr);
    }

    private void processNode(CharSequence name) {
        if (name.equals("tag") && !this.skipTags) {
            this.currentNode.addTag(this.getAttr("k"), this.getAttr("v"));
        }
    }

    private void processWay(CharSequence name) {
        if (name.equals("nd")) {
            this.currentWay.addRef(this.getLongAttr("ref"));
        } else if (name.equals("tag") && !this.skipTags) {
            this.currentWay.addTag(this.getAttr("k"), this.getAttr("v"));
        }
    }

    private void processRelation(CharSequence name) {
        if (name.equals("tag")) {
            if (!this.skipTags) {
                this.currentRelation.addTag(this.getAttr("k"), this.getAttr("v"));
            }
        } else if (name.equals("member")) {
            String type = this.getAttr("type");
            long id = this.getLongAttr("ref");
            String role = this.getAttr("role");
            if (role == null) {
                role = "";
            }
            if ("node".equals(type)) {
                this.currentRelation.addMember("node", id, role);
            } else if ("way".equals(type)) {
                this.currentRelation.addMember("way", id, role);
            } else if ("relation".equals(type)) {
                this.currentRelation.addMember("relation", id, role);
            }
        }
    }

    private void processBounds() {
        String[] split;
        String boxStr = this.getAttr("box");
        if (boxStr == null) {
            split = new String[4];
            for (int i = 0; i < BOUND_ATTRS.length; ++i) {
                split[i] = this.getAttr(BOUND_ATTRS[i]);
                if (split[i] != null) continue;
                System.err.println("A <bounds/> tag was found but it has no 'box' attribute and no '" + BOUND_ATTRS[i] + "' attribute. Ignoring bounds");
                return;
            }
        } else {
            split = boxStr.split(",");
            if (split.length != 4) {
                System.err.println("A <bounds/> tag was found but its 'box' attribute contains an unexpected number of coordinates (expected 4, found " + split.length + "). Ignoring bounds");
                return;
            }
        }
        double[] coords = new double[4];
        int[] mapUnits = new int[4];
        for (int i = 0; i < 4; ++i) {
            try {
                coords[i] = Double.parseDouble(split[i].trim());
            }
            catch (NumberFormatException e) {
                System.err.println("A <bounds/> tag was found but it contains unexpected data. Unable to parse '" + split[i] + "' as a double. Ignoring bounds");
                return;
            }
            mapUnits[i] = Utils.toMapUnit(coords[i]);
        }
        Area bounds = new Area(mapUnits[0], mapUnits[1], mapUnits[2], mapUnits[3]);
        if (!bounds.verify()) {
            throw new IllegalArgumentException("invalid bbox area in osm file: " + bounds);
        }
        if (bounds.getMinLong() > bounds.getMaxLong()) {
            System.out.println("A <bounds/> tag was found but it crosses +/-180 the latitude line (western edge=" + Utils.toDegrees(bounds.getMinLong()) + ", eastern=" + Utils.toDegrees(bounds.getMaxLong()) + "). The splitter isn't currently able to deal with this, so the bounds are being ignored");
            return;
        }
        this.processor.boundTag(bounds);
        System.out.println("A <bounds/> tag was found. Area covered is " + bounds.toString());
    }

    @Override
    public void endElement(String name) {
        if (this.state == State.Node) {
            if (name.equals("node")) {
                if (!this.skipNodes) {
                    this.processor.processNode(this.currentNode);
                }
                this.state = State.None;
                this.elemCounter.countNode(this.currentNode.getId());
            }
        } else if (this.state == State.Way) {
            if (name.equals("way")) {
                if (!this.skipWays) {
                    this.processor.processWay(this.currentWay);
                }
                this.state = State.None;
                this.elemCounter.countWay(this.currentWay.getId());
            }
        } else if (this.state == State.Relation && name.equals("relation")) {
            if (!this.skipRels) {
                this.processor.processRelation(this.currentRelation);
            }
            this.state = State.None;
            this.elemCounter.countRelation(this.currentRelation.getId());
        }
    }

    private static enum State {
        Node,
        Way,
        Relation,
        None;

    }
}

