/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.args;

import uk.me.parabola.splitter.args.Option;
import uk.me.parabola.splitter.args.ThreadCount;

public interface SplitterParams {
    @Option(defaultValue="63240001", description="The starting map ID.")
    public int getMapid();

    @Option(description="A default description to give to each area.")
    public String getDescription();

    @Option(defaultValue="2048", description="The maximum number of areas to process in a single pass. More areas require more memory, but less time. Values: 1-9999.")
    public int getMaxAreas();

    @Option(defaultValue="auto", description="Deprecated. Nodes/ways/rels that fall outside an area will still be included if they are within this many map units. ")
    public String getOverlap();

    @Option(defaultValue="1600000", description="A threshold value that is used when no split-file is given. Splitting is done so that no tile has more than maxNodes nodes inside the bounding box of the tile. Nodes added by overlap or keep-complete are not taken into account.")
    public int getMaxNodes();

    @Option(description="A target value that is used when no split-file is given. Splitting is done so that the given number of tiles is produced. The max-nodes value is ignored if this option is given.")
    public String getNumTiles();

    @Option(defaultValue="13", description="The resolution determines how the tiles must be aligned.Eg a resolution of 13 means the tiles need to have their edges aligned to multiples of 2 ^ (24 - 13) = 2048 map units.")
    public int getResolution();

    @Option(description="Specify this if the input osm file has nodes, ways and relations intermingled.")
    public boolean isMixed();

    @Option(description="Deprecated, now does nothing")
    public String getCache();

    @Option(description="The path to the output directory. Defaults to the current working directory.")
    public String getOutputDir();

    @Option(description="The name of a file containing the areas definitions. Can be .list or .kml. Providing such a file will save processing time.")
    public String getSplitFile();

    @Option(description="The name of a GeoNames file to use for determining tile names. Typically cities15000.zip from http://download.geonames.org/export/dump/")
    public String getGeonamesFile();

    @Option(description="The name of a kml file to write out the areas to. This is in addition to areas.list (which is always written out).")
    public String getWriteKml();

    @Option(defaultValue="120", description="Displays the amount of memory used by the JVM every --status-freq seconds. Set =0 to disable.")
    public int getStatusFreq();

    @Option(description="Don't trim empty space off the edges of tiles.")
    public boolean isNoTrim();

    @Option(defaultValue="auto", description="The maximum number of threads used by splitter.")
    public ThreadCount getMaxThreads();

    @Option(defaultValue="pbf", description="The output type, either pbf, o5m, or xml.")
    public String getOutput();

    @Option(description="The name of a file containing ways and relations that are known to cause problems in the split process.")
    public String getProblemFile();

    @Option(defaultValue="true", description="Write complete ways and relations if possible (requires more time and more heap memory). This should be used with --overlap=0")
    public boolean isKeepComplete();

    @Option(description="The name of a file to write the generated problem list created with --keep-complete.")
    public String getProblemReport();

    @Option(description="The name of a file containing a bounding polygon in osmosis polygon file format.")
    public String getPolygonFile();

    @Option(description="An osm file (.o5m, .pbf, .osm) with named ways that describe bounding polygons with OSM ways having tags name and mapid")
    public String getPolygonDescFile();

    @Option(defaultValue="dist", description="Debugging: stop after the program phase. Can be split, gen-problem-list, or handle-problem-list")
    public String getStopAfter();

    @Option(description="The name of a directory containing precompiled sea tiles.")
    public String getPrecompSea();

    @Option(defaultValue="use-exclude-list", description="A comma separated list of tag values for relations. Used to filter multipolygon and boundary relations for problem-list processing.")
    public String getBoundaryTags();

    @Option(defaultValue="5", description="The lowest admin_level value that should be kept complete. Reasonable values are 2 .. 11. Used to filter boundary relations for problem-list processing. Ignored when keep-complete is false.")
    public int getWantedAdminLevel();

    @Option(defaultValue="200000", description="Search limit in split algo. Higher values may find better splits, but will take longer.")
    public int getSearchLimit();

    @Option(defaultValue="remove", description="Define how splitter treats version info in the osm data. Can be remove, fake, or keep")
    public String getHandleElementVersion();

    @Option(defaultValue="false", description="Specify if splitter should ignore bounds tags in input files")
    public boolean getIgnoreOsmBounds();

    @Option(defaultValue="", description="A comma separated list of tag values for route relations. Can be used to keep route relations of the given type complete. Only route values listed are kept complete. Default is empty.")
    public String getRouteRelValues();
}

