/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Utils;

public class RoundingUtils {
    public static int roundDown(int val, int shift) {
        return val >>> shift << shift;
    }

    public static int roundUp(int val, int shift) {
        return val + (1 << shift) - 1 >>> shift << shift;
    }

    public static int round(int val, int shift) {
        return val + (1 << shift - 1) >>> shift << shift;
    }

    public static Area round(Area b, int resolution) {
        int shift = 24 - resolution;
        int alignment = 1 << shift;
        int minLat = Math.max(b.getMinLat(), Utils.toMapUnit(-85.0));
        int maxLat = Math.min(b.getMaxLat(), Utils.toMapUnit(85.0));
        int roundedMinLat = RoundingUtils.roundDown(minLat, shift);
        int roundedMaxLat = RoundingUtils.roundUp(maxLat, shift);
        assert (roundedMinLat % alignment == 0) : "The area's min latitude is not aligned to a multiple of " + alignment;
        assert (roundedMaxLat % alignment == 0) : "The area's max latitude is not aligned to a multiple of " + alignment;
        int roundedMinLon = RoundingUtils.roundDown(b.getMinLong(), shift);
        int roundedMaxLon = RoundingUtils.roundUp(b.getMaxLong(), shift);
        if (roundedMinLon < -8388608) {
            roundedMinLon = -8388608;
        }
        if (roundedMaxLon > 0x800000) {
            roundedMaxLon = 0x800000;
        }
        assert (roundedMinLon % alignment == 0) : "The area's min longitude is not aligned to a multiple of " + alignment;
        assert (roundedMaxLon % alignment == 0) : "The area's max longitude is not aligned to a multiple of " + alignment;
        return new Area(roundedMinLat, roundedMinLon, roundedMaxLat, roundedMaxLon);
    }
}

