/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import java.util.concurrent.BlockingQueue;
import uk.me.parabola.splitter.AbstractMapProcessor;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.MapProcessor;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.OSMMessage;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.Way;

public class QueueProcessor
extends AbstractMapProcessor {
    private final BlockingQueue<OSMMessage> queue;
    private final MapProcessor realProcessor;
    private static final int NUM_STAGING = 1000;
    private Element[] staging;
    private int stagingPos;

    public QueueProcessor(BlockingQueue<OSMMessage> queue, MapProcessor realProcessor) {
        this.queue = queue;
        this.realProcessor = realProcessor;
        this.initStaging();
    }

    private void initStaging() {
        this.staging = new Element[1000];
        this.stagingPos = 0;
    }

    @Override
    public boolean skipTags() {
        return this.realProcessor.skipTags();
    }

    @Override
    public boolean skipNodes() {
        return this.realProcessor.skipNodes();
    }

    @Override
    public boolean skipWays() {
        return this.realProcessor.skipWays();
    }

    @Override
    public boolean skipRels() {
        return this.realProcessor.skipRels();
    }

    @Override
    public void boundTag(Area bounds) {
        this.addToQueue(bounds);
    }

    @Override
    public void processNode(Node n) {
        this.addToQueue(n);
    }

    @Override
    public void processWay(Way w) {
        this.addToQueue(w);
    }

    @Override
    public void processRelation(Relation r) {
        this.addToQueue(r);
    }

    @Override
    public void startFile() {
        try {
            this.flush();
            this.queue.put(new OSMMessage(OSMMessage.Type.START_FILE));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean endMap() {
        try {
            this.flush();
            this.queue.put(new OSMMessage(OSMMessage.Type.END_MAP));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public int getPhase() {
        throw new UnsupportedOperationException("call getPhase() of real processor");
    }

    private void addToQueue(Element el) {
        try {
            this.staging[this.stagingPos++] = el;
            if (this.stagingPos >= 1000) {
                this.flush();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void addToQueue(Area bounds) {
        try {
            this.flush();
            this.queue.put(new OSMMessage(bounds));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void flush() throws InterruptedException {
        if (this.staging == null || this.stagingPos == 0) {
            return;
        }
        this.queue.put(new OSMMessage(this.staging));
        this.initStaging();
    }
}

