/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.DataStorer;
import uk.me.parabola.splitter.MultiTileProcessor;
import uk.me.parabola.splitter.OSMFileHandler;
import uk.me.parabola.splitter.ProblemListProcessor;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.args.SplitterParams;

public class ProblemLists {
    private final LongArrayList problemWays = new LongArrayList();
    private final LongArrayList problemRels = new LongArrayList();
    private final TreeSet<Long> calculatedProblemWays = new TreeSet();
    private final TreeSet<Long> calculatedProblemRels = new TreeSet();

    public DataStorer calcProblemLists(OSMFileHandler osmFileHandler, List<Area> realAreas, int overlapAmount, SplitterParams mainOptions) {
        long startProblemListGenerator = System.currentTimeMillis();
        ArrayList<Area> distinctAreas = ProblemLists.getNonOverlappingAreas(realAreas);
        if (distinctAreas.size() > realAreas.size()) {
            System.err.println("Warning: The areas given in --split-file are overlapping.");
            TreeSet<Integer> overlappingTiles = new TreeSet<Integer>();
            for (int i = 0; i < realAreas.size(); ++i) {
                Area a1 = realAreas.get(i);
                for (int j = i + 1; j < realAreas.size(); ++j) {
                    Area a2 = realAreas.get(j);
                    if (!a1.overlaps(a2)) continue;
                    overlappingTiles.add(a1.getMapId());
                    overlappingTiles.add(a2.getMapId());
                    System.out.format("overlapping areas %08d and %08d : (%d,%d to %d,%d) and (%d,%d to %d,%d)\n", a1.getMapId(), a2.getMapId(), a1.getMinLat(), a1.getMinLong(), a1.getMaxLat(), a1.getMaxLong(), a2.getMinLat(), a2.getMinLong(), a2.getMaxLat(), a2.getMaxLong());
                    a1.overlaps(a2);
                }
            }
            if (!overlappingTiles.isEmpty()) {
                System.out.println("Overlaping tiles: " + ((Object)overlappingTiles).toString());
            }
        }
        System.out.println("Generating problem list for " + distinctAreas.size() + " distinct areas");
        List<Area> workAreas = ProblemLists.addPseudoAreas(distinctAreas);
        int numPasses = (int)Math.ceil((double)workAreas.size() / (double)mainOptions.getMaxAreas());
        int areasPerPass = (int)Math.ceil((double)workAreas.size() / (double)numPasses);
        if (numPasses > 1) {
            System.out.println("Processing " + distinctAreas.size() + " areas in " + numPasses + " passes, " + areasPerPass + " areas at a time");
        } else {
            System.out.println("Processing " + distinctAreas.size() + " areas in a single pass");
        }
        ArrayList<Area> allAreas = new ArrayList<Area>();
        System.out.println("Pseudo areas:");
        for (int j = 0; j < workAreas.size(); ++j) {
            Area area = workAreas.get(j);
            allAreas.add(area);
            if (!area.isPseudoArea()) continue;
            System.out.println("Pseudo area " + area.getMapId() + " covers " + area);
        }
        DataStorer distinctDataStorer = new DataStorer(workAreas, overlapAmount);
        System.out.println("Starting problem-list-generator pass(es)");
        for (int pass = 0; pass < numPasses; ++pass) {
            System.out.println("-----------------------------------");
            System.out.println("Starting problem-list-generator pass " + (pass + 1) + " of " + numPasses);
            long startThisPass = System.currentTimeMillis();
            int areaOffset = pass * areasPerPass;
            int numAreasThisPass = Math.min(areasPerPass, workAreas.size() - pass * areasPerPass);
            ProblemListProcessor processor = new ProblemListProcessor(distinctDataStorer, areaOffset, numAreasThisPass, mainOptions);
            boolean done = false;
            while (!done) {
                done = osmFileHandler.execute(processor);
                this.calculatedProblemWays.addAll(processor.getProblemWays());
                this.calculatedProblemRels.addAll(processor.getProblemRels());
            }
            System.out.println("Problem-list-generator pass " + (pass + 1) + " took " + (System.currentTimeMillis() - startThisPass) + " ms");
        }
        System.out.println("Problem-list-generator pass(es) took " + (System.currentTimeMillis() - startProblemListGenerator) + " ms");
        DataStorer dataStorer = new DataStorer(realAreas, overlapAmount);
        dataStorer.translateDistinctToRealAreas(distinctDataStorer);
        return dataStorer;
    }

    public boolean readProblemIds(String problemFileName) {
        File fProblem = new File(problemFileName);
        boolean ok = true;
        if (!fProblem.exists()) {
            System.out.println("Error: problem file doesn't exist: " + fProblem);
            return false;
        }
        try (FileInputStream fileStream = new FileInputStream(fProblem);
             LineNumberReader problemReader = new LineNumberReader(new InputStreamReader(fileStream));){
            String problemLine;
            Pattern csvSplitter = Pattern.compile(Pattern.quote(":"));
            Pattern commentSplitter = Pattern.compile(Pattern.quote("#"));
            while ((problemLine = problemReader.readLine()) != null) {
                String[] items = commentSplitter.split(problemLine);
                if (items.length == 0 || items[0].trim().isEmpty()) continue;
                if ((items = csvSplitter.split(items[0].trim())).length != 2) {
                    System.out.println("Error: Invalid format in problem file, line number " + problemReader.getLineNumber() + ": " + problemLine);
                    ok = false;
                    continue;
                }
                long id = 0L;
                try {
                    id = Long.parseLong(items[1]);
                }
                catch (NumberFormatException exp) {
                    System.out.println("Error: Invalid number format in problem file, line number " + problemReader.getLineNumber() + ": " + problemLine + exp);
                    ok = false;
                }
                if ("way".equals(items[0])) {
                    this.problemWays.add(id);
                    continue;
                }
                if ("rel".equals(items[0])) {
                    this.problemRels.add(id);
                    continue;
                }
                System.out.println("Error in problem file: Type not way or relation, line number " + problemReader.getLineNumber() + ": " + problemLine);
                ok = false;
            }
        }
        catch (IOException exp) {
            System.out.println("Error: Cannot read problem file " + fProblem + exp);
            return false;
        }
        return ok;
    }

    public void writeProblemList(File fileOutputDir, String fname) {
        try (PrintWriter w = new PrintWriter(new FileWriter(new File(fileOutputDir, fname)));){
            w.println("#");
            w.println("# This file can be given to splitter using the --problem-file option");
            w.println("#");
            w.println("# List of relations and ways that are known to cause problems");
            w.println("# in splitter or mkgmap");
            w.println("# Objects listed here are specially treated by splitter to assure");
            w.println("# that complete data is written to all related tiles");
            w.println("# Format:");
            w.println("# way:<id>");
            w.println("# rel:<id>");
            w.println("# ways");
            for (long id : this.calculatedProblemWays) {
                w.println("way: " + id + " #");
            }
            w.println("# rels");
            for (long id : this.calculatedProblemRels) {
                w.println("rel: " + id + " #");
            }
            w.println();
        }
        catch (IOException e) {
            System.err.println("Warning: Could not write problem-list file " + fname + ", processing continues");
        }
    }

    public void calcMultiTileElements(DataStorer dataStorer, OSMFileHandler osmFileHandler) {
        this.problemWays.addAll((Collection<? extends Long>)this.calculatedProblemWays);
        this.problemRels.addAll((Collection<? extends Long>)this.calculatedProblemRels);
        this.calculatedProblemRels.clear();
        this.calculatedProblemWays.clear();
        if (this.problemWays.isEmpty() && this.problemRels.isEmpty()) {
            return;
        }
        MultiTileProcessor multiProcessor = new MultiTileProcessor(dataStorer, this.problemWays, this.problemRels);
        this.problemRels.clear();
        this.problemWays.clear();
        this.problemRels.trim();
        this.problemWays.trim();
        boolean done = false;
        long startThisPhase = System.currentTimeMillis();
        int prevPhase = -1;
        while (!done) {
            int phase = multiProcessor.getPhase();
            if (prevPhase != phase) {
                startThisPhase = System.currentTimeMillis();
                System.out.println("-----------------------------------");
                System.out.println("Executing multi-tile analyses phase " + phase);
            }
            done = osmFileHandler.execute(multiProcessor);
            prevPhase = phase;
            if (!done && phase == multiProcessor.getPhase()) continue;
            System.out.println("Multi-tile analyses phase " + phase + " took " + (System.currentTimeMillis() - startThisPhase) + " ms");
        }
        System.out.println("-----------------------------------");
    }

    public static List<Area> addPseudoAreas(List<Area> realAreas) {
        ArrayList<Area> areas = new ArrayList<Area>(realAreas);
        Rectangle planetBounds = new Rectangle(Utils.toMapUnit(-180.0), Utils.toMapUnit(-90.0), 2 * Utils.toMapUnit(180.0), 2 * Utils.toMapUnit(90.0));
        while (!ProblemLists.checkIfCovered(planetBounds, areas)) {
            boolean changed = ProblemLists.addPseudoArea(areas);
            if (changed) continue;
            throw new SplitFailedException("Failed to fill planet with pseudo-areas");
        }
        return areas;
    }

    private static java.awt.geom.Area simplifyArea(java.awt.geom.Area area) {
        if (area.isEmpty() || area.isRectangular()) {
            return area;
        }
        java.awt.geom.Area bbox = new java.awt.geom.Area(area.getBounds2D());
        bbox.subtract(area);
        if (bbox.isEmpty()) {
            return new java.awt.geom.Area(area.getBounds2D());
        }
        return area;
    }

    private static boolean checkIfCovered(Rectangle bounds, ArrayList<Area> areas) {
        java.awt.geom.Area bbox = new java.awt.geom.Area(bounds);
        long sumTiles = 0L;
        for (Area area : areas) {
            sumTiles += (long)area.getHeight() * (long)area.getWidth();
            bbox.subtract(area.getJavaArea());
        }
        long areaBox = (long)bounds.height * (long)bounds.width;
        if (sumTiles != areaBox) {
            return false;
        }
        return bbox.isEmpty();
    }

    public static ArrayList<Area> getNonOverlappingAreas(List<Area> realAreas) {
        Rectangle r1;
        java.awt.geom.Area covered = new java.awt.geom.Area();
        ArrayList<Area> splitList = new ArrayList<Area>();
        int artificialId = -99999999;
        boolean foundOverlap = false;
        for (Area area1 : realAreas) {
            r1 = area1.getRect();
            if (!covered.intersects(r1)) {
                splitList.add(area1);
            } else {
                if (!foundOverlap) {
                    foundOverlap = true;
                    System.out.println("Removing overlaps from tiles...");
                }
                ArrayList<Area> splitAreas = new ArrayList<Area>();
                for (int j = 0; j < splitList.size(); ++j) {
                    Rectangle[] clippers;
                    Rectangle r2;
                    Area area2 = splitList.get(j);
                    if (area2 == null || !r1.intersects(r2 = area2.getRect())) continue;
                    java.awt.geom.Area overlap = new java.awt.geom.Area(area1.getRect());
                    overlap.intersect(area2.getJavaArea());
                    Rectangle ro = overlap.getBounds();
                    if (ro.height == 0 || ro.width == 0) continue;
                    Area aNew = new Area(ro.y, ro.x, (int)ro.getMaxY(), (int)ro.getMaxX());
                    aNew.setMapId(artificialId++);
                    aNew.setName("" + area1.getMapId());
                    aNew.setJoinable(false);
                    covered.subtract(area2.getJavaArea());
                    covered.add(overlap);
                    splitList.set(j, aNew);
                    java.awt.geom.Area coveredByPair = new java.awt.geom.Area(r1);
                    coveredByPair.add(new java.awt.geom.Area(r2));
                    java.awt.geom.Area originalPair = new java.awt.geom.Area(coveredByPair);
                    int minX = coveredByPair.getBounds().x;
                    int minY = coveredByPair.getBounds().y;
                    int maxX = (int)coveredByPair.getBounds().getMaxX();
                    int maxY = (int)coveredByPair.getBounds().getMaxY();
                    coveredByPair.subtract(overlap);
                    if (coveredByPair.isEmpty()) continue;
                    coveredByPair.subtract(covered);
                    java.awt.geom.Area testSplit = new java.awt.geom.Area(overlap);
                    Rectangle[] rectPair = new Rectangle[]{r1, r2};
                    Area[] areaPair = new Area[]{area1, area2};
                    int lx = minX;
                    int lw = ro.x - minX;
                    int rx = (int)ro.getMaxX();
                    int rw = maxX - rx;
                    int uy = (int)ro.getMaxY();
                    int uh = maxY - uy;
                    int by = minY;
                    int bh = ro.y - by;
                    for (Rectangle clipper : clippers = new Rectangle[]{new Rectangle(lx, minY, lw, bh), new Rectangle(ro.x, minY, ro.width, bh), new Rectangle(rx, minY, rw, bh), new Rectangle(lx, ro.y, lw, ro.height), new Rectangle(rx, ro.y, rw, ro.height), new Rectangle(lx, uy, lw, uh), new Rectangle(ro.x, uy, ro.width, uh), new Rectangle(rx, uy, rw, uh)}) {
                        for (int k = 0; k <= 1; ++k) {
                            Rectangle test = clipper.intersection(rectPair[k]);
                            if (test.isEmpty()) continue;
                            testSplit.add(new java.awt.geom.Area(test));
                            if (k != 1 && covered.intersects(test)) continue;
                            aNew = new Area(test.y, test.x, (int)test.getMaxY(), (int)test.getMaxX());
                            aNew.setMapId(areaPair[k].getMapId());
                            splitAreas.add(aNew);
                            covered.add(aNew.getJavaArea());
                        }
                    }
                    assert (testSplit.equals(originalPair));
                }
                for (Area splitArea : splitAreas) {
                    if (splitArea.isJoinable()) {
                        for (int j = 0; j < splitList.size(); ++j) {
                            Area area = splitList.get(j);
                            if (area == null || !area.isJoinable() || area.getMapId() != splitArea.getMapId()) continue;
                            boolean doJoin = false;
                            if (splitArea.getMaxLat() == area.getMaxLat() && splitArea.getMinLat() == area.getMinLat() && (splitArea.getMinLong() == area.getMaxLong() || splitArea.getMaxLong() == area.getMinLong())) {
                                doJoin = true;
                            } else if (splitArea.getMinLong() == area.getMinLong() && splitArea.getMaxLong() == area.getMaxLong() && (splitArea.getMinLat() == area.getMaxLat() || splitArea.getMaxLat() == area.getMinLat())) {
                                doJoin = true;
                            }
                            if (!doJoin) continue;
                            splitArea = area.add(splitArea);
                            splitArea.setMapId(area.getMapId());
                            splitList.set(j, splitArea);
                            splitArea = null;
                            break;
                        }
                    }
                    if (splitArea == null) continue;
                    splitList.add(splitArea);
                }
            }
            covered.add(new java.awt.geom.Area(r1));
        }
        covered.reset();
        Iterator iter = splitList.iterator();
        while (iter.hasNext()) {
            Area a = (Area)iter.next();
            if (a == null) {
                iter.remove();
                continue;
            }
            r1 = a.getRect();
            if (covered.intersects(r1)) {
                throw new SplitFailedException("Failed to create list of distinct areas");
            }
            covered.add(a.getJavaArea());
        }
        return splitList;
    }

    private static boolean addPseudoArea(ArrayList<Area> areas) {
        Rectangle[] topAndBottom;
        int oldSize = areas.size();
        Rectangle planetBounds = new Rectangle(Utils.toMapUnit(-180.0), Utils.toMapUnit(-90.0), 2 * Utils.toMapUnit(180.0), 2 * Utils.toMapUnit(90.0));
        java.awt.geom.Area uncovered = new java.awt.geom.Area(planetBounds);
        java.awt.geom.Area covered = new java.awt.geom.Area();
        for (Area area : areas) {
            uncovered.subtract(area.getJavaArea());
            covered.add(area.getJavaArea());
        }
        Rectangle rCov = covered.getBounds();
        for (Rectangle border : topAndBottom = new Rectangle[]{new Rectangle(planetBounds.x, (int)rCov.getMaxY(), planetBounds.width, (int)(planetBounds.getMaxY() - rCov.getMaxY())), new Rectangle(planetBounds.x, planetBounds.y, planetBounds.width, rCov.y - planetBounds.y)}) {
            if (border.isEmpty()) continue;
            uncovered.subtract(new java.awt.geom.Area(border));
            covered.add(new java.awt.geom.Area(border));
            Area pseudo = new Area(border.y, border.x, (int)border.getMaxY(), (int)border.getMaxX());
            pseudo.setMapId(-1 * (areas.size() + 1));
            pseudo.setPseudoArea(true);
            areas.add(pseudo);
        }
        while (!uncovered.isEmpty()) {
            boolean changed = false;
            List<List<Point>> shapes = Utils.areaToShapes(uncovered);
            int minX = uncovered.getBounds().x;
            int nextX = Integer.MAX_VALUE;
            for (int i = 0; i < shapes.size(); ++i) {
                List<Point> shape = shapes.get(i);
                for (Point point : shape) {
                    int lon = point.x;
                    if (lon >= nextX || lon <= minX) continue;
                    nextX = lon;
                }
            }
            java.awt.geom.Area stripeLon = new java.awt.geom.Area(new Rectangle(minX, planetBounds.y, nextX - minX, planetBounds.height));
            stripeLon.subtract(covered);
            assert (!stripeLon.isEmpty());
            List<List<Point>> stripeShapes = Utils.areaToShapes(stripeLon);
            for (int j = 0; j < stripeShapes.size(); ++j) {
                List<Point> rectShape = stripeShapes.get(j);
                java.awt.geom.Area test = Utils.shapeToArea(rectShape);
                test = ProblemLists.simplifyArea(test);
                assert (test.isRectangular());
                Rectangle pseudoRect = test.getBounds();
                if (!uncovered.contains(pseudoRect)) continue;
                assert (test.getBounds().width == stripeLon.getBounds().width);
                boolean wasMerged = false;
                for (int k = areas.size() - 1; k >= oldSize; --k) {
                    Area prev = areas.get(k);
                    if (prev.getMaxLong() < pseudoRect.x || !prev.isPseudoArea() || prev.getHeight() != pseudoRect.height || prev.getMaxLong() != pseudoRect.x || prev.getMinLat() != pseudoRect.y) continue;
                    Area pseudo = prev.add(new Area(pseudoRect.y, pseudoRect.x, (int)pseudoRect.getMaxY(), (int)pseudoRect.getMaxX()));
                    pseudo.setMapId(prev.getMapId());
                    pseudo.setPseudoArea(true);
                    areas.set(k, pseudo);
                    wasMerged = true;
                    break;
                }
                if (!wasMerged) {
                    Area pseudo = new Area(pseudoRect.y, pseudoRect.x, (int)pseudoRect.getMaxY(), (int)pseudoRect.getMaxX());
                    pseudo.setMapId(-1 * (areas.size() + 1));
                    pseudo.setPseudoArea(true);
                    areas.add(pseudo);
                }
                uncovered.subtract(test);
                covered.add(test);
                changed = true;
            }
            if (changed) continue;
            break;
        }
        return oldSize != areas.size();
    }
}

