/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import crosby.binary.file.BlockInputStream;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.xmlpull.v1.XmlPullParserException;
import uk.me.parabola.splitter.MapProcessor;
import uk.me.parabola.splitter.OSMMessage;
import uk.me.parabola.splitter.QueueProcessor;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.parser.BinaryMapParser;
import uk.me.parabola.splitter.parser.O5mMapParser;
import uk.me.parabola.splitter.parser.OSMXMLParser;

public class OSMFileHandler {
    private List<String> filenames;
    private final HashMap<String, ShortArrayList> blockTypeMap = new HashMap();
    private final HashMap<String, long[]> skipArrayMap = new HashMap();
    private boolean mixed;
    private int maxThreads = 1;
    RuntimeException exception = null;

    public void setFileNames(List<String> filenames) {
        this.filenames = filenames;
    }

    public void setMixed(boolean f) {
        this.mixed = f;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public boolean process(MapProcessor processor) {
        for (String filename : this.filenames) {
            System.out.println("Processing " + filename);
            processor.startFile();
            try {
                Throwable throwable;
                File file;
                if (filename.endsWith(".o5m")) {
                    file = new File(filename);
                    RandomAccessFile raf = new RandomAccessFile(file, "r");
                    Throwable throwable2 = null;
                    try {
                        FileChannel fileChannel = raf.getChannel();
                        throwable = null;
                        try {
                            long[] skipArray = this.skipArrayMap.get(filename);
                            O5mMapParser o5mParser = new O5mMapParser(processor, fileChannel, skipArray);
                            o5mParser.parse();
                            if (skipArray != null) continue;
                            skipArray = o5mParser.getNextSkipArray();
                            this.skipArrayMap.put(filename, skipArray);
                            continue;
                        }
                        catch (Throwable skipArray) {
                            throwable = skipArray;
                            throw skipArray;
                        }
                        finally {
                            if (fileChannel == null) continue;
                            if (throwable != null) {
                                try {
                                    fileChannel.close();
                                }
                                catch (Throwable skipArray) {
                                    throwable.addSuppressed(skipArray);
                                }
                                continue;
                            }
                            fileChannel.close();
                            continue;
                        }
                    }
                    catch (Throwable fileChannel) {
                        throwable2 = fileChannel;
                        throw fileChannel;
                    }
                    finally {
                        if (raf == null) continue;
                        if (throwable2 != null) {
                            try {
                                raf.close();
                            }
                            catch (Throwable fileChannel) {
                                throwable2.addSuppressed(fileChannel);
                            }
                            continue;
                        }
                        raf.close();
                        continue;
                    }
                }
                if (filename.endsWith(".pbf")) {
                    file = new File(filename);
                    ShortArrayList blockTypes = this.blockTypeMap.get(filename);
                    BinaryMapParser binParser = new BinaryMapParser(processor, blockTypes, 1);
                    FileInputStream stream = new FileInputStream(file);
                    throwable = null;
                    try {
                        BlockInputStream blockinput = new BlockInputStream(stream, binParser);
                        blockinput.process();
                        if (blockTypes != null) continue;
                        blockTypes = binParser.getBlockList();
                        this.blockTypeMap.put(filename, blockTypes);
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((InputStream)stream).close();
                        continue;
                    }
                }
                Reader reader = Utils.openFile(filename, this.maxThreads > 1);
                Throwable throwable5 = null;
                try {
                    OSMXMLParser parser = new OSMXMLParser(processor, this.mixed);
                    parser.setReader(reader);
                    parser.parse();
                }
                catch (Throwable throwable6) {
                    throwable5 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable5 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable7) {
                            throwable5.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (FileNotFoundException e) {
                System.out.println(e);
                throw new SplitFailedException("ERROR: file " + filename + " was not found");
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
                throw new SplitFailedException("ERROR: file " + filename + " is not a valid OSM XML file");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new SplitFailedException("ERROR: file " + filename + " contains unexpected data");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SplitFailedException("ERROR: file " + filename + " caused I/O exception");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw new SplitFailedException("ERROR: file " + filename + " caused exception");
            }
        }
        return processor.endMap();
    }

    public boolean execute(MapProcessor processor) {
        if (this.maxThreads == 1) {
            return this.process(processor);
        }
        final ArrayBlockingQueue<OSMMessage> queue = new ArrayBlockingQueue<OSMMessage>(10);
        final QueueProcessor queueProcessor = new QueueProcessor(queue, processor);
        new Thread("producer for " + processor.getClass().getSimpleName()){

            @Override
            public void run() {
                try {
                    OSMFileHandler.this.process(queueProcessor);
                }
                catch (SplitFailedException e) {
                    try {
                        queue.put(new OSMMessage(OSMMessage.Type.EXIT));
                        OSMFileHandler.this.exception = e;
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }.start();
        boolean done = processor.consume(queue);
        if (this.exception != null) {
            throw this.exception;
        }
        return done;
    }
}

