/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.AreaList;
import uk.me.parabola.splitter.DataStorer;
import uk.me.parabola.splitter.JVMHealthMonitor;
import uk.me.parabola.splitter.OSMFileHandler;
import uk.me.parabola.splitter.ProblemLists;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.SplitProcessor;
import uk.me.parabola.splitter.StopNoErrorException;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Version;
import uk.me.parabola.splitter.args.ParamParser;
import uk.me.parabola.splitter.args.SplitterParams;
import uk.me.parabola.splitter.kml.KmlWriter;
import uk.me.parabola.splitter.solver.AreasCalculator;
import uk.me.parabola.splitter.writer.AbstractOSMWriter;
import uk.me.parabola.splitter.writer.BinaryMapWriter;
import uk.me.parabola.splitter.writer.O5mMapWriter;
import uk.me.parabola.splitter.writer.OSMWriter;
import uk.me.parabola.splitter.writer.OSMXMLWriter;
import uk.me.parabola.splitter.writer.PseudoOSMWriter;

public class Main {
    private static final String DEFAULT_DIR = ".";
    private List<String> fileNameList;
    private int overlapAmount = -1;
    private int numTiles = -1;
    private File fileOutputDir;
    private final OSMFileHandler osmFileHandler = new OSMFileHandler();
    private final ProblemLists problemList = new ProblemLists();
    private SplitterParams mainOptions;

    public static void mainNoSystemExit(String ... args) {
        block2: {
            Main m = new Main();
            try {
                m.start(args);
            }
            catch (StopNoErrorException e) {
                if (e.getMessage() == null) break block2;
                System.out.println(e.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        block3: {
            Main m = new Main();
            try {
                int rc = m.start(args);
                if (rc != 0) {
                    System.exit(1);
                }
            }
            catch (StopNoErrorException e) {
                if (e.getMessage() == null) break block3;
                System.out.println(e.getMessage());
            }
        }
    }

    private int start(String[] args) {
        int rc = 0;
        JVMHealthMonitor healthMonitor = null;
        try {
            this.mainOptions = this.readArgs(args);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null) {
                System.out.println("Error: " + e.getMessage());
            }
            return 1;
        }
        if (this.mainOptions.getStatusFreq() > 0) {
            healthMonitor = new JVMHealthMonitor(this.mainOptions.getStatusFreq());
            healthMonitor.start();
        }
        Instant start = Instant.now();
        System.out.println("Time started: " + new Date());
        try {
            DataStorer dataStorer;
            this.osmFileHandler.setFileNames(this.fileNameList);
            this.osmFileHandler.setMixed(this.mainOptions.isMixed());
            this.osmFileHandler.setMaxThreads(this.mainOptions.getMaxThreads().getCount());
            if (this.mainOptions.isKeepComplete() && this.mainOptions.getProblemFile() != null && !this.problemList.readProblemIds(this.mainOptions.getProblemFile())) {
                throw new IllegalArgumentException();
            }
            List<Area> areas = this.split();
            if (this.mainOptions.isKeepComplete()) {
                dataStorer = this.calcProblemLists(areas);
                this.useProblemLists(dataStorer);
            } else {
                dataStorer = new DataStorer(areas, this.overlapAmount);
            }
            this.writeTiles(dataStorer);
            dataStorer.finish();
        }
        catch (IOException e) {
            System.err.println("Error opening or reading file " + e);
            e.printStackTrace();
            return 1;
        }
        catch (SplitFailedException e) {
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                e.printStackTrace();
            }
            return 1;
        }
        catch (StopNoErrorException e) {
            if (e.getMessage() != null) {
                String msg = "Stopped after " + e.getMessage();
                System.err.println(msg);
                System.out.println(msg);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return 1;
        }
        System.out.println("Time finished: " + new Date());
        Duration duration = Duration.between(start, Instant.now());
        long seconds = duration.getSeconds();
        if (seconds > 0L) {
            long hours = seconds / 3600L;
            long minutes = (seconds -= hours * 3600L) / 60L;
            System.out.println("Total time taken: " + (hours > 0L ? hours + (hours > 1L ? " hours " : " hour ") : "") + (minutes > 0L ? minutes + (minutes > 1L ? " minutes " : " minute ") : "") + (seconds > 0L ? (seconds -= minutes * 60L) + (seconds > 1L ? " seconds" : " second") : ""));
        } else {
            System.out.println("Total time taken: " + duration.getNano() / 1000000 + " ms");
        }
        return rc;
    }

    private List<Area> split() throws IOException {
        File outputDir = this.fileOutputDir;
        if (!outputDir.exists()) {
            System.out.println("Output directory not found. Creating directory '" + this.fileOutputDir + "'");
            if (!outputDir.mkdirs()) {
                System.err.println("Unable to create output directory! Using default directory instead");
                this.fileOutputDir = new File(DEFAULT_DIR);
            }
        } else if (!outputDir.isDirectory()) {
            System.err.println("The --output-dir parameter must specify a directory. The --output-dir parameter is being ignored, writing to default directory instead.");
            this.fileOutputDir = new File(DEFAULT_DIR);
        }
        String splitFile = this.mainOptions.getSplitFile();
        String polygonFile = this.mainOptions.getPolygonFile();
        String polygonDescFile = this.mainOptions.getPolygonDescFile();
        AreaList areaList = new AreaList(this.mainOptions.getDescription());
        boolean writeAreas = false;
        if (splitFile != null) {
            try {
                areaList.read(splitFile);
                areaList.dump();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read area list file " + splitFile);
            }
            if (polygonFile != null) {
                System.out.println("Warning: parameter polygon-file is ignored because split-file is used.");
            }
            if (polygonDescFile != null) {
                System.out.println("Warning: parameter polygon-desc-file is ignored because split-file is used.");
            }
        } else {
            writeAreas = true;
        }
        areaList.setGeoNamesFile(this.mainOptions.getGeonamesFile());
        AreasCalculator areasCalculator = new AreasCalculator(this.mainOptions, this.numTiles);
        if (areaList.getAreas().isEmpty()) {
            int resolution = this.mainOptions.getResolution();
            writeAreas = true;
            int alignment = 1 << 24 - resolution;
            System.out.println("Map is being split for resolution " + resolution + ':');
            System.out.println(" - area boundaries are aligned to 0x" + Integer.toHexString(alignment) + " map units (" + Utils.toDegrees(alignment) + " degrees)");
            System.out.println(" - areas are multiples of 0x" + Integer.toHexString(alignment) + " map units wide and high");
            areasCalculator.fillDensityMap(this.osmFileHandler, this.fileOutputDir);
            areaList.setAreas(areasCalculator.calcAreas());
            if (areaList.getAreas().isEmpty()) {
                System.err.println("Failed to calculate areas. See stdout messages for details.");
                System.out.println("Failed to calculate areas.");
                if (this.numTiles < 2) {
                    System.out.println("Sorry. Cannot split the file without creating huge, almost empty, tiles.");
                    System.out.println("Please specify a bounding polygon with the --polygon-file parameter.");
                } else {
                    System.out.println("Probably the number of tiles is too high for the given resolution.");
                }
                throw new SplitFailedException("");
            }
            int mapId = this.mainOptions.getMapid();
            if (mapId + areaList.getAreas().size() > 99999999) {
                throw new SplitFailedException("Too many areas for initial mapid " + mapId);
            }
            areaList.setMapIds(mapId);
        }
        areaList.setAreaNames();
        if (writeAreas) {
            areaList.write(new File(this.fileOutputDir, "areas.list").getPath());
            areaList.writePoly(new File(this.fileOutputDir, "areas.poly").getPath());
        }
        List<Area> areas = areaList.getAreas();
        String kmlOutputFile = this.mainOptions.getWriteKml();
        if (kmlOutputFile != null) {
            File out = new File(kmlOutputFile);
            if (!out.isAbsolute()) {
                out = new File(this.fileOutputDir, kmlOutputFile);
            }
            KmlWriter.writeKml(out.getPath(), areas);
        }
        String outputType = this.mainOptions.getOutput();
        if (!areasCalculator.getPolygons().isEmpty()) {
            areaList.writeListFiles(outputDir, areasCalculator.getPolygons(), kmlOutputFile, outputType);
        }
        areaList.writeArgsFile(new File(this.fileOutputDir, "template.args").getPath(), outputType, -1);
        areaList.dumpHex();
        if ("split".equals(this.mainOptions.getStopAfter())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new StopNoErrorException(this.mainOptions.getStopAfter());
        }
        return areaList.getAreas();
    }

    private DataStorer calcProblemLists(List<Area> areas) {
        DataStorer dataStorer = this.problemList.calcProblemLists(this.osmFileHandler, areas, this.overlapAmount, this.mainOptions);
        String problemReport = this.mainOptions.getProblemReport();
        if (problemReport != null) {
            this.problemList.writeProblemList(this.fileOutputDir, problemReport);
        }
        if ("gen-problem-list".equals(this.mainOptions.getStopAfter())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new StopNoErrorException(this.mainOptions.getStopAfter());
        }
        return dataStorer;
    }

    private SplitterParams readArgs(String[] args) {
        File dir;
        ParamParser parser = new ParamParser();
        SplitterParams params = parser.parse(SplitterParams.class, args);
        if (!parser.getErrors().isEmpty()) {
            System.out.println();
            System.out.println("Invalid parameter(s):");
            for (String error : parser.getErrors()) {
                System.out.println("  " + error);
            }
            System.out.println();
            parser.displayUsage();
            throw new IllegalArgumentException();
        }
        System.out.println("Splitter version " + Version.VERSION + " compiled " + Version.TIMESTAMP);
        for (Map.Entry<String, Object> entry : parser.getConvertedParams().entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            System.out.println(name + '=' + (value == null ? "" : value));
        }
        this.fileNameList = parser.getAdditionalParams();
        if (this.fileNameList.isEmpty()) {
            throw new IllegalArgumentException("No file name(s) given");
        }
        boolean filesOK = this.fileNameList.stream().allMatch(fname -> Main.testAndReportFname(fname, "input file"));
        if (!filesOK) {
            System.out.println("Make sure that option parameters start with -- ");
            throw new IllegalArgumentException();
        }
        int mapId = params.getMapid();
        if (mapId < 0 || mapId > 99999999) {
            System.err.println("The --mapid parameter must be a value between 0 and 99999999.");
            throw new IllegalArgumentException();
        }
        if (params.getMaxNodes() < 10000) {
            System.err.println("Error: Invalid number " + params.getMaxNodes() + ". The --max-nodes parameter must be an integer value of 10000 or higher.");
            throw new IllegalArgumentException();
        }
        String numTilesParm = params.getNumTiles();
        if (numTilesParm != null) {
            try {
                this.numTiles = Integer.parseInt(numTilesParm);
                if (this.numTiles < 2) {
                    System.err.println("Error: The --num-tiles parameter must be 2 or higher.");
                    throw new IllegalArgumentException();
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Error: Invalid number " + numTilesParm + ". The --num-tiles parameter must be an integer value of 2 or higher.");
                throw new IllegalArgumentException();
            }
        }
        String geoNamesFile = params.getGeonamesFile();
        Main.checkOptionalFileOption(geoNamesFile, "geonames-file");
        String outputType = params.getOutput();
        if (!"xml pbf o5m simulate".contains(outputType)) {
            System.err.println("The --output parameter must be either xml, pbf, o5m, or simulate. Resetting to xml.");
            throw new IllegalArgumentException();
        }
        int resolution = params.getResolution();
        if (resolution < 1 || resolution > 24) {
            System.err.println("The --resolution parameter must be a value between 1 and 24. Reasonable values are close to 13.");
            throw new IllegalArgumentException();
        }
        String outputDir = params.getOutputDir();
        this.fileOutputDir = new File(outputDir == null ? DEFAULT_DIR : outputDir);
        int maxAreasPerPass = params.getMaxAreas();
        if (maxAreasPerPass < 1 || maxAreasPerPass > 9999) {
            System.err.println("The --max-areas parameter must be a value between 1 and 9999.");
            throw new IllegalArgumentException();
        }
        String problemFile = params.getProblemFile();
        Main.checkOptionalFileOption(params.getProblemFile(), "problem-file");
        Main.checkOptionalFileOption(params.getSplitFile(), "split-file");
        Main.checkOptionalFileOption(params.getPolygonFile(), "polygon-file");
        Main.checkOptionalFileOption(params.getPolygonDescFile(), "polygon-desc-file");
        if (params.getPolygonDescFile() != null && params.getPolygonFile() != null) {
            throw new IllegalArgumentException("--polygon-desc-file and --polygon-file are mutually exclusive");
        }
        String precompSeaDir = params.getPrecompSea();
        if (!(precompSeaDir == null || (dir = new File(precompSeaDir)).exists() && dir.canRead())) {
            throw new IllegalArgumentException("precomp-sea directory doesn't exist or is not readable: " + precompSeaDir);
        }
        boolean keepComplete = params.isKeepComplete();
        if (params.isMixed() && (keepComplete || problemFile != null)) {
            System.err.println("--mixed=true is not supported in combination with --keep-complete=true or --problem-file.");
            System.err.println("Please use e.g. osomosis to sort the data in the input file(s)");
            throw new IllegalArgumentException();
        }
        String overlap = params.getOverlap();
        if (!"auto".equals(overlap)) {
            try {
                this.overlapAmount = Integer.valueOf(overlap);
                if (this.overlapAmount < 0) {
                    throw new IllegalArgumentException("--overlap=" + overlap + " is not is not a valid option.");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("--overlap=" + overlap + " is not is not a valid option.");
            }
        }
        String boundaryTagsParm = params.getBoundaryTags();
        int wantedAdminLevelString = params.getWantedAdminLevel();
        if (wantedAdminLevelString < 0 || wantedAdminLevelString > 12) {
            throw new IllegalArgumentException("The --wanted-admin-level parameter must be between 0 and 12.");
        }
        List<String> validVersionHandling = Arrays.asList("remove", "fake", "keep");
        if (!validVersionHandling.contains(params.getHandleElementVersion())) {
            throw new IllegalArgumentException("the --handle-element-version parameter must be one of " + validVersionHandling + DEFAULT_DIR);
        }
        List<String> validStopAfter = Arrays.asList("split", "gen-problem-list", "handle-problem-list", "dist");
        if (!validStopAfter.contains(params.getStopAfter())) {
            throw new IllegalArgumentException("the --stop-after parameter must be one of " + validStopAfter + DEFAULT_DIR);
        }
        int searchLimit = params.getSearchLimit();
        if (searchLimit < 1000) {
            throw new IllegalArgumentException("The --search-limit parameter must be 1000 or higher.");
        }
        if (keepComplete) {
            if (this.fileNameList.size() > 1) {
                System.err.println("Warning: --keep-complete is only used for the first input file. Further files must use higher ids.");
            }
            if (this.overlapAmount > 0) {
                System.err.println("Warning: --overlap is used in combination with --keep-complete=true ");
                System.err.println("         The option keep-complete should be used with overlap=0 because it is very unlikely that ");
                System.err.println("         the overlap will add any important data. It will just cause a lot of additional output which ");
                System.err.println("         has to be thrown away again in mkgmap.");
            } else {
                this.overlapAmount = 0;
            }
        } else {
            if (this.overlapAmount < 0) {
                this.overlapAmount = 2000;
                System.out.println("Setting default overlap=2000 because keep-complete=false is in use.");
            }
            if (params.getProblemReport() != null) {
                System.out.println("Parameter --problem-report is ignored, because parameter --keep-complete=false is used");
            }
            if (boundaryTagsParm != null) {
                System.out.println("Parameter --boundaryTags is ignored, because parameter --keep-complete=false is used");
            }
        }
        return params;
    }

    private static void checkOptionalFileOption(String fname, String option) {
        if (fname != null && !Main.testAndReportFname(fname, option)) {
            throw new IllegalArgumentException();
        }
    }

    private OSMWriter[] createWriters(List<Area> areas) {
        OSMWriter[] allWriters = new OSMWriter[areas.size()];
        for (int j = 0; j < allWriters.length; ++j) {
            Area area = areas.get(j);
            String outputType = this.mainOptions.getOutput();
            AbstractOSMWriter w = "pbf".equals(outputType) ? new BinaryMapWriter(area, this.fileOutputDir, area.getMapId(), this.overlapAmount) : ("o5m".equals(outputType) ? new O5mMapWriter(area, this.fileOutputDir, area.getMapId(), this.overlapAmount) : ("simulate".equals(outputType) ? new PseudoOSMWriter(area) : new OSMXMLWriter(area, this.fileOutputDir, area.getMapId(), this.overlapAmount)));
            switch (this.mainOptions.getHandleElementVersion()) {
                case "keep": {
                    w.setVersionMethod(3);
                    break;
                }
                case "remove": {
                    w.setVersionMethod(1);
                    break;
                }
                default: {
                    w.setVersionMethod(2);
                }
            }
            allWriters[j] = w;
        }
        return allWriters;
    }

    private void useProblemLists(DataStorer dataStorer) {
        this.problemList.calcMultiTileElements(dataStorer, this.osmFileHandler);
        if ("handle-problem-list".equals(this.mainOptions.getStopAfter())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new StopNoErrorException(this.mainOptions.getStopAfter());
        }
    }

    private void writeTiles(DataStorer dataStorer) throws IOException {
        List<Area> areas = dataStorer.getAreaDictionary().getAreas();
        dataStorer.switchToSeqAccess(this.fileOutputDir);
        dataStorer.setWriters(this.createWriters(areas));
        System.out.println("Distributing data " + new Date());
        int numPasses = (int)Math.ceil((double)areas.size() / (double)this.mainOptions.getMaxAreas());
        int areasPerPass = (int)Math.ceil((double)areas.size() / (double)numPasses);
        long startDistPass = System.currentTimeMillis();
        if (numPasses > 1) {
            System.out.println("Processing " + areas.size() + " areas in " + numPasses + " passes, " + areasPerPass + " areas at a time");
        } else {
            System.out.println("Processing " + areas.size() + " areas in a single pass");
        }
        for (int i = 0; i < numPasses; ++i) {
            int areaOffset = i * areasPerPass;
            int numAreasThisPass = Math.min(areasPerPass, areas.size() - i * areasPerPass);
            dataStorer.restartWriterMaps();
            SplitProcessor processor = new SplitProcessor(dataStorer, areaOffset, numAreasThisPass, this.mainOptions);
            System.out.println("Starting distribution pass " + (i + 1) + " of " + numPasses + ", processing " + numAreasThisPass + " areas (" + areas.get(i * areasPerPass).getMapId() + " to " + areas.get(i * areasPerPass + numAreasThisPass - 1).getMapId() + ')');
            this.osmFileHandler.execute(processor);
        }
        System.out.println("Distribution pass(es) took " + (System.currentTimeMillis() - startDistPass) + " ms");
    }

    static boolean testAndReportFname(String fileName, String type) {
        File f = new File(fileName);
        if (!(f.exists() && f.isFile() && f.canRead())) {
            String msg = "Error: " + type + " doesn't exist or is not a readable file: " + fileName;
            System.out.println(msg);
            System.err.println(msg);
            return false;
        }
        return true;
    }
}

