/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import java.util.concurrent.BlockingQueue;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.MapProcessor;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.OSMMessage;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.Way;

public abstract class AbstractMapProcessor
implements MapProcessor {
    public static final int UNASSIGNED = Short.MIN_VALUE;

    @Override
    public boolean skipTags() {
        return false;
    }

    @Override
    public boolean skipNodes() {
        return false;
    }

    @Override
    public boolean skipWays() {
        return false;
    }

    @Override
    public boolean skipRels() {
        return false;
    }

    @Override
    public void boundTag(Area bounds) {
    }

    @Override
    public void processNode(Node n) {
    }

    @Override
    public void processWay(Way w) {
    }

    @Override
    public void processRelation(Relation r) {
    }

    @Override
    public boolean endMap() {
        return true;
    }

    @Override
    public int getPhase() {
        return 1;
    }

    @Override
    public void startFile() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean consume(BlockingQueue<OSMMessage> queue) {
        try {
            block9: while (true) {
                OSMMessage msg = queue.take();
                switch (msg.type) {
                    case ELEMENTS: {
                        Element[] elementArray = msg.elements;
                        int n = elementArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block9;
                            Element el = elementArray[n2];
                            if (el == null) continue block9;
                            if (el instanceof Node) {
                                this.processNode((Node)el);
                            } else if (el instanceof Way) {
                                this.processWay((Way)el);
                            } else if (el instanceof Relation) {
                                this.processRelation((Relation)el);
                            }
                            ++n2;
                        }
                    }
                    case BOUNDS: {
                        this.boundTag(msg.bounds);
                        break;
                    }
                    case END_MAP: {
                        return this.endMap();
                    }
                    case START_FILE: {
                        this.startFile();
                        break;
                    }
                    case EXIT: {
                        return true;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

