/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary;

import com.google.protobuf.ByteString;
import crosby.binary.Osmformat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class StringTable {
    private HashMap<String, Integer> counts;
    private HashMap<String, Integer> stringmap;
    private String[] set;

    public StringTable() {
        this.clear();
    }

    public void incr(String string) {
        if (this.counts.containsKey(string)) {
            this.counts.put(string, new Integer(this.counts.get(string) + 1));
        } else {
            this.counts.put(string, new Integer(1));
        }
    }

    public int getIndex(String string) {
        return this.stringmap.get(string);
    }

    public void finish() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n = (Integer)StringTable.this.counts.get(string2) - (Integer)StringTable.this.counts.get(string);
                return n;
            }
        };
        this.set = this.counts.keySet().toArray(new String[0]);
        if (this.set.length > 0) {
            Arrays.sort(this.set, comparator);
            Arrays.sort(this.set, Math.min(128, this.set.length - 1), Math.min(16384, this.set.length - 1));
            Arrays.sort(this.set, Math.min(16384, this.set.length - 1), Math.min(0x200000, this.set.length - 1), comparator);
        }
        this.stringmap = new HashMap(2 * this.set.length);
        for (int i = 0; i < this.set.length; ++i) {
            this.stringmap.put(this.set[i], new Integer(i + 1));
        }
        this.counts = null;
    }

    public void clear() {
        this.counts = new HashMap(100);
        this.stringmap = null;
        this.set = null;
    }

    public Osmformat.StringTable.Builder serialize() {
        Osmformat.StringTable.Builder builder = Osmformat.StringTable.newBuilder();
        builder.addS(ByteString.copyFromUtf8((String)""));
        for (int i = 0; i < this.set.length; ++i) {
            builder.addS(ByteString.copyFromUtf8((String)this.set[i]));
        }
        return builder;
    }
}

