import * as http from "node:http";
import { type IncomingMessage as Request, type ServerResponse as Response } from "node:http";
import type { ErrorCallback, NormalizedServerOptions, ProxyServer, ServerOptions } from "..";
export type ProxyResponse = Request & {
    headers: {
        [key: string]: string | string[];
    };
};
export type { Request, Response };
export declare function deleteLength(req: Request): void;
export declare function timeout(req: Request, _res: Response, options: ServerOptions): void;
export declare function XHeaders(req: Request, _res: Response, options: ServerOptions): void;
export declare function stream(req: Request, res: Response, options: NormalizedServerOptions, _: Buffer | undefined, server: ProxyServer, cb: ErrorCallback | undefined): http.ServerResponse<http.IncomingMessage> | undefined;
export declare const WEB_PASSES: {
    deleteLength: typeof deleteLength;
    timeout: typeof timeout;
    XHeaders: typeof XHeaders;
    stream: typeof stream;
};
