/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.sys;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.fs.DirectoryEntry;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.BlockManager;
import uk.me.parabola.imgfmt.sys.Directory;
import uk.me.parabola.imgfmt.sys.Dirent;
import uk.me.parabola.imgfmt.sys.FileNode;
import uk.me.parabola.imgfmt.sys.ImgHeader;
import uk.me.parabola.log.Logger;

public class ImgFS
implements FileSystem {
    private static final Logger log = Logger.getLogger(ImgFS.class);
    static final String DIRECTORY_FILE_NAME = "        .   ";
    private static final OpenOption[] OPEN_CREATE_RW = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
    private final FileChannel file;
    private boolean readOnly = true;
    private ImgHeader header;
    private FileSystemParam fsparam;
    private Directory directory;
    private BlockManager fileBlockManager;
    private static final long ENTRY_BLOCK_SIZE = 512L;
    private BlockManager headerBlockManager;
    private final List<FileNode> openNodes = new ArrayList<FileNode>();
    private byte xorByte;

    private ImgFS(FileChannel chan) {
        this.file = chan;
    }

    public static FileSystem createFs(String filename, FileSystemParam params) throws FileNotWritableException {
        params.setFilename(filename);
        try {
            FileChannel chan = FileChannel.open(Paths.get(filename, new String[0]), OPEN_CREATE_RW);
            return ImgFS.createFs(chan, params);
        }
        catch (IOException e) {
            throw new FileNotWritableException("Could not create file", e);
        }
    }

    private static FileSystem createFs(FileChannel chan, FileSystemParam params) throws FileNotWritableException {
        assert (params != null);
        try {
            chan.truncate(0L);
        }
        catch (IOException e) {
            throw new FileNotWritableException("Failed to truncate file", e);
        }
        ImgFS fs = new ImgFS(chan);
        fs.createInitFS(chan, params);
        return fs;
    }

    public static FileSystem openFs(String name) throws FileNotFoundException {
        try {
            FileChannel chan = FileChannel.open(Paths.get(name, new String[0]), StandardOpenOption.READ);
            return ImgFS.openFs(name, chan);
        }
        catch (IOException e) {
            throw new FileNotFoundException("Failed to create or open file " + name);
        }
    }

    private static FileSystem openFs(String name, FileChannel chan) throws FileNotFoundException {
        ImgFS fs = new ImgFS(chan);
        try {
            fs.readInitFS(chan);
        }
        catch (IOException e) {
            throw new FileNotFoundException(name + ": " + e.getMessage());
        }
        return fs;
    }

    @Override
    public ImgChannel create(String name) throws FileExistsException {
        Dirent dir = this.directory.create(name, this.fileBlockManager);
        FileNode node = new FileNode(this.file, dir, "w");
        this.openNodes.add(node);
        return node;
    }

    @Override
    public ImgChannel open(String name, String mode) throws FileNotFoundException {
        if (name == null || mode == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (mode.indexOf(114) >= 0) {
            Dirent ent = this.internalLookup(name);
            FileNode fn = new FileNode(this.file, ent, "r");
            if (this.xorByte != 0) {
                fn.setXorByte(this.xorByte);
            }
            return fn;
        }
        if (mode.indexOf(119) >= 0) {
            Dirent ent;
            try {
                ent = this.internalLookup(name);
            }
            catch (FileNotFoundException e) {
                try {
                    ent = this.directory.create(name, this.fileBlockManager);
                }
                catch (FileExistsException e1) {
                    throw new FileNotFoundException("Attempt to duplicate a file name");
                }
            }
            FileNode node = new FileNode(this.file, ent, "w");
            this.openNodes.add(node);
            return node;
        }
        throw new IllegalArgumentException("Invalid mode given");
    }

    @Override
    public DirectoryEntry lookup(String name) throws FileNotFoundException {
        return this.internalLookup(name);
    }

    @Override
    public List<DirectoryEntry> list() {
        return this.directory.getEntries();
    }

    @Override
    public void sync() throws IOException {
        if (this.readOnly) {
            return;
        }
        assert (this.fileBlockManager.getMaxBlockAllocated() == 0);
        FileSystemParam param = this.fsparam;
        int totalBlocks = this.calcBlockParam(param);
        this.fileBlockManager.setBlockSize(param.getBlockSize());
        this.headerBlockManager.setBlockSize(param.getBlockSize());
        this.file.position((long)param.getReservedDirectoryBlocks() * (long)param.getBlockSize());
        this.fileBlockManager.setCurrentBlock(param.getReservedDirectoryBlocks());
        for (FileNode n : this.openNodes) {
            n.close();
        }
        this.header.createHeader(param);
        this.header.setNumBlocks(totalBlocks);
        this.header.sync();
        this.directory.sync();
    }

    private int calcBlockParam(FileSystemParam param) {
        int bestBlockSize = 0;
        int reserved = 0;
        int sizeInBlocks = 0;
        long bestSize = Long.MAX_VALUE;
        for (int blockSize = param.getBlockSize(); blockSize < 0x1000000; blockSize <<= 1) {
            int headerSlotsRequired = 1;
            int fileBlocks = 0;
            for (FileNode fn : this.openNodes) {
                long len = fn.getSize();
                int nBlocks = (int)((len + (long)blockSize - 1L) / (long)blockSize);
                fileBlocks += nBlocks;
                headerSlotsRequired += (nBlocks + 240 - 1) / 240;
            }
            int requiredSlots = param.getDirectoryStartEntry() + headerSlotsRequired;
            int headerBlocks = (requiredSlots * 512 + blockSize - 1) / blockSize;
            int totalBlocks = headerBlocks + fileBlocks;
            long size = (long)totalBlocks * (long)blockSize;
            log.infof("bs=%d, whole size=%d, hb=%d, fb=%d, blocks=%d", blockSize, size, headerBlocks, fileBlocks, totalBlocks);
            if (headerBlocks > 240 || totalBlocks > 65534) continue;
            if (size > bestSize) break;
            bestBlockSize = blockSize;
            reserved = headerBlocks;
            sizeInBlocks = fileBlocks + headerBlocks;
            bestSize = size;
        }
        log.infof("Best block size: %d sizeInBlocks=%d, reserved=%d", bestBlockSize, sizeInBlocks, reserved);
        param.setBlockSize(bestBlockSize);
        param.setReservedDirectoryBlocks(reserved);
        return sizeInBlocks;
    }

    @Override
    public void close() {
        try {
            this.sync();
        }
        catch (IOException e) {
            log.debug((Object)"could not sync filesystem");
        }
        finally {
            try {
                this.file.close();
            }
            catch (IOException e) {
                log.warn((Object)"Could not close file");
            }
        }
    }

    @Override
    public FileSystemParam fsparam() {
        return this.fsparam;
    }

    private void createInitFS(FileChannel chan, FileSystemParam params) throws FileNotWritableException {
        this.readOnly = false;
        this.fsparam = params;
        this.headerBlockManager = new BlockManager(params.getBlockSize(), 0);
        this.headerBlockManager.setMaxBlock(params.getReservedDirectoryBlocks());
        try {
            this.directory = new Directory(this.headerBlockManager);
            Dirent ent = this.directory.create(DIRECTORY_FILE_NAME, this.headerBlockManager);
            ent.setSpecial(true);
            ent.setInitialized(true);
            FileNode f = new FileNode(chan, ent, "w");
            this.directory.setFile(f);
            this.header = new ImgHeader(f);
            this.header.createHeader(params);
        }
        catch (FileExistsException e) {
            throw new FileNotWritableException("Could not create img file directory", e);
        }
        this.fileBlockManager = new BlockManager(params.getBlockSize(), params.getReservedDirectoryBlocks());
        assert (this.header != null);
    }

    private void readInitFS(FileChannel chan) throws IOException {
        ByteBuffer headerBuf = ByteBuffer.allocate(512);
        headerBuf.order(ByteOrder.LITTLE_ENDIAN);
        chan.read(headerBuf);
        this.xorByte = headerBuf.get(0);
        if (this.xorByte != 0) {
            byte[] headerBytes = headerBuf.array();
            int i = 0;
            while (i < headerBytes.length) {
                int n = i++;
                headerBytes[n] = (byte)(headerBytes[n] ^ this.xorByte);
            }
        }
        if (headerBuf.position() < 512) {
            throw new IOException("File too short or corrupted");
        }
        this.header = new ImgHeader(null);
        this.header.setHeader(headerBuf);
        this.fsparam = this.header.getParams();
        BlockManager headerBlockManager = new BlockManager(this.fsparam.getBlockSize(), 0);
        headerBlockManager.setMaxBlock(this.fsparam.getReservedDirectoryBlocks());
        this.directory = new Directory(headerBlockManager);
        this.directory.setStartPos((long)this.fsparam.getDirectoryStartEntry() * 512L);
        Dirent ent = this.directory.create(DIRECTORY_FILE_NAME, headerBlockManager);
        FileNode f = new FileNode(chan, ent, "r");
        this.header.setFile(f);
        this.directory.setFile(f);
        this.directory.readInit(this.xorByte);
    }

    private Dirent internalLookup(String name) throws FileNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("null name argument");
        }
        Dirent ent = (Dirent)this.directory.lookup(name);
        if (ent == null) {
            throw new FileNotFoundException(name + " not found");
        }
        return ent;
    }
}

