/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import uk.me.parabola.imgfmt.app.BitWriter;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.typ.ColourInfo;
import uk.me.parabola.imgfmt.app.typ.Image;

public class BitmapImage
implements Image {
    private final ColourInfo colourInfo;
    private final String image;

    public BitmapImage(ColourInfo colourInfo, String image) {
        this.colourInfo = colourInfo;
        this.image = image;
    }

    @Override
    public void write(ImgFileWriter writer) {
        int bitSize = this.colourInfo.getBitsPerPixel();
        int cpp = this.colourInfo.getCharsPerPixel();
        int width = this.colourInfo.getWidth();
        int height = this.colourInfo.getHeight();
        int i = 0;
        for (int h = 0; h < height; ++h) {
            BitWriter bitWriter = new BitWriter();
            for (int w = 0; w < width; ++w) {
                String idx = this.image.substring(i, i + cpp);
                i += cpp;
                int val = this.colourInfo.getIndex(idx);
                bitWriter.putn(val, bitSize);
            }
            writer.put(bitWriter.getBytes(), 0, bitWriter.getLength());
        }
    }

    public int compare(BitmapImage a, BitmapImage b) {
        throw new UnsupportedOperationException();
    }
}

