/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.polish;

import java.util.Arrays;
import java.util.Map;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;

public class PolishTurnRestriction {
    private long[] trafficNodes;
    private long[] trafficRoads;
    private byte exceptMask;
    private boolean valid = true;

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public byte getExceptMask() {
        return this.exceptMask;
    }

    public void setExceptMask(byte exceptMask) {
        this.exceptMask = exceptMask;
    }

    public String toString() {
        return "TurnRestriction" + Arrays.toString(this.trafficNodes);
    }

    public void setTrafficPoints(String idsList) {
        try {
            this.trafficNodes = this.parse(idsList);
            if (this.trafficNodes.length < 3 || this.trafficNodes.length > 4) {
                this.setValid(false);
            }
        }
        catch (NumberFormatException e) {
            this.setValid(false);
            throw new MapFailedException("invalid list of nod ids " + idsList);
        }
    }

    public void setTrafficRoads(String idsList) {
        try {
            this.trafficRoads = this.parse(idsList);
            if (this.trafficRoads.length < 2 || this.trafficRoads.length > 3) {
                this.setValid(false);
            }
        }
        catch (NumberFormatException e) {
            this.setValid(false);
            throw new MapFailedException("invalid list of road ids " + idsList);
        }
    }

    public GeneralRouteRestriction toGeneralRouteRestriction(Map<Long, CoordNode> allNodes) {
        long[] lArray = this.trafficNodes;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long id = lArray[i];
            if (allNodes.containsKey(id)) continue;
            return null;
        }
        if (this.trafficNodes.length == this.trafficRoads.length + 1) {
            GeneralRouteRestriction grr = new GeneralRouteRestriction("not", this.getExceptMask(), "polish");
            grr.setFromNode(allNodes.get(this.trafficNodes[0]));
            grr.setFromWayId(this.trafficRoads[0]);
            if (this.trafficNodes.length == 3) {
                grr.setViaNodes(Arrays.asList(allNodes.get(this.trafficNodes[1])));
            } else {
                grr.setViaNodes(Arrays.asList(allNodes.get(this.trafficNodes[1]), allNodes.get(this.trafficNodes[2])));
                grr.setViaWayIds(Arrays.asList(this.trafficRoads[1]));
            }
            grr.setToNode(allNodes.get(this.trafficNodes[this.trafficNodes.length - 1]));
            grr.setToWayId(this.trafficRoads[this.trafficRoads.length - 1]);
            return grr;
        }
        return null;
    }

    private long[] parse(String idsValue) {
        String[] ids = idsValue.split(",");
        long[] longs = new long[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            longs[i] = Long.parseLong(ids[i]);
        }
        return longs;
    }
}

