/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.polish;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.NumberStyle;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.imgfmt.app.trergn.ExtTypeAttributes;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;
import uk.me.parabola.mkgmap.reader.MapperBasedMapDataSource;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.GeneralRelation;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.polish.PolishTurnRestriction;
import uk.me.parabola.mkgmap.reader.polish.RestrictionHelper;
import uk.me.parabola.mkgmap.reader.polish.RoadHelper;

public class PolishMapDataSource
extends MapperBasedMapDataSource
implements LoadableMapDataSource {
    private static final Logger log = Logger.getLogger(PolishMapDataSource.class);
    private static final Charset READING_CHARSET = StandardCharsets.ISO_8859_1;
    private static final int S_IMG_ID = 1;
    private static final int S_POINT = 2;
    private static final int S_POLYLINE = 3;
    private static final int S_POLYGON = 4;
    private static final int S_RESTRICTION = 5;
    private MapPoint point;
    private MapLine polyline;
    private MapShape shape;
    private PolishTurnRestriction restriction;
    private final Map<Integer, List<List<Coord>>> lineStringMap = new LinkedHashMap<Integer, List<List<Coord>>>();
    private final RoadHelper roadHelper = new RoadHelper();
    private final RestrictionHelper restrictionHelper = new RestrictionHelper();
    private Map<String, String> extraAttributes;
    private String copyright;
    private int section;
    private LevelInfo[] levels;
    private int endLevel;
    private char elevUnits;
    private int currentLevel;
    private boolean dataHighLevel;
    private boolean background;
    private int poiDispFlag;
    private String defaultCountry;
    private String defaultRegion;
    private static final double METERS_TO_FEET = 3.2808399;
    private int lineNo;
    private boolean havePolygon4B;
    private boolean routing;
    private int roadIdGenerated;
    private CharsetDecoder dec;

    @Override
    public boolean isFileSupported(String name) {
        return name.endsWith(".mp") || name.endsWith(".MP") || name.endsWith(".mp.gz");
    }

    @Override
    public void load(String name, boolean addBackground) throws FileNotFoundException {
        this.dec = StandardCharsets.UTF_8.newDecoder();
        this.dec.onUnmappableCharacter(CodingErrorAction.REPLACE);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(Utils.openFile(name), READING_CHARSET));){
            String line;
            while ((line = in.readLine()) != null) {
                ++this.lineNo;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == ';') continue;
                if (line.toUpperCase().startsWith("[END")) {
                    this.endSection();
                    continue;
                }
                if (line.charAt(0) == '[') {
                    this.sectionStart(line);
                    continue;
                }
                this.processLine(line);
            }
        }
        catch (IOException e) {
            throw new FormatException("Reading file failed", e);
        }
        this.restrictionHelper.processAndAddRestrictions(this.roadHelper, this.mapper);
        if (addBackground && !this.havePolygon4B) {
            this.addBackground();
        }
    }

    @Override
    public LevelInfo[] mapLevels() {
        if (this.levels == null) {
            this.levels = new LevelInfo[]{new LevelInfo(3, 17), new LevelInfo(2, 18), new LevelInfo(1, 22), new LevelInfo(0, 24)};
        }
        this.levels[0].setTop(true);
        return this.levels;
    }

    @Override
    public LevelInfo[] overviewMapLevels() {
        String levelSpec = this.getConfig().getProperty("overview-levels");
        if (levelSpec == null) {
            return null;
        }
        LevelInfo[] ovLevels = LevelInfo.createFromString(levelSpec);
        for (int i = 0; i < ovLevels.length; ++i) {
            ovLevels[i] = new LevelInfo(ovLevels.length - i - 1, ovLevels[i].getBits());
        }
        return ovLevels;
    }

    @Override
    public String[] copyrightMessages() {
        String copyrightFileName = this.getConfig().getProperty("copyright-file", null);
        if (copyrightFileName != null) {
            return PolishMapDataSource.readCopyrightFile(copyrightFileName);
        }
        if (this.copyright == null) {
            this.copyright = this.getConfig().getProperty("copyright-message", null);
        }
        return new String[]{this.copyright};
    }

    private void sectionStart(String line) {
        String name = line.substring(1, line.length() - 1).trim();
        log.debug("section name", name);
        this.extraAttributes = null;
        if ("IMG ID".equalsIgnoreCase(name)) {
            this.section = 1;
            this.poiDispFlag = 0;
        } else if ("POI".equalsIgnoreCase(name) || "RGN10".equals(name) || "RGN20".equals(name)) {
            this.point = new MapPoint();
            this.section = 2;
        } else if ("POLYLINE".equalsIgnoreCase(name) || "RGN40".equals(name)) {
            this.polyline = new MapLine();
            this.roadHelper.clear();
            this.section = 3;
        } else if ("POLYGON".equalsIgnoreCase(name) || "RGN80".equals(name)) {
            this.shape = new MapShape();
            this.section = 4;
        } else if ("Restrict".equalsIgnoreCase(name)) {
            this.restriction = new PolishTurnRestriction();
            this.section = 5;
        } else {
            log.info((Object)("Ignoring unrecognised section: " + name));
        }
    }

    private void endSection() {
        switch (this.section) {
            case 1: {
                break;
            }
            case 2: {
                if (this.point.getLocation() != null) {
                    if (this.extraAttributes != null && this.point.hasExtendedType()) {
                        this.point.setExtTypeAttributes(this.makeExtTypeAttributes());
                    }
                    this.mapper.addToBounds(this.point.getLocation());
                    this.mapper.addPoint(this.point);
                    break;
                }
                log.error((Object)("skipping POI without coordinates near line " + this.lineNo));
                break;
            }
            case 3: {
                if (this.lineStringMap.isEmpty()) break;
                MapLine origPolyline = this.polyline.copy();
                for (Map.Entry<Integer, List<List<Coord>>> entry : this.lineStringMap.entrySet()) {
                    int level = entry.getKey();
                    this.setResolution((MapElement)origPolyline, level);
                    for (List<Coord> points : entry.getValue()) {
                        this.polyline = origPolyline.copy();
                        if (!this.routing && GType.isSpecialRoutableLineType(this.polyline.getType())) {
                            this.roadHelper.setRoadId(++this.roadIdGenerated);
                        }
                        if (this.roadHelper.isRoad() && level == 0) {
                            this.polyline.setPoints(points);
                            MapRoad r = this.roadHelper.makeRoad(this.polyline);
                            if (!this.routing) {
                                r.skipAddToNOD(true);
                            }
                            this.mapper.addRoad(r);
                            continue;
                        }
                        if (this.extraAttributes != null && this.polyline.hasExtendedType()) {
                            this.polyline.setExtTypeAttributes(this.makeExtTypeAttributes());
                        }
                        int maxPointsInLine = 250;
                        if (points.size() > 250) {
                            ArrayList<Coord> segPoints = new ArrayList<Coord>(250);
                            for (Coord p : points) {
                                segPoints.add(p);
                                if (segPoints.size() != 250) continue;
                                MapLine seg = this.polyline.copy();
                                seg.setPoints(segPoints);
                                this.mapper.addLine(seg);
                                segPoints = new ArrayList(250);
                                segPoints.add(p);
                            }
                            if (segPoints.isEmpty()) continue;
                            this.polyline.setPoints(segPoints);
                            this.mapper.addLine(this.polyline);
                            continue;
                        }
                        this.polyline.setPoints(points);
                        this.mapper.addLine(this.polyline);
                    }
                }
                break;
            }
            case 4: {
                if (this.lineStringMap.isEmpty()) break;
                if (this.extraAttributes != null && this.shape.hasExtendedType()) {
                    this.shape.setExtTypeAttributes(this.makeExtTypeAttributes());
                }
                if (this.background && !this.dataHighLevel) {
                    this.endLevel = this.levels.length - 1;
                }
                for (Map.Entry<Integer, List<List<Coord>>> entry : this.lineStringMap.entrySet()) {
                    this.setResolution((MapElement)this.shape, entry.getKey());
                    this.addShapesFromPattern(entry.getValue());
                }
                break;
            }
            case 5: {
                this.restrictionHelper.addRestriction(this.restriction);
                break;
            }
            case 0: {
                break;
            }
            default: {
                log.warn("unexpected default in switch", this.section);
            }
        }
        this.section = 0;
        this.endLevel = 0;
        this.lineStringMap.clear();
        this.currentLevel = 0;
        this.dataHighLevel = false;
        this.background = false;
    }

    private void addShapesFromPattern(List<List<Coord>> pointsLists) {
        if (pointsLists.size() == 1) {
            MapShape copy = this.shape.copy();
            copy.setPoints(pointsLists.get(0));
            this.mapper.addShape(copy);
        } else {
            HashMap<Long, Way> wayMap = new HashMap<Long, Way>();
            GeneralRelation gr = new GeneralRelation(FakeIdGenerator.makeFakeId());
            gr.addTag("code", Integer.toHexString(this.shape.getType()));
            for (int i = 0; i < pointsLists.size(); ++i) {
                Way w = new Way(FakeIdGenerator.makeFakeId(), pointsLists.get(i));
                wayMap.put(w.getId(), w);
                gr.addElement("", w);
            }
            MultiPolygonRelation mp = new MultiPolygonRelation(gr, wayMap, Area.PLANET);
            mp.processElements();
            for (Way s : wayMap.values()) {
                if (!"polygon".equals(s.getTag("mkgmap:stylefilter"))) continue;
                MapShape copy = this.shape.copy();
                copy.setPoints(s.getPoints());
                this.mapper.addShape(copy);
            }
        }
    }

    private void processLine(String line) {
        String[] nameVal = line.split("=", 2);
        if (nameVal.length != 2) {
            log.warn((Object)("short line? " + line));
            return;
        }
        String name = nameVal[0].trim();
        String value = nameVal[1].trim();
        log.debug("LINE: ", name, "|", value);
        switch (this.section) {
            case 1: {
                this.imgId(name, value);
                break;
            }
            case 2: {
                if (this.isCommonValue(this.point, name, value)) break;
                this.point(name, value);
                break;
            }
            case 3: {
                if (this.isCommonValue(this.polyline, name, value)) break;
                this.line(name, value);
                break;
            }
            case 4: {
                if (this.isCommonValue(this.shape, name, value)) break;
                this.shape(name, value);
                break;
            }
            case 5: {
                this.restriction(name, value);
                break;
            }
            default: {
                log.debug((Object)"line ignored");
            }
        }
    }

    private void point(String name, String value) {
        if ("Type".equals(name)) {
            int type = Integer.decode(value);
            if (type <= 255) {
                type <<= 8;
            }
            this.point.setType(type);
            this.checkType(FeatureKind.POINT, this.point.getType());
        } else if ("SubType".equals(name)) {
            int subtype = Integer.decode(value);
            int type = this.point.getType();
            this.point.setType(type | subtype);
            this.checkType(FeatureKind.POINT, this.point.getType());
        } else if (name.startsWith("Data") || name.startsWith("Origin")) {
            Coord co = PolishMapDataSource.makeCoord(value);
            this.setResolution((MapElement)this.point, name);
            this.point.setLocation(co);
        } else {
            if (this.extraAttributes == null) {
                this.extraAttributes = new HashMap<String, String>();
            }
            this.extraAttributes.put(name, value);
        }
    }

    private void line(String name, String value) {
        if ("Type".equals(name)) {
            this.polyline.setType(this.decodeType(FeatureKind.POLYLINE, value));
        } else if (name.startsWith("Data")) {
            this.extractResolution(name);
            this.addLineString(value, false);
            if (GType.isContourLine(this.polyline)) {
                this.fixElevation();
            }
        } else if ("RoadID".equals(name)) {
            if (!this.routing && this.roadIdGenerated > 0) {
                throw new MapFailedException("found RoadID without Routing=Y in [IMG ID] section in line " + this.lineNo);
            }
            this.roadHelper.setRoadId(Integer.parseInt(value));
        } else if (name.startsWith("Nod")) {
            this.roadHelper.addNode(value);
        } else if ("RouteParam".equals(name) || "RouteParams".equals(name)) {
            this.roadHelper.setParam(value);
        } else if ("DirIndicator".equals(name)) {
            this.polyline.setDirection(Integer.parseInt(value) > 0);
        } else if (name.startsWith("Numbers")) {
            this.roadHelper.addNumbers(this.parseNumbers(value));
        } else {
            if (this.extraAttributes == null) {
                this.extraAttributes = new HashMap<String, String>();
            }
            this.extraAttributes.put(name, value);
        }
    }

    public Numbers parseNumbers(String spec) {
        Numbers nums = new Numbers();
        String[] strings = spec.split(",");
        nums.setPolishIndex(Integer.parseInt(strings[0]));
        NumberStyle numberStyle = NumberStyle.fromChar(strings[1]);
        int start = Integer.parseInt(strings[2]);
        int end = Integer.parseInt(strings[3]);
        nums.setNumbers(true, numberStyle, start, end);
        numberStyle = NumberStyle.fromChar(strings[4]);
        start = Integer.parseInt(strings[5]);
        end = Integer.parseInt(strings[6]);
        nums.setNumbers(false, numberStyle, start, end);
        if (strings.length > 8) {
            String zip = strings[7];
            if (!"-1".equals(zip)) {
                nums.setZipCode(true, new ZipCodeInfo(zip));
            }
            if (!"-1".equals(zip = strings[8])) {
                nums.setZipCode(false, new ZipCodeInfo(zip));
            }
        }
        if (strings.length > 9) {
            String country;
            String region;
            int nextPos = 9;
            String city = strings[nextPos];
            if (!"-1".equals(city)) {
                region = strings[nextPos + 1];
                country = strings[nextPos + 2];
                nums.setCityInfo(true, this.createCityInfo(city, region, country));
                nextPos = 12;
            } else {
                nextPos = 10;
            }
            city = strings[nextPos];
            if (!"-1".equals(city)) {
                region = strings[nextPos + 1];
                country = strings[nextPos + 2];
                nums.setCityInfo(false, this.createCityInfo(city, region, country));
            }
        }
        return nums;
    }

    private CityInfo createCityInfo(String city, String region, String country) {
        return new CityInfo(this.recode(city), this.recode(region), PolishMapDataSource.unescape(this.recode(country)));
    }

    private List<Coord> coordsFromString(String value, boolean close) {
        String[] ords = value.split("\\) *, *\\(");
        ArrayList<Coord> points = new ArrayList<Coord>();
        for (String s : ords) {
            Coord co = PolishMapDataSource.makeCoord(s);
            if (log.isDebugEnabled()) {
                log.debug(" L: ", co);
            }
            this.mapper.addToBounds(co);
            points.add(co);
        }
        if (close && points.get(0) != points.get(points.size() - 1)) {
            if (((Coord)points.get(0)).highPrecEquals((Coord)points.get(points.size() - 1))) {
                points.set(points.size() - 1, (Coord)points.get(0));
            } else {
                points.add((Coord)points.get(0));
            }
        }
        log.debug((Object)(points.size() + " points from " + value));
        return points;
    }

    private void fixElevation() {
        if (this.elevUnits == 'm') {
            String h = this.polyline.getName();
            if (h == null) {
                return;
            }
            try {
                double m = Double.parseDouble(h);
                int feet = (int)Math.round(m * 3.2808399);
                this.polyline.setName(Integer.toString(feet));
            }
            catch (NumberFormatException e) {
                log.warn((Object)(h + " doesn't seem to be a valid elevation value in m"));
            }
        }
    }

    private void shape(String name, String value) {
        if ("Type".equals(name)) {
            this.shape.setType(this.decodeType(FeatureKind.POLYGON, value));
            if (this.shape.getType() == 75) {
                this.havePolygon4B = true;
            }
        } else if (name.startsWith("Data")) {
            this.extractResolution(name);
            this.addLineString(value, true);
        } else if ("Background".equals(name)) {
            if ("Y".equals(value)) {
                this.background = true;
            }
        } else {
            if (this.extraAttributes == null) {
                this.extraAttributes = new HashMap<String, String>();
            }
            this.extraAttributes.put(name, value);
        }
    }

    private void addLineString(String value, boolean close) {
        this.lineStringMap.computeIfAbsent(this.currentLevel, k -> new ArrayList()).add(this.coordsFromString(value, close));
    }

    private boolean isCommonValue(MapElement elem, String name, String value) {
        if ("Label".equals(name)) {
            elem.setName(PolishMapDataSource.unescape(this.recode(value)));
        } else if ("Label2".equals(name) || "Label3".equals(name)) {
            elem.add2Name(PolishMapDataSource.unescape(this.recode(value)));
        } else if ("Levels".equals(name) || "EndLevel".equals(name) || "LevelsNumber".equals(name)) {
            try {
                this.endLevel = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                this.endLevel = 0;
            }
        } else if ("ZipCode".equals(name)) {
            elem.setZip(this.recode(value));
        } else if ("CityName".equals(name)) {
            elem.setCity(this.recode(value));
        } else if ("StreetDesc".equals(name)) {
            elem.setStreet(this.recode(value));
        } else if ("HouseNumber".equals(name)) {
            elem.setHouseNumber(this.recode(value));
        } else if ("is_in".equals(name)) {
            elem.setIsIn(this.recode(value));
        } else if ("Phone".equals(name)) {
            elem.setPhone(this.recode(value));
        } else if ("CountryName".equals(name)) {
            elem.setCountry(PolishMapDataSource.unescape(this.recode(value)));
        } else if ("RegionName".equals(name)) {
            elem.setRegion(this.recode(value));
        } else {
            return false;
        }
        return true;
    }

    public static String unescape(String s) {
        int ind = s.indexOf("~[");
        if (ind < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        if (ind > 0) {
            sb.append(s.substring(0, ind));
        }
        char[] buf = s.toCharArray();
        while (ind < buf.length) {
            if (ind < buf.length - 2 && buf[ind] == '~' && buf[ind + 1] == '[') {
                StringBuilder num = new StringBuilder();
                ind += 2;
                while (ind < buf.length && buf[ind++] != ']') {
                    num.append(buf[ind - 1]);
                }
                try {
                    int inum = Integer.decode(num.toString());
                    if (inum == 6956) {
                        inum = 28;
                    }
                    if (inum >= 42) {
                        inum -= 41;
                    }
                    sb.append((char)inum);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            sb.append(buf[ind]);
            ++ind;
        }
        return sb.toString();
    }

    private String recode(String value) {
        if (this.dec != null) {
            byte[] bytes = value.getBytes(READING_CHARSET);
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            try {
                CharBuffer out = this.dec.decode(buf);
                return out.toString();
            }
            catch (CharacterCodingException e) {
                log.error((Object)"error decoding label", e);
            }
        }
        return value;
    }

    private void setResolution(MapElement elem, String name) {
        if (this.endLevel > 0) {
            elem.setMinResolution(this.extractResolution(this.endLevel));
            elem.setMaxResolution(this.extractResolution(name));
        } else {
            int res = this.extractResolution(name);
            elem.setMinResolution(res);
            elem.setMaxResolution(res);
        }
    }

    private void setResolution(MapElement elem, int level) {
        if (this.endLevel > 0) {
            elem.setMaxResolution(this.extractResolution(level));
            if (this.lineStringMap.size() > 1) {
                for (int i = level + 1; i < this.endLevel; ++i) {
                    if (!this.lineStringMap.containsKey(i)) continue;
                    elem.setMinResolution(this.extractResolution(i - 1));
                    return;
                }
            }
            elem.setMinResolution(this.extractResolution(this.endLevel));
        } else {
            int res = this.extractResolution(level);
            elem.setMinResolution(res);
            elem.setMaxResolution(res);
        }
    }

    private int extractResolution(String name) {
        this.currentLevel = Integer.parseInt(name.substring(name.charAt(0) == 'O' ? 6 : 4));
        if (this.currentLevel > 0) {
            this.dataHighLevel = true;
        }
        return this.extractResolution(this.currentLevel);
    }

    private int extractResolution(int level) {
        int nlevels = this.levels.length;
        if (level >= nlevels) {
            level = nlevels - 1;
        }
        LevelInfo li = this.levels[nlevels - level - 1];
        return li.getBits();
    }

    private void imgId(String name, String value) {
        if ("Copyright".equals(name)) {
            this.copyright = value;
        } else if ("Levels".equals(name)) {
            int nlev = Integer.parseInt(value);
            this.levels = new LevelInfo[nlev];
        } else if (name.startsWith("Level")) {
            int level = Integer.parseInt(name.substring(5), 10);
            int bits = Integer.parseInt(value);
            LevelInfo info = new LevelInfo(level, bits);
            int nlevels = this.levels.length;
            if (level >= nlevels) {
                return;
            }
            this.levels[nlevels - level - 1] = info;
        } else if (name.startsWith("Elevation")) {
            char fc = value.charAt(0);
            if (fc == 'm' || fc == 'M') {
                this.elevUnits = (char)109;
            }
        } else if ("CodePage".equalsIgnoreCase(name)) {
            this.dec = Charset.forName("cp" + value).newDecoder();
            this.dec.onUnmappableCharacter(CodingErrorAction.REPLACE);
        } else if (name.endsWith("LeftSideTraffic")) {
            if ("Y".equals(value)) {
                this.setDriveOnLeft(true);
            } else if ("N".equals(value)) {
                this.setDriveOnLeft(false);
            }
        } else if ("Transparent".equals(name)) {
            if ("Y".equals(value) || "S".equals(value)) {
                this.poiDispFlag |= 2;
            }
        } else if ("POIZipFirst".equals(name)) {
            if ("Y".equals(value)) {
                this.poiDispFlag |= 8;
            }
        } else if ("POINumberFirst".equals(name)) {
            if ("N".equals(value)) {
                this.poiDispFlag |= 4;
            }
        } else if (!"Numbering".equals(name)) {
            if ("Routing".equals(name)) {
                if ("Y".equals(value)) {
                    this.routing = true;
                }
            } else if ("CountryName".equalsIgnoreCase(name)) {
                this.defaultCountry = value;
            } else if ("RegionName".equalsIgnoreCase(name)) {
                this.defaultRegion = value;
            } else {
                log.info((Object)("'IMG ID' section: ignoring " + name + " " + value));
            }
        }
    }

    private static Coord makeCoord(String value) {
        String[] fields = value.split("[(,)]");
        int i = 0;
        if (fields[0].isEmpty()) {
            i = 1;
        }
        Double f1 = Double.valueOf(fields[i]);
        Double f2 = Double.valueOf(fields[i + 1]);
        return new Coord(f1, f2);
    }

    private ExtTypeAttributes makeExtTypeAttributes() {
        HashMap<String, String> eta = new HashMap<String, String>();
        int colour = 0;
        int style = 0;
        for (Map.Entry<String, String> entry : this.extraAttributes.entrySet()) {
            String u;
            String v = entry.getValue();
            if ("Depth".equals(entry.getKey())) {
                u = this.extraAttributes.get("DepthUnit");
                if ("f".equals(u)) {
                    v = v + "ft";
                }
                eta.put("depth", v);
                continue;
            }
            if ("Height".equals(entry.getKey())) {
                u = this.extraAttributes.get("HeightUnit");
                if ("f".equals(u)) {
                    v = v + "ft";
                }
                eta.put("height", v);
                continue;
            }
            if ("HeightAboveFoundation".equals(entry.getKey())) {
                u = this.extraAttributes.get("HeightAboveFoundationUnit");
                if ("f".equals(u)) {
                    v = v + "ft";
                }
                eta.put("height-above-foundation", v);
                continue;
            }
            if ("HeightAboveDatum".equals(entry.getKey())) {
                u = this.extraAttributes.get("HeightAboveDatumUnit");
                if ("f".equals(u)) {
                    v = v + "ft";
                }
                eta.put("height-above-datum", v);
                continue;
            }
            if ("Color".equals(entry.getKey())) {
                colour = Integer.decode(v);
                continue;
            }
            if ("Style".equals(entry.getKey())) {
                style = Integer.decode(v);
                continue;
            }
            if ("Position".equals(entry.getKey())) {
                eta.put("position", v);
                continue;
            }
            if ("FoundationColor".equals(entry.getKey())) {
                eta.put("color", v);
                continue;
            }
            if ("Light".equals(entry.getKey())) {
                eta.put("light", v);
                continue;
            }
            if ("LightType".equals(entry.getKey())) {
                eta.put("type", v);
                continue;
            }
            if ("Period".equals(entry.getKey())) {
                eta.put("period", v);
                continue;
            }
            if ("Note".equals(entry.getKey())) {
                eta.put("note", v);
                continue;
            }
            if ("LocalDesignator".equals(entry.getKey())) {
                eta.put("local-desig", v);
                continue;
            }
            if ("InternationalDesignator".equals(entry.getKey())) {
                eta.put("int-desig", v);
                continue;
            }
            if ("FacilityPoint".equals(entry.getKey())) {
                eta.put("facilities", v);
                continue;
            }
            if ("Racon".equals(entry.getKey())) {
                eta.put("racon", v);
                continue;
            }
            if (!"LeadingAngle".equals(entry.getKey())) continue;
            eta.put("leading-angle", v);
        }
        if (colour != 0 || style != 0) {
            eta.put("style", "0x" + Integer.toHexString(style << 8 | colour));
        }
        return new ExtTypeAttributes(eta, "Line " + this.lineNo);
    }

    private void restriction(String name, String value) {
        try {
            if (this.restriction.isValid() && !"Nod".equalsIgnoreCase(name)) {
                if ("TraffPoints".equalsIgnoreCase(name)) {
                    this.restriction.setTrafficPoints(value);
                } else if ("TraffRoads".equalsIgnoreCase(name)) {
                    this.restriction.setTrafficRoads(value);
                } else if ("RestrParam".equalsIgnoreCase(name)) {
                    this.restriction.setExceptMask(PolishMapDataSource.getRestrictionExceptionMask(value));
                } else if ("Time".equalsIgnoreCase(name)) {
                    log.info((Object)("Time in restriction definition is ignored " + this.restriction));
                }
            }
        }
        catch (NumberFormatException ex) {
            this.restriction.setValid(false);
            log.error((Object)("Invalid restriction definition. " + this.restriction));
        }
    }

    private static byte getRestrictionExceptionMask(String value) {
        String[] params = value.split(",");
        byte exceptMask = 0;
        if (params.length > 0 && params.length <= 8) {
            block10: for (int i = 0; i < params.length; ++i) {
                if (!"1".equals(params[i])) continue;
                switch (i) {
                    case 0: {
                        exceptMask = (byte)(exceptMask | 0xFFFFFF80);
                        continue block10;
                    }
                    case 1: {
                        exceptMask = (byte)(exceptMask | 8);
                        continue block10;
                    }
                    case 2: {
                        exceptMask = (byte)(exceptMask | 4);
                        continue block10;
                    }
                    case 3: {
                        exceptMask = (byte)(exceptMask | 0x20);
                        continue block10;
                    }
                    case 4: {
                        exceptMask = (byte)(exceptMask | 0x40);
                        continue block10;
                    }
                    case 5: {
                        exceptMask = (byte)(exceptMask | 1);
                        continue block10;
                    }
                    case 6: {
                        exceptMask = (byte)(exceptMask | 2);
                        continue block10;
                    }
                    case 7: {
                        exceptMask = (byte)(exceptMask | 0x10);
                    }
                }
            }
        } else {
            log.error((Object)("Invalid RestrParam definition. -> " + value));
        }
        return exceptMask;
    }

    @Override
    public int getPoiDispFlag() {
        return this.poiDispFlag;
    }

    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    public String getDefaultRegion() {
        return this.defaultRegion;
    }

    private int decodeType(FeatureKind kind, String type) {
        try {
            int t = Integer.decode(type);
            if ((kind == FeatureKind.POLYGON || kind == FeatureKind.POLYLINE) && t >= 256 && t < 65536 && (t & 0xFF) == 0) {
                t >>= 8;
            }
            this.checkType(kind, t);
            return t;
        }
        catch (NumberFormatException e) {
            throw new MapFailedException("type not numeric " + type + " for " + (Object)((Object)kind) + ", line " + this.lineNo);
        }
    }

    private void checkType(FeatureKind kind, int type) {
        if (kind == FeatureKind.POLYGON && type == 74) {
            return;
        }
        if (!GType.checkType(kind, type)) {
            throw new MapFailedException("invalid type " + GType.formatType(type) + " for " + (Object)((Object)kind) + ", line " + this.lineNo);
        }
    }
}

