/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.util.ArrayList;
import java.util.Map;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmConverter;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.boundary.Boundary;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryLocationInfo;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryLocationPreparer;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryRelation;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundarySaver;
import uk.me.parabola.util.EnhancedProperties;

public class BoundaryElementSaver
extends ElementSaver {
    private static final Logger log = Logger.getLogger(BoundaryElementSaver.class);
    private final BoundarySaver saver;
    private final BoundaryLocationPreparer preparer;

    public BoundaryElementSaver(EnhancedProperties args, BoundarySaver saver) {
        super(args);
        this.saver = saver;
        this.preparer = new BoundaryLocationPreparer(new EnhancedProperties());
    }

    public boolean isBoundary(Element element) {
        if (element instanceof Relation) {
            String type = element.getTag("type");
            if (!"boundary".equals(type) && !"multipolygon".equals(type)) {
                return false;
            }
        } else if (element instanceof Way) {
            Way w = (Way)element;
            if (!w.isClosedInOSM()) {
                return false;
            }
        } else {
            return false;
        }
        return this.hasRelevantTags(element);
    }

    private boolean hasRelevantTags(Element element) {
        BoundaryLocationInfo bInfo = this.preparer.parseTags(element);
        if (bInfo.getZip() != null) {
            return true;
        }
        if (bInfo.getAdmLevel() == 100) {
            return false;
        }
        if (bInfo.getName() != null && !"?".equals(bInfo.getName())) {
            return true;
        }
        if (bInfo.getAdmLevel() >= 3 && bInfo.getAdmLevel() <= 11) {
            for (Map.Entry<String, String> tag : element.getTagEntryIterator()) {
                if (!tag.getKey().contains("name")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addRelation(Relation rel) {
        if (this.isBoundary(rel)) {
            BoundaryRelation bRel = (BoundaryRelation)this.createMultiPolyRelation(rel);
            bRel.processElements();
            Boundary b = bRel.getBoundary();
            if (b != null) {
                this.saver.addBoundary(b);
            }
        } else {
            log.warn("Relation is not processed due to missing tags:", rel.getId(), rel.toTagString());
        }
    }

    @Override
    public void deferRelation(long id, Relation rel, String role) {
    }

    @Override
    public Relation createMultiPolyRelation(Relation rel) {
        return new BoundaryRelation(rel, this.wayMap, this.getBoundingBox());
    }

    @Override
    public void addNode(Node node) {
    }

    @Override
    public void convert(OsmConverter converter) {
        this.nodeMap = null;
        converter.setBoundingBox(this.getBoundingBox());
        ArrayList relations = new ArrayList(this.relationMap.values());
        this.relationMap = null;
        for (int i = 0; i < relations.size(); ++i) {
            converter.convertRelation((Relation)relations.get(i));
            relations.set(i, null);
        }
        relations = null;
        for (Way w : this.wayMap.values()) {
            if (!this.isBoundary(w)) continue;
            converter.convertWay(w);
        }
        this.wayMap = null;
        converter.end();
    }
}

