/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.Java2DConverter;

public class MultiPolygonCutter {
    private static final Logger log = Logger.getLogger(MultiPolygonCutter.class);
    private final MultiPolygonRelation rel;
    private final Area tileArea;
    private final Long2ObjectOpenHashMap<Coord> commonCoordMap;
    private static final int CUT_POINT_CLASSIFICATION_GOOD_THRESHOLD = 131072;
    private static final int CUT_POINT_CLASSIFICATION_BAD_THRESHOLD = 16384;
    private static final AreaComparator COMP_LONG_START = new AreaComparator(true, CoordinateAxis.LONGITUDE);
    private static final AreaComparator COMP_LONG_STOP = new AreaComparator(false, CoordinateAxis.LONGITUDE);
    private static final AreaComparator COMP_LAT_START = new AreaComparator(true, CoordinateAxis.LATITUDE);
    private static final AreaComparator COMP_LAT_STOP = new AreaComparator(false, CoordinateAxis.LATITUDE);

    public MultiPolygonCutter(MultiPolygonRelation multiPolygonRelation, Area tileArea, Long2ObjectOpenHashMap<Coord> commonCoordMap) {
        this.rel = multiPolygonRelation;
        this.tileArea = tileArea;
        this.commonCoordMap = commonCoordMap;
    }

    public List<Way> cutOutInnerPolygons(Way outerPolygon, List<Way> innerPolygons) {
        if (innerPolygons.isEmpty()) {
            Way outerWay = new Way(outerPolygon.getId(), outerPolygon.getPoints());
            if (log.isDebugEnabled()) {
                log.debug("Way", outerPolygon.getId(), "splitted to way", outerWay.getId());
            }
            return Collections.singletonList(outerWay);
        }
        LinkedList<AreaCutData> areasToCut = new LinkedList<AreaCutData>();
        ArrayList<Area> finishedAreas = new ArrayList<Area>(innerPolygons.size());
        List<Area> outerAreas = this.createAreas(outerPolygon, true);
        ArrayList<Area> innerAreas = new ArrayList<Area>(innerPolygons.size() + 2);
        for (Way innerPolygon : innerPolygons) {
            innerAreas.addAll(this.createAreas(innerPolygon, false));
        }
        if (innerAreas.isEmpty()) {
            finishedAreas.addAll(outerAreas);
        } else if (outerAreas.size() == 1) {
            AreaCutData initialCutData = new AreaCutData();
            initialCutData.outerArea = outerAreas.get(0);
            initialCutData.innerAreas = innerAreas;
            areasToCut.add(initialCutData);
        } else {
            MultiPolygonCutter.combineOuterAndInner(outerAreas, innerAreas, finishedAreas, areasToCut);
        }
        while (!areasToCut.isEmpty()) {
            AreaCutData areaCutData = (AreaCutData)areasToCut.poll();
            CutPoint cutPoint = MultiPolygonCutter.calcNextCutPoint(areaCutData);
            if (cutPoint == null) {
                finishedAreas.add(areaCutData.outerArea);
                continue;
            }
            assert (cutPoint.getNumberOfAreas() > 0) : "Number of cut areas == 0 in mp " + this.rel.getId();
            if (cutPoint.getAreas().size() == 1) {
                areaCutData.outerArea.subtract(cutPoint.getAreas().get(0));
            } else {
                Path2D.Double path = new Path2D.Double(1, innerAreas.size() * 20);
                for (Area cutArea : cutPoint.getAreas()) {
                    path.append(cutArea, false);
                }
                Area combinedCutAreas = new Area(path);
                areaCutData.outerArea.subtract(combinedCutAreas);
            }
            if (areaCutData.outerArea.isEmpty()) continue;
            block3: for (Area cutArea : cutPoint.getAreas()) {
                ListIterator<Area> areaIter = areaCutData.innerAreas.listIterator();
                while (areaIter.hasNext()) {
                    Area a = areaIter.next();
                    if (a != cutArea) continue;
                    areaIter.remove();
                    continue block3;
                }
            }
            if (areaCutData.outerArea.isSingular()) {
                if (areaCutData.innerAreas.isEmpty()) {
                    finishedAreas.add(areaCutData.outerArea);
                    continue;
                }
                areasToCut.add(areaCutData);
                continue;
            }
            Rectangle2D r1 = cutPoint.getCutRectangleForArea(areaCutData.outerArea, true);
            Rectangle2D r2 = cutPoint.getCutRectangleForArea(areaCutData.outerArea, false);
            MultiPolygonCutter.cutWithRectangle(r1, areaCutData, finishedAreas, areasToCut);
            MultiPolygonCutter.cutWithRectangle(r2, areaCutData, finishedAreas, areasToCut);
        }
        ArrayList<Way> cuttedOuterPolygon = new ArrayList<Way>(finishedAreas.size());
        for (Area area : finishedAreas) {
            Way w = this.singularAreaToWay(area, this.rel.getOriginalId());
            if (w == null) continue;
            w.markAsGeneratedFrom(this.rel);
            w.copyTags(outerPolygon);
            cuttedOuterPolygon.add(w);
            if (!log.isDebugEnabled()) continue;
            log.debug("Way", outerPolygon.getId(), "splitted to way", w.getId());
        }
        return cuttedOuterPolygon;
    }

    private static void cutWithRectangle(Rectangle2D cutRect, AreaCutData areaCutData, Collection<Area> finishedAreas, Queue<AreaCutData> areasToCut) {
        Area outer = new Area(cutRect);
        outer.intersect(areaCutData.outerArea);
        List<Area> dividedAreas = Java2DConverter.areaToSingularAreas(outer);
        if (areaCutData.innerAreas.isEmpty()) {
            finishedAreas.addAll(dividedAreas);
            return;
        }
        MultiPolygonCutter.combineOuterAndInner(dividedAreas, areaCutData.innerAreas, finishedAreas, areasToCut);
    }

    private static void combineOuterAndInner(List<Area> outerAreas, List<Area> innerAreas, Collection<Area> finishedAreas, Queue<AreaCutData> areasToCut) {
        for (Area nextOuterArea : outerAreas) {
            ArrayList<Area> nextInnerAreas = null;
            for (Area nonProcessedInner : innerAreas) {
                if (!nextOuterArea.intersects(nonProcessedInner.getBounds2D())) continue;
                if (nextInnerAreas == null) {
                    nextInnerAreas = new ArrayList<Area>();
                }
                nextInnerAreas.add(nonProcessedInner);
            }
            if (nextInnerAreas == null) {
                finishedAreas.add(nextOuterArea);
                continue;
            }
            AreaCutData outCutData = new AreaCutData();
            outCutData.outerArea = nextOuterArea;
            outCutData.innerAreas = nextInnerAreas;
            areasToCut.add(outCutData);
        }
    }

    private static CutPoint calcNextCutPoint(AreaCutData areaData) {
        if (areaData.innerAreas == null || areaData.innerAreas.isEmpty()) {
            return null;
        }
        Rectangle2D outerBounds = areaData.outerArea.getBounds2D();
        if (areaData.innerAreas.size() == 1) {
            CutPoint cutPoint1 = new CutPoint(CoordinateAxis.LATITUDE, outerBounds);
            cutPoint1.addArea(areaData.innerAreas.get(0));
            CutPoint cutPoint2 = new CutPoint(CoordinateAxis.LONGITUDE, outerBounds);
            cutPoint2.addArea(areaData.innerAreas.get(0));
            if (cutPoint1.compareTo(cutPoint2) > 0) {
                return cutPoint1;
            }
            return cutPoint2;
        }
        ArrayList<Area> innersSorted = new ArrayList<Area>(areaData.innerAreas);
        CutPoint bestCutPoint = null;
        for (CoordinateAxis axis : CoordinateAxis.values()) {
            CutPoint currentCutPoint = new CutPoint(axis, outerBounds);
            innersSorted.sort(axis == CoordinateAxis.LONGITUDE ? COMP_LONG_START : COMP_LAT_START);
            for (Area inner : innersSorted) {
                currentCutPoint.addArea(inner);
                if (bestCutPoint != null && currentCutPoint.compareTo(bestCutPoint) <= 0) continue;
                bestCutPoint = currentCutPoint.duplicate();
            }
        }
        return bestCutPoint;
    }

    private List<Area> createAreas(Way w, boolean clipBbox) {
        Area area = Java2DConverter.createArea(w.getPoints());
        if (clipBbox && !this.tileArea.contains(area.getBounds2D())) {
            area.intersect(this.tileArea);
        }
        List<Area> areaList = Java2DConverter.areaToSingularAreas(area);
        if (log.isDebugEnabled()) {
            log.debug("Bbox clipped way", w.getId() + "=>", areaList.size(), "distinct area(s).");
        }
        return areaList;
    }

    private Way singularAreaToWay(Area area, long wayId) {
        List<Coord> points = Java2DConverter.singularAreaToPoints(area, this.commonCoordMap);
        if (points == null || points.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Empty area", wayId + ".", this.rel.toBrowseURL());
            }
            return null;
        }
        return new Way(wayId, points);
    }

    private static class AreaComparator
    implements Comparator<Area> {
        private final CoordinateAxis axis;
        private final boolean startPoint;

        public AreaComparator(boolean startPoint, CoordinateAxis axis) {
            this.startPoint = startPoint;
            this.axis = axis;
        }

        @Override
        public int compare(Area o1, Area o2) {
            if (o1 == o2) {
                return 0;
            }
            if (this.startPoint) {
                int cmp = this.axis.getStartHighPrec(o1) - this.axis.getStartHighPrec(o2);
                if (cmp == 0) {
                    return this.axis.getStopHighPrec(o1) - this.axis.getStopHighPrec(o2);
                }
                return cmp;
            }
            int cmp = this.axis.getStopHighPrec(o1) - this.axis.getStopHighPrec(o2);
            if (cmp == 0) {
                return this.axis.getStartHighPrec(o1) - this.axis.getStartHighPrec(o2);
            }
            return cmp;
        }
    }

    private static enum CoordinateAxis {
        LATITUDE(false),
        LONGITUDE(true);

        private final boolean useX;

        private CoordinateAxis(boolean useX) {
            this.useX = useX;
        }

        public int getStartHighPrec(Area area) {
            return this.getStartHighPrec(area.getBounds2D());
        }

        public int getStartHighPrec(Rectangle2D rect) {
            double val = this.useX ? rect.getX() : rect.getY();
            return (int)Math.round(val * 64.0);
        }

        public int getStopHighPrec(Area area) {
            return this.getStopHighPrec(area.getBounds2D());
        }

        public int getStopHighPrec(Rectangle2D rect) {
            double val = this.useX ? rect.getMaxX() : rect.getMaxY();
            return (int)Math.round(val * 64.0);
        }

        public double getSizeOfSide(Rectangle2D rect) {
            if (this.useX) {
                int latHp = (int)Math.round(rect.getY() * 64.0);
                Coord c1 = Coord.makeHighPrecCoord(latHp, this.getStartHighPrec(rect));
                Coord c2 = Coord.makeHighPrecCoord(latHp, this.getStopHighPrec(rect));
                return c1.distance(c2);
            }
            int lonHp = (int)Math.round(rect.getX() * 64.0);
            Coord c1 = Coord.makeHighPrecCoord(this.getStartHighPrec(rect), lonHp);
            Coord c2 = Coord.makeHighPrecCoord(this.getStopHighPrec(rect), lonHp);
            return c1.distance(c2);
        }
    }

    private static class CutPoint
    implements Comparable<CutPoint> {
        private int startPoinHp = Integer.MAX_VALUE;
        private int stopPointHp = Integer.MIN_VALUE;
        private Integer cutPointHp = null;
        private final LinkedList<Area> areas;
        private final Comparator<Area> comparator;
        private final CoordinateAxis axis;
        private Rectangle2D bounds;
        private final Rectangle2D outerBounds;
        private Double minAspectRatio;

        public CutPoint(CoordinateAxis axis, Rectangle2D outerBounds) {
            this.axis = axis;
            this.outerBounds = outerBounds;
            this.areas = new LinkedList();
            this.comparator = axis == CoordinateAxis.LONGITUDE ? COMP_LONG_STOP : COMP_LAT_STOP;
        }

        public CutPoint duplicate() {
            CutPoint newCutPoint = new CutPoint(this.axis, this.outerBounds);
            newCutPoint.areas.addAll(this.areas);
            newCutPoint.startPoinHp = this.startPoinHp;
            newCutPoint.stopPointHp = this.stopPointHp;
            return newCutPoint;
        }

        private boolean isGoodCutPoint() {
            return this.getCutPointHighPrec() % 131072 == 0;
        }

        private boolean isBadCutPoint() {
            int d2;
            int d1 = this.getCutPointHighPrec() - this.startPoinHp;
            return Math.min(d1, d2 = this.stopPointHp - this.getCutPointHighPrec()) < 16384;
        }

        private int getCutPointHighPrec() {
            int cut2;
            int cut1;
            int cutMod;
            if (this.cutPointHp != null) {
                return this.cutPointHp;
            }
            if (this.startPoinHp == this.stopPointHp) {
                this.cutPointHp = this.startPoinHp;
                return this.cutPointHp;
            }
            int midOuterHp = this.axis.getStartHighPrec(this.outerBounds) + (this.axis.getStopHighPrec(this.outerBounds) - this.axis.getStartHighPrec(this.outerBounds)) / 2;
            this.cutPointHp = midOuterHp;
            if (midOuterHp < this.startPoinHp) {
                this.cutPointHp = this.startPoinHp;
                if ((this.cutPointHp & 0xFFFE0000) + 131072 <= this.stopPointHp) {
                    this.cutPointHp = (this.cutPointHp & 0xFFFE0000) + 131072;
                }
            } else if (midOuterHp > this.stopPointHp) {
                this.cutPointHp = this.stopPointHp;
                if ((this.cutPointHp & 0xFFFE0000) >= this.startPoinHp) {
                    this.cutPointHp = this.cutPointHp & 0xFFFE0000;
                }
            }
            if ((cutMod = this.cutPointHp % 131072) == 0) {
                return this.cutPointHp;
            }
            int n = cut1 = cutMod > 0 ? this.cutPointHp - cutMod : this.cutPointHp - 131072 - cutMod;
            if (cut1 >= this.startPoinHp && cut1 <= this.stopPointHp) {
                this.cutPointHp = cut1;
                return this.cutPointHp;
            }
            int n2 = cut2 = cutMod > 0 ? this.cutPointHp + 131072 - cutMod : this.cutPointHp - cutMod;
            if (cut2 >= this.startPoinHp && cut2 <= this.stopPointHp) {
                this.cutPointHp = cut2;
                return this.cutPointHp;
            }
            return this.cutPointHp;
        }

        public Rectangle2D getCutRectangleForArea(Area toCut, boolean firstRect) {
            return this.getCutRectangleForArea(toCut.getBounds2D(), firstRect);
        }

        public Rectangle2D getCutRectangleForArea(Rectangle2D areaRect, boolean firstRect) {
            double cp = (double)this.getCutPointHighPrec() / 64.0;
            if (this.axis == CoordinateAxis.LONGITUDE) {
                double newWidth = cp - areaRect.getX();
                if (firstRect) {
                    return new Rectangle2D.Double(areaRect.getX(), areaRect.getY(), newWidth, areaRect.getHeight());
                }
                return new Rectangle2D.Double(areaRect.getX() + newWidth, areaRect.getY(), areaRect.getWidth() - newWidth, areaRect.getHeight());
            }
            double newHeight = cp - areaRect.getY();
            if (firstRect) {
                return new Rectangle2D.Double(areaRect.getX(), areaRect.getY(), areaRect.getWidth(), newHeight);
            }
            return new Rectangle2D.Double(areaRect.getX(), areaRect.getY() + newHeight, areaRect.getWidth(), areaRect.getHeight() - newHeight);
        }

        public List<Area> getAreas() {
            return this.areas;
        }

        public void addArea(Area area) {
            while (!this.areas.isEmpty() && this.axis.getStopHighPrec(this.areas.getFirst()) < this.axis.getStartHighPrec(area)) {
                this.areas.removeFirst();
            }
            this.areas.add(area);
            this.areas.sort(this.comparator);
            this.startPoinHp = this.axis.getStartHighPrec(Collections.max(this.areas, this.axis == CoordinateAxis.LONGITUDE ? COMP_LONG_START : COMP_LAT_START));
            this.stopPointHp = this.axis.getStopHighPrec(this.areas.getFirst());
            this.bounds = null;
            this.cutPointHp = null;
            this.minAspectRatio = null;
        }

        public int getNumberOfAreas() {
            return this.areas.size();
        }

        public double getMinAspectRatio() {
            if (this.minAspectRatio == null) {
                Rectangle2D r1 = this.getCutRectangleForArea(this.outerBounds, true);
                double s11 = CoordinateAxis.LATITUDE.getSizeOfSide(r1);
                double s12 = CoordinateAxis.LONGITUDE.getSizeOfSide(r1);
                double ar1 = Math.min(s11, s12) / Math.max(s11, s12);
                Rectangle2D r2 = this.getCutRectangleForArea(this.outerBounds, false);
                double s21 = CoordinateAxis.LATITUDE.getSizeOfSide(r2);
                double s22 = CoordinateAxis.LONGITUDE.getSizeOfSide(r2);
                double ar2 = Math.min(s21, s22) / Math.max(s21, s22);
                this.minAspectRatio = Math.min(ar1, ar2);
            }
            return this.minAspectRatio;
        }

        @Override
        public int compareTo(CutPoint o) {
            if (this == o) {
                return 0;
            }
            if (this.getNumberOfAreas() == 0) {
                return o.getNumberOfAreas() == 0 ? 0 : -1;
            }
            if (o.getNumberOfAreas() == 0) {
                return 1;
            }
            int d = Boolean.compare(o.isBadCutPoint(), this.isBadCutPoint());
            if (d != 0) {
                return d;
            }
            double dAR = this.getMinAspectRatio() - o.getMinAspectRatio();
            if (dAR != 0.0) {
                return dAR > 0.0 ? 1 : -1;
            }
            d = Boolean.compare(this.isGoodCutPoint(), o.isGoodCutPoint());
            if (d != 0) {
                return d;
            }
            d = Double.compare(this.axis.getSizeOfSide(this.getBounds2D()), o.axis.getSizeOfSide(o.getBounds2D()));
            if (d != 0) {
                return d;
            }
            return this.getNumberOfAreas() - o.getNumberOfAreas();
        }

        private Rectangle2D getBounds2D() {
            if (this.bounds == null) {
                this.bounds = new Rectangle2D.Double();
                for (Area a : this.areas) {
                    this.bounds.add(a.getBounds2D());
                }
            }
            return this.bounds;
        }

        public String toString() {
            return (Object)((Object)this.axis) + " " + this.getNumberOfAreas() + " " + this.startPoinHp + " " + this.stopPointHp + " " + this.getCutPointHighPrec();
        }
    }

    private static class AreaCutData {
        Area outerArea;
        List<Area> innerAreas;

        private AreaCutData() {
        }
    }
}

