/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.StyleFileLoader;

public class JarFileLoader
extends StyleFileLoader
implements Closeable {
    private static final Logger log = Logger.getLogger(JarFileLoader.class);
    private JarFile jarFile;
    private String prefix;

    public JarFileLoader(URL url) throws FileNotFoundException {
        this.jarInit(url, null);
    }

    public JarFileLoader(String url, String name) throws FileNotFoundException {
        try {
            this.jarInit(new URL(JarFileLoader.makeJarUrl(url)), name);
        }
        catch (MalformedURLException e) {
            throw new FileNotFoundException("Could not open style at " + url);
        }
    }

    private static String makeJarUrl(String url) {
        if (url.toLowerCase().startsWith("jar:")) {
            return url;
        }
        return "jar:" + url + "!/";
    }

    private void jarInit(URL url, String name) throws FileNotFoundException {
        log.debug("opening", url);
        try {
            JarURLConnection jurl = (JarURLConnection)url.openConnection();
            jurl.setUseCaches(false);
            this.jarFile = jurl.getJarFile();
            this.prefix = jurl.getEntryName();
            if (this.prefix == null) {
                this.prefix = JarFileLoader.searchVersion(this.jarFile, name);
            }
            log.debug("jar prefix is", this.prefix);
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not open style at " + url);
        }
    }

    private static String searchVersion(JarFile file, String style) {
        Enumeration<JarEntry> en = file.entries();
        String flatEnd = style == null ? "version" : style + "/version";
        String end = "/" + flatEnd;
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            String ename = entry.getName();
            if (!ename.endsWith(end) && !ename.equals(flatEnd)) continue;
            return ename.substring(0, ename.length() - "version".length());
        }
        return null;
    }

    @Override
    public Reader open(String filename) throws FileNotFoundException {
        InputStream stream;
        JarEntry jarEntry;
        if (this.jarFile == null) {
            throw new FileNotFoundException("Could not open file " + filename);
        }
        String path = filename;
        if (this.prefix != null) {
            path = this.prefix + filename;
        }
        if ((jarEntry = this.jarFile.getJarEntry(path)) == null) {
            throw new FileNotFoundException("Could not open style file " + filename);
        }
        try {
            stream = this.jarFile.getInputStream(jarEntry);
        }
        catch (IOException e) {
            throw new FileNotFoundException("Could not open " + filename);
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        return new BufferedReader(reader);
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException e) {
            log.debug((Object)"failed to close jar file");
        }
    }

    @Override
    public String[] list() {
        Enumeration<JarEntry> en = this.jarFile.entries();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasMoreElements()) {
            String name;
            JarEntry entry = en.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).endsWith("version")) continue;
            log.debug("name is", name);
            String[] dirs = name.split("/");
            if (dirs.length == 1) {
                String s = this.jarFile.getName();
                s = s.replaceFirst("\\..*$", "");
                s = s.replaceAll(".*/", "");
                list.add(s);
                continue;
            }
            list.add(dirs[dirs.length - 2]);
        }
        return list.toArray(new String[list.size()]);
    }
}

