/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.filters.ShapeMergeFilter;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;

public class MapShape
extends MapLine {
    private long osmid;
    private long fullArea = Long.MAX_VALUE;
    private MultiPolygonRelation mpRel;

    public MapShape() {
        this.osmid = 0L;
    }

    public MapShape(long id) {
        this.osmid = id;
    }

    MapShape(MapShape s) {
        super(s);
        this.osmid = s.osmid;
        this.fullArea = s.getFullArea();
        this.mpRel = s.mpRel;
    }

    @Override
    public MapShape copy() {
        return new MapShape(this);
    }

    @Override
    public void setDirection(boolean direction) {
        throw new IllegalArgumentException("can't set a direction on a polygon");
    }

    public void setOsmid(long osmid) {
        this.osmid = osmid;
    }

    public long getOsmid() {
        return this.osmid;
    }

    public void setFullArea(long fullArea) {
        this.fullArea = fullArea;
    }

    public long getFullArea() {
        List<Coord> points;
        if (this.fullArea == Long.MAX_VALUE && (points = this.getPoints()) != null && points.size() >= 4 && points.get(0).highPrecEquals(points.get(points.size() - 1))) {
            this.fullArea = ShapeMergeFilter.calcAreaSizeTestVal(points);
        }
        return this.fullArea;
    }

    public MultiPolygonRelation getMpRel() {
        return this.mpRel;
    }

    public void setMpRel(MultiPolygonRelation mpRel) {
        this.mpRel = mpRel;
    }
}

