/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.osmstyle.WrongAngleFixer;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.GType;

public class ShapeMergeFilter {
    private static final Logger log = Logger.getLogger(ShapeMergeFilter.class);
    private final int resolution;
    private static final ShapeHelper DUP_SHAPE = new ShapeHelper(new ArrayList<Coord>(0));
    private final boolean orderByDecreasingArea;
    private final int maxPoints;
    private final boolean ignoreRes;
    public static final long SINGLE_POINT_AREA = 4096L;

    public ShapeMergeFilter(int resolution, boolean orderByDecreasingArea) {
        this.ignoreRes = resolution < 0;
        this.resolution = resolution;
        this.orderByDecreasingArea = orderByDecreasingArea;
        this.maxPoints = this.ignoreRes ? Integer.MAX_VALUE : 250;
    }

    public List<MapShape> merge(List<MapShape> shapes) {
        if (shapes.size() <= 1) {
            return shapes;
        }
        ArrayList<MapShape> mergedShapes = new ArrayList<MapShape>();
        ArrayList<MapShape> usableShapes = new ArrayList<MapShape>();
        for (MapShape shape : shapes) {
            if (!this.ignoreRes && (shape.getMinResolution() > this.resolution || shape.getMaxResolution() < this.resolution)) continue;
            if (shape.getPoints().get(0) != shape.getPoints().get(shape.getPoints().size() - 1)) {
                log.error("shape is not closed with identical points", shape.getOsmid(), shape.getPoints().get(0).toOSMURL());
                mergedShapes.add(shape);
                continue;
            }
            usableShapes.add(shape);
        }
        if (usableShapes.size() < 2) {
            mergedShapes.addAll(usableShapes);
            return mergedShapes;
        }
        MapShapeComparator comparator = new MapShapeComparator(this.orderByDecreasingArea);
        usableShapes.sort(comparator);
        int p1 = 0;
        MapShape s1 = (MapShape)usableShapes.get(0);
        for (int i = 1; i < usableShapes.size(); ++i) {
            if (comparator.compare(s1, usableShapes.get(i)) == 0) continue;
            this.mergeSimilar(usableShapes.subList(p1, i), mergedShapes);
            s1 = (MapShape)usableShapes.get(i);
            p1 = i;
        }
        if (p1 < usableShapes.size()) {
            this.mergeSimilar(usableShapes.subList(p1, usableShapes.size()), mergedShapes);
        }
        return mergedShapes;
    }

    private void mergeSimilar(List<MapShape> similar, List<MapShape> mergedShapes) {
        if (similar.size() == 1) {
            mergedShapes.addAll(similar);
            return;
        }
        int partSize = 8192;
        similar.sort((o1, o2) -> o1.getBounds().getCenter().compareTo(o2.getBounds().getCenter()));
        ArrayList<ShapeHelper> list = new ArrayList<ShapeHelper>();
        MapShape pattern = similar.get(0);
        for (MapShape ms : similar) {
            ShapeHelper sh = new ShapeHelper(ms.getPoints());
            sh.id = ms.getOsmid();
            list.add(sh);
        }
        while (list.size() > 8192) {
            int oldSize = list.size();
            ArrayList<ShapeHelper> nextList = new ArrayList<ShapeHelper>();
            for (int part = 0; part < list.size(); part += 8192) {
                ArrayList<ShapeHelper> lower = new ArrayList<ShapeHelper>(list.subList(part, Math.min(part + 8192, list.size())));
                this.tryMerge(pattern, lower);
                nextList.addAll(lower);
            }
            list.clear();
            list.addAll(nextList);
            if (list.size() != oldSize) continue;
            break;
        }
        this.tryMerge(pattern, list);
        for (ShapeHelper sh : list) {
            MapShape newShape = pattern.copy();
            if (sh.getPoints().get(0) != sh.getPoints().get(sh.getPoints().size() - 1)) {
                throw new MapFailedException("shape is no longer closed");
            }
            if (sh.id == 0L) {
                List<Coord> optimizedPoints = sh.getPoints();
                if (!this.ignoreRes) {
                    optimizedPoints = WrongAngleFixer.fixAnglesInShape(optimizedPoints);
                }
                if (optimizedPoints.isEmpty()) continue;
                newShape.setPoints(optimizedPoints);
                newShape.setOsmid(FakeIdGenerator.makeFakeId());
            } else {
                newShape.setPoints(sh.getPoints());
                newShape.setOsmid(sh.id);
            }
            mergedShapes.add(newShape);
        }
    }

    private void tryMerge(MapShape pattern, List<ShapeHelper> similarShapes) {
        if (similarShapes.size() <= 1) {
            return;
        }
        int numCandidates = similarShapes.size();
        List<BitSet> candidates = this.createMatrix(similarShapes);
        ArrayList<ShapeHelper> next = new ArrayList<ShapeHelper>();
        boolean merged = false;
        BitSet done = new BitSet();
        BitSet delayed = new BitSet();
        ArrayList<ShapeHelper> noMerge = new ArrayList<ShapeHelper>();
        class SortHelper {
            final int pos;
            final BitSet all;

            public SortHelper(int index, BitSet set) {
                this.pos = index;
                this.all = set;
            }
        }
        ArrayList<SortHelper> byNum = new ArrayList<SortHelper>();
        for (int i2 = 0; i2 < numCandidates; ++i2) {
            byNum.add(new SortHelper(i2, candidates.get(i2)));
        }
        byNum.sort((o1, o2) -> o1.all.cardinality() - o2.all.cardinality());
        for (SortHelper helper : byNum) {
            int j;
            IntListIterator intListIterator;
            int pos = helper.pos;
            BitSet all = helper.all;
            if (all.isEmpty()) {
                noMerge.add(similarShapes.get(pos));
                done.set(pos);
            }
            if (done.get(pos)) continue;
            if (all.cardinality() == 1) {
                delayed.set(pos);
                continue;
            }
            all.andNot(done);
            if (all.isEmpty()) continue;
            IntArrayList byCenter = new IntArrayList();
            byCenter.add(pos);
            all.stream().filter(k -> k != pos).forEach(byCenter::add);
            if (byCenter.size() > 2) {
                HashMap<Integer, Coord> centers = new HashMap<Integer, Coord>();
                intListIterator = byCenter.iterator();
                while (intListIterator.hasNext()) {
                    j = (Integer)intListIterator.next();
                    centers.put(j, Area.getBBox(similarShapes.get(j).points).getCenter());
                }
                Coord mid = Area.getBBox(new ArrayList<Coord>(centers.values())).getCenter();
                byCenter.sort((o1, o2) -> Double.compare(((Coord)centers.get(o1)).distance(mid), ((Coord)centers.get(o2)).distance(mid)));
            }
            List<ShapeHelper> result = Collections.emptyList();
            intListIterator = byCenter.iterator();
            while (intListIterator.hasNext()) {
                j = (Integer)intListIterator.next();
                ShapeHelper sh = similarShapes.get(j);
                int oldSize = result.size();
                if ((result = this.addWithConnectedHoles(result, sh, pattern.getType())).size() >= oldSize + 1) continue;
                merged = true;
                if (!log.isDebugEnabled()) continue;
                log.debug("shape with id", sh.id, "was merged", oldSize + 1 - result.size(), " time(s) at resolution", this.resolution);
            }
            done.or(all);
            next.addAll(result);
        }
        delayed.andNot(done);
        if (!delayed.isEmpty()) {
            delayed.stream().forEach(i -> noMerge.add((ShapeHelper)similarShapes.get(i)));
        }
        delayed.clear();
        similarShapes.clear();
        similarShapes.addAll(noMerge);
        candidates.clear();
        if (merged) {
            this.tryMerge(pattern, next);
        }
        similarShapes.addAll(next);
    }

    private List<BitSet> createMatrix(List<ShapeHelper> similarShapes) {
        int i;
        similarShapes.forEach(sh -> sh.getPoints().forEach(Coord::resetHighwayCount));
        similarShapes.forEach(sh -> sh.getPoints().forEach(Coord::incHighwayCount));
        similarShapes.forEach(sh -> sh.getPoints().get(0).decHighwayCount());
        IdentityHashMap<Coord, BitSet> coord2Shape = new IdentityHashMap<Coord, BitSet>();
        ArrayList<BitSet> candidates = new ArrayList<BitSet>(similarShapes.size());
        for (i = 0; i < similarShapes.size(); ++i) {
            candidates.add(new BitSet());
        }
        for (i = 0; i < similarShapes.size(); ++i) {
            ShapeHelper sh0 = similarShapes.get(i);
            List sharedPoints = sh0.getPoints().stream().filter(p -> p.getHighwayCount() > 1).collect(Collectors.toList());
            if (sh0.getPoints().get(0).getHighwayCount() > 1) {
                sharedPoints.remove(0);
            }
            if (sharedPoints.isEmpty() || sh0.getPoints().size() - sharedPoints.size() > this.maxPoints) continue;
            BitSet curr = (BitSet)candidates.get(i);
            curr.set(i);
            for (Coord c : sharedPoints) {
                BitSet set = (BitSet)coord2Shape.get(c);
                if (set == null) {
                    set = new BitSet();
                    coord2Shape.put(c, set);
                } else {
                    int row = i;
                    set.stream().forEach(j -> ((BitSet)candidates.get(j)).set(row));
                    curr.or(set);
                }
                set.set(i);
            }
        }
        return candidates;
    }

    private List<ShapeHelper> addWithConnectedHoles(List<ShapeHelper> list, ShapeHelper toAdd, int type) {
        assert (toAdd.getPoints().size() > 3);
        ArrayList<ShapeHelper> result = new ArrayList<ShapeHelper>(list.size() + 1);
        ShapeHelper shNew = new ShapeHelper(toAdd);
        for (ShapeHelper shOld : list) {
            ShapeHelper mergeRes = this.tryMerge(shOld, shNew);
            if (mergeRes == shOld) {
                result.add(shOld);
                continue;
            }
            shNew = mergeRes;
            if (shNew != DUP_SHAPE) continue;
            log.warn("ignoring duplicate shape with id", toAdd.id, "at", toAdd.getPoints().get(0).toOSMURL(), "with type", GType.formatType(type), "for resolution", this.resolution);
            return list;
        }
        if (shNew != DUP_SHAPE) {
            result.add(shNew);
        }
        if (result.size() > list.size() + 1) {
            log.error("result list size is wrong", list.size(), "->", result.size());
        }
        return result;
    }

    private ShapeHelper tryMerge(ShapeHelper sh1, ShapeHelper sh2) {
        List<Coord> points2;
        List<Coord> points1;
        boolean sameDir;
        boolean bl = sameDir = sh1.areaTestVal > 0L && sh2.areaTestVal > 0L || sh1.areaTestVal < 0L && sh2.areaTestVal < 0L;
        if (sh2.getPoints().size() > sh1.getPoints().size()) {
            points1 = sh2.getPoints();
            points2 = sh1.getPoints();
        } else {
            points1 = sh1.getPoints();
            points2 = sh2.getPoints();
        }
        IntArrayList sh1PositionsToCheck = new IntArrayList();
        IntArrayList sh2PositionsToCheck = new IntArrayList();
        ShapeMergeFilter.findCommonCoords(points1, points2, sh1PositionsToCheck, sh2PositionsToCheck);
        if (sh1PositionsToCheck.isEmpty()) {
            return sh1;
        }
        if (sh2PositionsToCheck.size() + 1 >= points2.size() && points1.size() == points2.size() && Math.abs(sh1.areaTestVal) == Math.abs(sh2.areaTestVal)) {
            return DUP_SHAPE;
        }
        List<Coord> merged = null;
        if (points1.size() + points2.size() - 2 * sh1PositionsToCheck.size() < this.maxPoints) {
            merged = ShapeMergeFilter.findBestMerge(points1, points2, sh1PositionsToCheck, sh2PositionsToCheck, sameDir);
            if (merged == null) {
                return sh1;
            }
            if (merged.isEmpty()) {
                return DUP_SHAPE;
            }
            if (merged.get(0) != merged.get(merged.size() - 1)) {
                merged = null;
            } else if (merged.size() > this.maxPoints) {
                log.info((Object)("merge rejected: merged shape has too many points " + merged.size()));
                merged = null;
            }
        }
        if (merged == null) {
            return sh1;
        }
        ShapeHelper shm = new ShapeHelper(merged);
        if (Math.abs(shm.areaTestVal) != Math.abs(sh1.areaTestVal) + Math.abs(sh2.areaTestVal)) {
            log.warn("merging shapes skipped for shapes near", points1.get(sh1PositionsToCheck.getInt(0)).toOSMURL(), "(maybe overlapping shapes?)");
            return sh1;
        }
        if (log.isInfoEnabled()) {
            log.info("merge of shapes near", points1.get(sh1PositionsToCheck.getInt(0)).toOSMURL(), "reduces number of points from", points1.size() + points2.size(), "to", merged.size());
        }
        return shm;
    }

    private static void findCommonCoords(List<Coord> s1, List<Coord> s2, IntArrayList s1PositionsToCheck, IntArrayList s2PositionsToCheck) {
        int start;
        Coord co;
        IdentityHashMap<Coord, Integer> s2PosMap = new IdentityHashMap<Coord, Integer>(s2.size() - 1);
        int i = 0;
        while (i + 1 < s1.size()) {
            co = s1.get(i);
            co.setPartOfShape2(false);
            ++i;
        }
        i = 0;
        while (i + 1 < s2.size()) {
            co = s2.get(i);
            co.setPartOfShape2(true);
            s2PosMap.put(co, i);
            ++i;
        }
        for (start = 0; start < s1.size() && (co = s1.get(start)).isPartOfShape2(); ++start) {
        }
        int pos = start + 1;
        int tested = 0;
        while (true) {
            if (pos + 1 >= s1.size()) {
                pos = 0;
            }
            Coord co2 = s1.get(pos);
            if (++tested >= s1.size()) break;
            if (co2.isPartOfShape2()) {
                s1PositionsToCheck.add(pos);
                Integer posInSh2 = (Integer)s2PosMap.get(co2);
                assert (posInSh2 != null);
                s2PositionsToCheck.add((int)posInSh2);
            }
            ++pos;
        }
    }

    private static List<Coord> findBestMerge(List<Coord> points1, List<Coord> points2, IntArrayList sh1PositionsToCheck, IntArrayList sh2PositionsToCheck, boolean sameDir) {
        if (sh1PositionsToCheck.isEmpty()) {
            throw new IllegalArgumentException("nothing to merge");
        }
        int s1Size = points1.size();
        int s2Size = points2.size();
        int longestSequence = 0;
        int length = 0;
        int start = -1;
        int n1 = sh1PositionsToCheck.size();
        ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> possibleCombinations = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
        assert (sh2PositionsToCheck.size() == n1);
        boolean inSequence = false;
        int i = 0;
        while (i + 1 < n1) {
            int pred1 = sh1PositionsToCheck.getInt(i);
            int n = sh1PositionsToCheck.getInt(i + 1);
            if (Math.abs(n - pred1) == 1 || pred1 + 2 == s1Size && n == 0 || n + 2 == s1Size && pred1 == 0) {
                int pred2 = sh2PositionsToCheck.getInt(i);
                int succ2 = sh2PositionsToCheck.getInt(i + 1);
                if (Math.abs(succ2 - pred2) == 1 || pred2 + 2 == s2Size && succ2 == 0 || succ2 + 2 == s2Size && pred2 == 0) {
                    if (start < 0) {
                        start = i;
                    }
                    inSequence = true;
                    ++length;
                } else {
                    inSequence = false;
                }
            } else {
                inSequence = false;
            }
            if (!inSequence) {
                if (length > longestSequence) {
                    longestSequence = length;
                }
                possibleCombinations.add(new AbstractMap.SimpleEntry<Integer, Integer>(start < 0 ? i : start, length));
                length = 0;
                start = -1;
            }
            ++i;
        }
        if (length > longestSequence) {
            longestSequence = length;
        }
        possibleCombinations.add(new AbstractMap.SimpleEntry<Integer, Integer>(start < 0 ? n1 - 1 : start, length));
        ArrayList<List<Coord>> results = new ArrayList<List<Coord>>();
        for (Map.Entry entry : possibleCombinations) {
            int pos;
            List<Coord> merged;
            int len = (Integer)entry.getValue();
            if (len < longestSequence || (merged = ShapeMergeFilter.combine(points1, points2, sh1PositionsToCheck.getInt((pos = ((Integer)entry.getKey()).intValue()) + len), sh2PositionsToCheck.getInt(pos), sameDir, len)).size() < 4 || merged.get(0) != merged.get(merged.size() - 1)) continue;
            results.add(merged);
        }
        return ShapeMergeFilter.filterBest(results);
    }

    private static List<Coord> filterBest(List<List<Coord>> allMerged) {
        List<Coord> best = null;
        double bestLen = Double.MAX_VALUE;
        for (List<Coord> merged : allMerged) {
            double len;
            if (best == null) {
                best = merged;
                continue;
            }
            if (bestLen == Double.MAX_VALUE) {
                bestLen = ShapeMergeFilter.getSumLengthSquared(best);
            }
            if (!((len = ShapeMergeFilter.getSumLengthSquared(merged)) < bestLen)) continue;
            best = merged;
            bestLen = len;
        }
        return best;
    }

    private static List<Coord> combine(List<Coord> points1, List<Coord> points2, int s1PosInit, int s2PosInit, boolean sameDir, int lengthOfSequence) {
        int s2Size;
        int s1Size = points1.size();
        int remaining = s1Size + (s2Size = points2.size()) - 2 * lengthOfSequence - 1;
        if (remaining < 3) {
            return Collections.emptyList();
        }
        List<Coord> merged = new ArrayList<Coord>(remaining);
        int s1Pos = s1PosInit;
        for (int i = 0; i < s1Size - lengthOfSequence - 1; ++i) {
            merged.add(points1.get(s1Pos));
            if (++s1Pos + 1 < s1Size) continue;
            s1Pos = 0;
        }
        int s2Pos = s2PosInit;
        int s2Step = sameDir ? 1 : -1;
        for (int i = 0; i < s2Size - lengthOfSequence; ++i) {
            merged.add(points2.get(s2Pos));
            if ((s2Pos += s2Step) < 0) {
                s2Pos = s2Size - 2;
                continue;
            }
            if (s2Pos + 1 < s2Size) continue;
            s2Pos = 0;
        }
        if (merged.get(0) == merged.get(merged.size() - 1)) {
            merged = WrongAngleFixer.removeSpikeInShape(merged);
        }
        return merged;
    }

    public static double getSumLengthSquared(List<Coord> points) {
        double length = 0.0;
        Iterator<Coord> iter = points.iterator();
        Coord p0 = null;
        while (iter.hasNext()) {
            Coord p1 = iter.next();
            if (p0 != null) {
                length += (double)p0.distanceInHighPrecSquared(p1);
            }
            p0 = p1;
        }
        return length;
    }

    public static long calcAreaSizeTestVal(List<Coord> points) {
        if (points.size() < 4) {
            return 0L;
        }
        if (!points.get(0).highPrecEquals(points.get(points.size() - 1))) {
            log.error((Object)"shape is not closed");
            return 0L;
        }
        Iterator<Coord> polyIter = points.iterator();
        Coord c2 = polyIter.next();
        long signedAreaSize = 0L;
        while (polyIter.hasNext()) {
            Coord c1 = c2;
            c2 = polyIter.next();
            signedAreaSize += (long)(c2.getHighPrecLon() + c1.getHighPrecLon()) * (long)(c1.getHighPrecLat() - c2.getHighPrecLat());
        }
        if (Math.abs(signedAreaSize) < 4096L && log.isDebugEnabled()) {
            log.debug("very small shape near", points.get(0).toOSMURL(), "signed area in high prec map units:", signedAreaSize);
        }
        return signedAreaSize;
    }

    public static class MapShapeComparator
    implements Comparator<MapShape> {
        private boolean orderByDecreasingArea;

        public MapShapeComparator(boolean orderByDecreasingArea) {
            this.orderByDecreasingArea = orderByDecreasingArea;
        }

        @Override
        public int compare(MapShape o1, MapShape o2) {
            int d = Integer.compare(o1.getType(), o2.getType());
            if (d != 0) {
                return d;
            }
            d = Boolean.compare(o1.isSkipSizeFilter(), o2.isSkipSizeFilter());
            if (d != 0) {
                return d;
            }
            if (this.orderByDecreasingArea && (d = Long.compare(o1.getFullArea(), o2.getFullArea())) != 0) {
                return d;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            if (n1 == null) {
                return n2 == null ? 0 : 1;
            }
            if (n2 == null) {
                return -1;
            }
            return n1.compareTo(n2);
        }
    }

    private static class ShapeHelper {
        private final List<Coord> points;
        long id;
        long areaTestVal;

        public ShapeHelper(List<Coord> merged) {
            this.points = merged;
            this.areaTestVal = ShapeMergeFilter.calcAreaSizeTestVal(this.points);
        }

        public ShapeHelper(ShapeHelper other) {
            this.points = other.points;
            this.areaTestVal = other.areaTestVal;
            this.id = other.id;
        }

        public List<Coord> getPoints() {
            return this.points;
        }
    }
}

