/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.util.MultiHashMap;

public class LineMergeFilter {
    private static final Logger log = Logger.getLogger(LineMergeFilter.class);
    private List<MapLine> linesMerged;
    private final MultiHashMap<Coord, MapLine> sharedPoints = new MultiHashMap();

    private void addLine(MapLine line) {
        this.linesMerged.add(line);
        List<Coord> points = line.getPoints();
        Coord start = points.get(0);
        Coord end = points.get(points.size() - 1);
        this.sharedPoints.add(start, line);
        this.sharedPoints.add(end, line);
    }

    private void addPointsAtStart(MapLine line, List<Coord> additionalPoints) {
        log.info((Object)("merged lines before " + line.getName()));
        List<Coord> points = line.getPoints();
        this.sharedPoints.removeMapping(points.get(0), line);
        line.insertPointsAtStart(additionalPoints);
        this.sharedPoints.add(points.get(0), line);
    }

    private void addPointsAtEnd(MapLine line, List<Coord> additionalPoints) {
        log.info((Object)("merged lines after " + line.getName()));
        List<Coord> points = line.getPoints();
        this.sharedPoints.removeMapping(points.get(points.size() - 1), line);
        line.insertPointsAtEnd(additionalPoints);
        this.sharedPoints.add(points.get(points.size() - 1), line);
    }

    public List<MapLine> merge(List<MapLine> lines, int res, boolean mergeRoads, boolean reverseAllowed) {
        this.linesMerged = new ArrayList<MapLine>();
        for (MapLine line : lines) {
            if (line.getMinResolution() > res || line.getMaxResolution() < res) continue;
            if (line.isRoad() && !mergeRoads) {
                this.linesMerged.add(line);
                continue;
            }
            if (this.tryMerge(line, reverseAllowed)) continue;
            MapLine l = line.copy();
            l.setPoints(new ArrayList<Coord>(line.getPoints()));
            this.addLine(l);
        }
        return this.linesMerged;
    }

    private boolean tryMerge(MapLine line, boolean reverseAllowed) {
        Coord start = line.getPoints().get(0);
        Coord end = line.getPoints().get(line.getPoints().size() - 1);
        LinkedHashSet candidates = new LinkedHashSet(this.sharedPoints.get(start));
        candidates.addAll(this.sharedPoints.get(end));
        Coord mergePoint = null;
        MapLine mergedLine = null;
        for (MapLine line2 : candidates) {
            mergePoint = this.tryCandidate(line, line2, reverseAllowed);
            if (mergePoint == null) continue;
            mergedLine = line2;
            break;
        }
        if (mergePoint == null) {
            return false;
        }
        Coord otherEnd = mergePoint.equals(end) ? start : end;
        candidates.clear();
        candidates.addAll(this.sharedPoints.get(otherEnd));
        for (MapLine line2 : candidates) {
            mergePoint = this.tryCandidate(line2, mergedLine, reverseAllowed);
            if (mergePoint == null) continue;
            this.sharedPoints.removeMapping(line2.getPoints().get(0), line2);
            this.sharedPoints.removeMapping(line2.getPoints().get(line2.getPoints().size() - 1), line2);
            this.linesMerged.remove(line2);
            break;
        }
        return true;
    }

    private Coord tryCandidate(MapLine line1, MapLine line2, boolean reverseAllowed) {
        if (line1 == line2 || !LineMergeFilter.isSimilar(line1, line2)) {
            return null;
        }
        List<Coord> points1 = line1.getPoints();
        Coord start1 = points1.get(0);
        Coord end1 = points1.get(points1.size() - 1);
        List<Coord> points2 = line2.getPoints();
        Coord start2 = points2.get(0);
        Coord end2 = points2.get(points2.size() - 1);
        if (end2.equals(start1)) {
            this.addPointsAtEnd(line2, line1.getPoints());
            return start1;
        }
        if (start2.equals(end1)) {
            this.addPointsAtStart(line2, line1.getPoints());
            return end1;
        }
        if (reverseAllowed && end2.equals(end1) && !line1.isDirection()) {
            ArrayList<Coord> reversed = new ArrayList<Coord>(line1.getPoints());
            Collections.reverse(reversed);
            this.addPointsAtEnd(line2, reversed);
            return end1;
        }
        if (reverseAllowed && start2.equals(start1) && !line1.isDirection()) {
            ArrayList<Coord> reversed = new ArrayList<Coord>(line1.getPoints());
            Collections.reverse(reversed);
            this.addPointsAtStart(line2, reversed);
            return start1;
        }
        return null;
    }

    private static boolean isSimilar(MapLine l1, MapLine l2) {
        return l1.getType() == l2.getType() && l1.isDirection() == l2.isDirection() && Objects.equals(l1.getName(), l2.getName());
    }
}

