/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.fs.DirectoryEntry;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.ImgFS;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;
import uk.me.parabola.mkgmap.combiners.FileKind;

public class GmapiBuilder
implements Combiner {
    private static final Logger log = Logger.getLogger(GmapiBuilder.class);
    private static final String NS = "http://www.garmin.com/xmlschemas/MapProduct/v1";
    private final Map<String, Combiner> combinerMap;
    private final Map<String, String> sourceMap;
    private Path gmapDir;
    private final Map<Integer, ProductInfo> productMap = new HashMap<Integer, ProductInfo>();
    private String familyName;
    private int familyId;
    private short productVersion;
    private String typFile;
    private boolean forceWrite;
    private String mustWritePattern;

    public GmapiBuilder(Map<String, Combiner> combinerMap, Map<String, String> sourceMap) {
        this.combinerMap = combinerMap;
        this.sourceMap = sourceMap;
    }

    @Override
    public void init(CommandArgs args) {
        this.familyName = args.get("family-name", "OSM map");
        this.familyId = args.get("family-id", 6324);
        this.productVersion = (short)args.get("product-version", 100);
        this.gmapDir = Paths.get(args.getOutputDir(), String.format("%s.gmap", this.familyName));
        this.forceWrite = args.exists("gmapi");
        this.mustWritePattern = args.get("gmapi-minimal", null);
    }

    @Override
    public void onMapEnd(FileInfo info) {
        String fn = info.getFilename();
        String mapname = info.getMapname();
        int productId = info.getProductId();
        if (!this.productMap.containsKey(productId)) {
            this.productMap.put(productId, new ProductInfo(productId, info.getSeriesName(), info.getOverviewName()));
        }
        try {
            if (info.isImg()) {
                if (this.forceWrite || this.shouldWrite(info)) {
                    this.unzipImg(fn, mapname, productId);
                }
            } else if (info.getKind() == FileKind.TYP_KIND) {
                this.typFile = info.getFilename();
            }
        }
        catch (IOException e) {
            throw new ExitException("Error saving gmapi data", e);
        }
    }

    private boolean shouldWrite(FileInfo info) {
        String fn = info.getFilename();
        String source = this.sourceMap.get(fn);
        if (!source.equals(fn)) {
            log.diagnostic("gmapi-minimal: Writing freshly compiled file " + fn);
            return true;
        }
        if (this.mustWritePattern != null && fn.matches(this.mustWritePattern)) {
            log.diagnostic("gmapi-minimal: Writing old file " + fn + " because it matches pattern " + this.mustWritePattern);
            return true;
        }
        log.diagnostic("gmapi-minimal: Skipping file " + fn);
        return false;
    }

    @Override
    public void onFinish() {
        try {
            Object file;
            if (this.combinerMap.containsKey("mdx")) {
                file = new File(this.getFilenameFor("mdx"));
                Files.copy(((File)file).toPath(), this.gmapDir.resolve(((File)file).getName()), StandardCopyOption.REPLACE_EXISTING);
            }
            if (this.combinerMap.containsKey("mdr")) {
                file = new File(this.getFilenameFor("mdr"));
                this.unzipImg(((File)file).getCanonicalPath(), this.gmapDir.resolve(GmapiBuilder.nameWithoutExtension((File)file)));
            }
            if (this.typFile != null) {
                file = new File(this.typFile);
                Files.copy(((File)file).toPath(), this.gmapDir.resolve(((File)file).getName()), StandardCopyOption.REPLACE_EXISTING);
            }
            for (ProductInfo info : this.productMap.values()) {
                this.finishTdbFile(info);
                this.unzipImg(this.getFilenameFor("img"), info.overviewName, info.id);
            }
            this.writeXmlFile(this.gmapDir);
        }
        catch (IOException e) {
            throw new ExitException("Error building gmapi data", e);
        }
    }

    private static String nameWithoutExtension(File file) {
        String name = file.getName();
        int len = name.length();
        if (len < 4) {
            return name;
        }
        return name.substring(0, len - 4);
    }

    private void finishTdbFile(ProductInfo info) throws IOException {
        Path tdbPath = Paths.get(this.getFilenameFor("tdb"), new String[0]);
        Files.copy(tdbPath, this.gmapDir.resolve(String.format("Product%d", info.id)).resolve(String.format("%s.tdb", info.overviewName)), StandardCopyOption.REPLACE_EXISTING);
    }

    private void unzipImg(String srcImgName, String mapname, int productId) throws IOException {
        Path destDir = Paths.get(this.gmapDir.toString(), "Product" + productId, mapname);
        this.unzipImg(srcImgName, destDir);
    }

    private void unzipImg(String srcImgName, Path destDir) throws IOException {
        FileSystem fs = ImgFS.openFs(srcImgName);
        for (DirectoryEntry ent : fs.list()) {
            String fullname = ent.getFullName();
            ImgChannel f = fs.open(fullname, "r");
            Throwable throwable = null;
            try {
                String name = GmapiBuilder.displayName(fullname);
                if (Objects.equals(name, ".")) continue;
                Files.createDirectories(destDir, new FileAttribute[0]);
                Path out = destDir.resolve(name);
                GmapiBuilder.copyToFile(f, out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (f == null) continue;
                if (throwable != null) {
                    try {
                        f.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                f.close();
            }
        }
    }

    private static void copyToFile(ImgChannel f, Path dest) {
        ByteBuffer buf = ByteBuffer.allocate(8192);
        try (SeekableByteChannel outchan = Files.newByteChannel(dest, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            while (f.read(buf) > 0) {
                buf.flip();
                outchan.write(buf);
                buf.compact();
            }
        }
        catch (IOException e) {
            throw new ExitException("Cannot write file " + e);
        }
    }

    private String getFilenameFor(String kind) {
        return this.combinerMap.get(kind).getFilename();
    }

    private static String displayName(String fullname) {
        return fullname.trim().replace("\u0000", "");
    }

    private void writeXmlFile(Path gDir) {
        Path infoFile = gDir.resolve("Info.xml");
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        try (BufferedWriter stream = Files.newBufferedWriter(infoFile, new OpenOption[0]);){
            File file;
            XMLStreamWriter writer = factory.createXMLStreamWriter(stream);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.setDefaultNamespace(NS);
            writer.writeCharacters("\n");
            writer.writeStartElement(NS, "MapProduct");
            writer.writeDefaultNamespace(NS);
            writer.writeCharacters("\n");
            GmapiBuilder.xmlElement(writer, "Name", this.familyName);
            GmapiBuilder.xmlElement(writer, "DataVersion", String.valueOf(this.productVersion));
            GmapiBuilder.xmlElement(writer, "DataFormat", "Original");
            GmapiBuilder.xmlElement(writer, "ID", String.valueOf(this.familyId));
            if (this.combinerMap.containsKey("mdx")) {
                String mdxFile = this.getFilenameFor("mdx");
                file = new File(mdxFile);
                GmapiBuilder.xmlElement(writer, "IDX", file.getName());
            }
            if (this.combinerMap.containsKey("mdr")) {
                String mdrName = this.getFilenameFor("mdr");
                file = new File(mdrName);
                GmapiBuilder.xmlElement(writer, "MDR", GmapiBuilder.nameWithoutExtension(file));
            }
            if (this.typFile != null) {
                File file2 = new File(this.typFile);
                GmapiBuilder.xmlElement(writer, "TYP", file2.getName());
            }
            for (ProductInfo prod : this.productMap.values()) {
                writer.writeStartElement(NS, "SubProduct");
                writer.writeCharacters("\n");
                GmapiBuilder.xmlElement(writer, "Name", prod.seriesName);
                GmapiBuilder.xmlElement(writer, "ID", String.valueOf(prod.id));
                GmapiBuilder.xmlElement(writer, "BaseMap", prod.overviewName);
                GmapiBuilder.xmlElement(writer, "TDB", String.format("%s.tdb", prod.overviewName));
                GmapiBuilder.xmlElement(writer, "Directory", String.format("Product%s", prod.id));
                writer.writeEndElement();
                writer.writeCharacters("\n");
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (IOException | XMLStreamException e) {
            throw new ExitException("Could not create file " + infoFile + "; " + e);
        }
    }

    private static void xmlElement(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
        writer.writeCharacters(" ");
        writer.writeStartElement(NS, name);
        writer.writeCharacters(value);
        writer.writeEndElement();
        writer.writeCharacters("\n");
    }

    private static class ProductInfo {
        private final String seriesName;
        private final String overviewName;
        private final int id;

        public ProductInfo(int id, String seriesName, String overviewName) {
            this.id = id;
            this.seriesName = seriesName;
            this.overviewName = overviewName;
        }
    }
}

