/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.build;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.MapArea;
import uk.me.parabola.mkgmap.general.MapDataSource;

public class MapSplitter {
    private static final Logger log = Logger.getLogger(MapSplitter.class);
    private final MapDataSource mapSource;
    public static final int MAX_DIVISION_SIZE = Short.MAX_VALUE;
    public static final int MAX_RGN_OFFSET_SIZE = 65528;
    public static final int MAX_NUM_LINES = 255;
    public static final int MAX_NUM_POINTS = 255;
    public static final int MAX_XT_POINTS_SIZE = 65280;
    public static final int MAX_XT_LINES_SIZE = 65280;
    public static final int MAX_XT_SHAPES_SIZE = 65280;
    public static final int MIN_DIMENSION = 10;
    public static final int WANTED_MAX_AREA_SIZE = 16383;
    private final Zoom zoom;

    MapSplitter(MapDataSource mapSource, Zoom zoom) {
        this.mapSource = mapSource;
        this.zoom = zoom;
    }

    public MapArea[] split(boolean orderByDecreasingArea) {
        log.debug("orig area", this.mapSource.getBounds());
        MapArea ma = this.initialArea(this.mapSource, orderByDecreasingArea);
        MapArea[] origArea = new MapArea[]{ma};
        MapArea[] areas = this.splitMaxSize(ma);
        if (areas == null) {
            log.warn("initial split returned null for", ma);
            return origArea;
        }
        ArrayList<MapArea> alist = new ArrayList<MapArea>();
        this.addAreasToList(areas, alist, 0);
        if (alist.isEmpty()) {
            return origArea;
        }
        MapArea[] results = new MapArea[alist.size()];
        return alist.toArray(results);
    }

    /*
     * Unable to fully structure code
     */
    private void addAreasToList(MapArea[] areas, List<MapArea> alist, int depth) {
        shift = this.zoom.getShiftValue();
        for (MapArea area : areas) {
            block11: {
                block12: {
                    if (!area.hasData()) continue;
                    bounds = area.getBounds();
                    sizes = area.getEstimatedSizes();
                    if (MapSplitter.log.isInfoEnabled()) {
                        padding = depth + "                                                                      ";
                        MapSplitter.log.info((Object)(padding.substring(0, (depth + 1) * 2) + bounds.getWidth() + "x" + bounds.getHeight() + ", points = " + area.getNumPoints() + "/" + sizes[0] + "/" + sizes[3] + ", lines = " + area.getNumLines() + "/" + sizes[1] + "/" + sizes[4] + ", shapes = " + area.getNumShapes() + "/" + sizes[2] + "/" + sizes[5]));
                    }
                    wantSplit = false;
                    mustSplit = false;
                    if (area.getNumLines() > 255 || area.getNumPoints() > 255 || sizes[0] + sizes[1] > 65528 || sizes[3] > 65280 || sizes[4] > 65280 || sizes[5] > 65280) {
                        mustSplit = true;
                    } else if (bounds.getMaxDimension() > 10 << shift) {
                        sumSize = 0;
                        for (int s : sizes) {
                            sumSize += s;
                        }
                        if (sumSize > 16383) {
                            MapSplitter.log.debug(new Object[]{"splitting area because estimated data size is larger than wanted:", sumSize});
                            wantSplit = true;
                        }
                    }
                    if (!wantSplit && !mustSplit) break block11;
                    if (area.canSplit()) break block12;
                    if (!mustSplit) {
                        MapSplitter.log.info(new Object[]{"Single item larger that WANTED_MAX_AREA_SIZE", area.getBounds().getCenter().toOSMURL()});
                    }
                    break block11;
                }
                if (bounds.getMaxDimension() <= 10 << shift) ** GOTO lbl36
                MapSplitter.log.debug(new Object[]{"splitting area in half", area, mustSplit, wantSplit});
                sublist = bounds.getWidth() > bounds.getHeight() ? area.split(2, 1, bounds, false) : area.split(1, 2, bounds, false);
                if (sublist == null) {
                    MapSplitter.log.error(new Object[]{"SubDivision split failed at", area.getBounds().getCenter().toOSMURL()});
                } else {
                    this.addAreasToList(sublist, alist, depth + 1);
                    continue;
lbl36:
                    // 1 sources

                    if (mustSplit) {
                        MapSplitter.log.debug(new Object[]{"splitting area by contents", area});
                        sublist = area.split(1, 1, bounds, true);
                        this.addAreasToList(sublist, alist, depth + 1);
                        continue;
                    }
                }
            }
            MapSplitter.log.debug(new Object[]{"adding area unsplit: has points", area.hasPoints()});
            alist.add(area);
        }
    }

    private MapArea[] splitMaxSize(MapArea mapArea) {
        int shift = this.zoom.getShiftValue();
        Area bounds = mapArea.getBounds();
        if (bounds.isEmpty() || !mapArea.getFullBounds().isEmpty() && mapArea.getFullBounds().getMaxDimension() >> shift > Short.MAX_VALUE) {
            bounds = mapArea.getFullBounds();
        }
        if (bounds.isEmpty()) {
            return null;
        }
        int width = bounds.getWidth() >> shift;
        int height = bounds.getHeight() >> shift;
        int xsplit = 1;
        if (width > Short.MAX_VALUE) {
            xsplit = width / Short.MAX_VALUE + 1;
        }
        int ysplit = 1;
        if (height > Short.MAX_VALUE) {
            ysplit = height / Short.MAX_VALUE + 1;
        }
        log.debug("splitMaxSize: bounds", bounds, "shift", shift, "width", width, "height", height, "xsplit", xsplit, "ysplit", ysplit);
        return mapArea.split(xsplit, ysplit, bounds, false);
    }

    private MapArea initialArea(MapDataSource src, boolean splitPolygonsIntoArea) {
        return new MapArea(src, this.zoom.getResolution(), splitPolygonsIntoArea);
    }
}

