/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.sys;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.fs.DirectoryEntry;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.BlockManager;
import uk.me.parabola.imgfmt.sys.Dirent;
import uk.me.parabola.imgfmt.sys.HeaderDirent;
import uk.me.parabola.log.Logger;

class Directory {
    private static final Logger log = Logger.getLogger(Directory.class);
    private ImgChannel chan;
    private final BlockManager headerBlockManager;
    private long startPos;
    private final Map<String, DirectoryEntry> entries = new LinkedHashMap<String, DirectoryEntry>();

    Directory(BlockManager headerBlockManager) {
        this.headerBlockManager = headerBlockManager;
    }

    Dirent create(String name, BlockManager blockManager) throws FileExistsException {
        if (this.entries.get(name) != null) {
            throw new FileExistsException("File " + name + " already exists");
        }
        Dirent ent = Objects.equals(name, "        .   ") ? new HeaderDirent(name, blockManager) : new Dirent(name, blockManager);
        this.addEntry(ent);
        return ent;
    }

    void readInit(byte xorByte) throws IOException {
        assert (this.chan != null);
        ByteBuffer buf = ByteBuffer.allocate(512);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.chan.position(this.startPos);
        Dirent current = null;
        while (this.chan.read(buf) > 0) {
            byte used;
            buf.flip();
            if (xorByte != 0) {
                byte[] bufBytes = buf.array();
                int i = 0;
                while (i < bufBytes.length) {
                    int n = i++;
                    bufBytes[n] = (byte)(bufBytes[n] ^ xorByte);
                }
            }
            if ((used = buf.get(0)) != 1) continue;
            String name = Utils.bytesToString(buf, 1, 8);
            String ext = Utils.bytesToString(buf, 9, 3);
            log.debug("readinit name", name, ext);
            byte flag = buf.get(16);
            int part = buf.get(17) & 0xFF;
            if (flag == 3 && current == null) {
                current = (Dirent)this.entries.get("        .   ");
                current.initBlocks(buf);
            } else if (part == 0) {
                current = this.create(name + '.' + ext, this.headerBlockManager);
                current.initBlocks(buf);
            } else {
                assert (current != null);
                current.initBlocks(buf);
            }
            buf.clear();
        }
    }

    public void sync() throws IOException {
        long dirPosition = this.chan.position();
        this.chan.position(dirPosition + 512L);
        for (DirectoryEntry dir : this.entries.values()) {
            Dirent ent = (Dirent)dir;
            if (ent.isSpecial()) continue;
            log.debug("writing", dir.getFullName(), "at", this.chan.position());
            log.debug("ent size", ent.getSize());
            ent.sync(this.chan);
        }
        this.chan.position(dirPosition);
        Dirent ent = (Dirent)this.entries.values().iterator().next();
        log.debug("ent header size", ent.getSize());
        ent.sync(this.chan);
    }

    public List<DirectoryEntry> getEntries() {
        return new ArrayList<DirectoryEntry>(this.entries.values());
    }

    private void addEntry(DirectoryEntry ent) {
        this.entries.put(ent.getFullName(), ent);
    }

    public void setFile(ImgChannel chan) {
        this.chan = chan;
    }

    public void setStartPos(long startPos) {
        this.startPos = startPos;
    }

    public DirectoryEntry lookup(String name) {
        return this.entries.get(name);
    }
}

