/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.mps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.mps.MapBlock;
import uk.me.parabola.imgfmt.mps.MapsetBlock;
import uk.me.parabola.imgfmt.mps.ProductBlock;
import uk.me.parabola.imgfmt.sys.FileNode;

public class MpsFile {
    private String mapsetName = "OSM map set";
    private final Set<ProductBlock> products = new HashSet<ProductBlock>();
    private final List<MapBlock> maps = new ArrayList<MapBlock>();
    private final ImgFileWriter writer;

    public MpsFile(ImgChannel chan) {
        assert (chan instanceof FileNode);
        this.writer = new BufferedImgFileWriter(chan, "MPS");
    }

    public void sync() throws IOException {
        for (MapBlock map : this.maps) {
            map.writeTo(this.writer, map.getCodePage());
        }
        for (ProductBlock block : this.products) {
            block.writeTo(this.writer, block.getCodePage());
        }
        MapsetBlock mapset = new MapsetBlock();
        mapset.setName(this.mapsetName);
        mapset.writeTo(this.writer, mapset.getCodePage());
    }

    public void addMap(MapBlock map) {
        this.maps.add(map);
    }

    public void addProduct(ProductBlock pb) {
        this.products.add(pb);
    }

    public void setMapsetName(String mapsetName) {
        this.mapsetName = mapsetName;
    }
}

