/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.typ.ColourInfo;
import uk.me.parabola.imgfmt.app.typ.Rgb;
import uk.me.parabola.imgfmt.app.typ.TypLabel;
import uk.me.parabola.imgfmt.app.typ.Xpm;
import uk.me.parabola.log.Logger;

public abstract class TypElement
implements Comparable<TypElement> {
    private static final Logger log = Logger.getLogger(TypElement.class);
    private int type;
    private int subType;
    protected final List<TypLabel> labels = new ArrayList<TypLabel>();
    protected Xpm xpm;
    protected int fontStyle;
    protected Rgb dayFontColour;
    protected Rgb nightFontColour;
    protected int offset;

    public void setType(int type) {
        this.type = type;
    }

    public void setSubType(int subType) {
        this.subType = subType;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public int compareTo(TypElement o) {
        int t2;
        int t1 = this.getTypeForFile();
        if (t1 == (t2 = o.getTypeForFile())) {
            return 0;
        }
        if (t1 < t2) {
            return -1;
        }
        return 1;
    }

    public int getTypeForFile() {
        return this.type << 5 | this.subType & 0x1F;
    }

    public void addLabel(String text) {
        this.labels.add(new TypLabel(text));
    }

    public void setXpm(Xpm xpm) {
        this.xpm = xpm;
    }

    public void setFontStyle(int font) {
        this.fontStyle = font;
    }

    public void setDayFontColor(String value) {
        this.dayFontColour = new Rgb(value);
    }

    public void setNightCustomColor(String value) {
        this.nightFontColour = new Rgb(value);
    }

    public abstract void write(ImgFileWriter var1, CharsetEncoder var2);

    public int getOffset() {
        return this.offset;
    }

    public boolean simpleBitmap() {
        return true;
    }

    protected ByteBuffer makeLabelBlock(CharsetEncoder encoder) {
        ByteBuffer out = ByteBuffer.allocate(256 * this.labels.size());
        for (TypLabel tl : this.labels) {
            CharBuffer cb = CharBuffer.wrap(tl.getText());
            try {
                ByteBuffer buffer = encoder.encode(cb);
                out.put((byte)tl.getLang());
                out.put(buffer);
                out.put((byte)0);
            }
            catch (CharacterCodingException ignore) {
                String name = encoder.charset().name();
                log.warn("Cannot represent String", tl.getText(), "for language", tl.getLang(), "in CodePage", name);
            }
        }
        return out;
    }

    protected void writeLabelBlock(ImgFileWriter writer, CharsetEncoder encoder) {
        ByteBuffer out = this.makeLabelBlock(encoder);
        int len = out.position();
        len = (len << 1) + 1;
        int mask = -256;
        while ((len & mask) != 0) {
            mask <<= 8;
            len <<= 1;
        }
        if (len > 255) {
            writer.put2u(len);
        } else {
            writer.put1u(len);
        }
        out.flip();
        writer.put(out);
    }

    protected void writeExtendedFontInfo(ImgFileWriter writer) {
        byte fontExt = (byte)this.fontStyle;
        if (this.dayFontColour != null) {
            fontExt = (byte)(fontExt | 8);
        }
        if (this.nightFontColour != null) {
            fontExt = (byte)(fontExt | 0x10);
        }
        writer.put1u(fontExt);
        if (this.dayFontColour != null) {
            this.dayFontColour.write(writer, (byte)16);
        }
        if (this.nightFontColour != null) {
            this.nightFontColour.write(writer, (byte)16);
        }
    }

    protected void writeImage(ImgFileWriter writer, Xpm xpm) {
        ColourInfo colourInfo = xpm.getColourInfo();
        writer.put1u(colourInfo.getNumberOfSColoursForCM());
        writer.put1u(colourInfo.getColourMode());
        colourInfo.write(writer);
        xpm.writeImage(writer);
    }
}

