/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

public class MapValues {
    private final int mapId;
    private final int length;
    private final byte[][] values = new byte[4][8];
    private static final byte[] mapIdCodeTable = new byte[]{0, 1, 15, 5, 13, 4, 7, 6, 11, 9, 14, 8, 2, 10, 12, 3};
    private final int[] offsetMap = new int[]{6, 7, 5, 11, 3, 10, 13, 12, 1, 15, 4, 14, 8, 0, 2, 9};

    public MapValues(int mapId, int headerLength) {
        this.mapId = mapId;
        this.length = headerLength;
    }

    public int value(int n) {
        byte[] out = this.values[n];
        int res = 0;
        for (int i = 0; i < 8; ++i) {
            res |= (out[i] & 0xF) << 4 * (7 - i);
        }
        return res;
    }

    public void calculate() {
        this.calcThird();
        this.calcFourth();
        this.calcFirst();
        this.calcSecond();
        this.addOffset();
    }

    private void addOffset() {
        int n = this.mapIdDigit(1) + this.mapIdDigit(3) + this.mapIdDigit(5) + this.mapIdDigit(7);
        int offset = this.offsetMap[n & 0xF];
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < 8) {
                byte[] byArray = this.values[i];
                int n2 = j++;
                byArray[n2] = (byte)(byArray[n2] + offset);
            }
        }
    }

    private void calcFirst() {
        byte[] out = this.values[0];
        byte[] v3 = this.values[3];
        out[0] = (byte)(this.mapIdDigit(4) + v3[0]);
        out[1] = (byte)(this.mapIdDigit(5) + v3[1]);
        out[2] = (byte)(this.mapIdDigit(6) + v3[2]);
        out[3] = (byte)(this.mapIdDigit(7) + v3[3]);
        out[4] = v3[4];
        out[5] = v3[5];
        out[6] = v3[6];
        out[7] = (byte)(v3[7] + 1);
    }

    private void calcSecond() {
        byte[] out = this.values[1];
        byte[] v3 = this.values[3];
        out[0] = v3[0];
        out[1] = v3[1];
        int h1 = this.length >> 4;
        int h2 = this.length;
        out[2] = (byte)(v3[2] + h1 & 0xF);
        out[3] = (byte)(v3[3] + h2 & 0xF);
        out[4] = (byte)(v3[4] + this.mapIdDigit(0));
        out[5] = (byte)(v3[5] + this.mapIdDigit(1));
        out[6] = (byte)(v3[6] + this.mapIdDigit(2));
        out[7] = (byte)(v3[7] + this.mapIdDigit(3));
    }

    private void calcThird() {
        byte[] out = this.values[2];
        for (int i = 0; i < 8; ++i) {
            int n = this.mapIdDigit(i);
            out[i ^ 1] = mapIdCodeTable[n];
        }
    }

    private void calcFourth() {
        System.arraycopy(this.values[2], 0, this.values[3], 0, this.values[3].length);
    }

    private int mapIdDigit(int i) {
        return this.mapId >>> 4 * (7 - i) & 0xF;
    }
}

