/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.io.IOException;
import java.io.OutputStream;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.trergn.ExtTypeAttributes;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;

public abstract class MapObject {
    private Subdivision subdiv;
    private Label label;
    private int type;
    private int deltaLong;
    private int deltaLat;
    private ExtTypeAttributes extTypeAttributes;
    private int number;

    public abstract void write(ImgFileWriter var1);

    public abstract void write(OutputStream var1) throws IOException;

    protected int getDeltaLat() {
        return this.deltaLat;
    }

    protected int getDeltaLong() {
        return this.deltaLong;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean hasExtendedType() {
        return MapObject.hasExtendedType(this.type);
    }

    public static boolean hasExtendedType(int type) {
        return type >= 65536;
    }

    public void setLatitude(int lat) {
        Subdivision div = this.getSubdiv();
        int diff = div.roundLatToLocalShifted(lat);
        this.setDeltaLat(diff);
    }

    public void setLongitude(int lon) {
        Subdivision div = this.getSubdiv();
        int diff = div.roundLonToLocalShifted(lon);
        this.setDeltaLong(diff);
    }

    protected void setDeltaLat(int deltaLat) {
        assert (deltaLat >= Short.MIN_VALUE && deltaLat <= Short.MAX_VALUE) : "deltaLat = " + deltaLat;
        this.deltaLat = deltaLat;
    }

    protected void setDeltaLong(int deltaLong) {
        assert (deltaLong >= Short.MIN_VALUE && deltaLong <= Short.MAX_VALUE) : "deltaLong = " + deltaLong;
        this.deltaLong = deltaLong;
    }

    public Subdivision getSubdiv() {
        return this.subdiv;
    }

    protected void setSubdiv(Subdivision subdiv) {
        this.subdiv = subdiv;
    }

    public Label getLabel() {
        return this.label;
    }

    protected byte[] getExtTypeExtraBytes() {
        return this.extTypeAttributes != null ? this.extTypeAttributes.getExtTypeExtraBytes(this) : null;
    }

    public void setExtTypeAttributes(ExtTypeAttributes eta) {
        this.extTypeAttributes = eta;
    }

    public String toString() {
        return "Type=" + this.type + ", l=" + this.label;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }
}

