/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.LBLFile;
import uk.me.parabola.imgfmt.app.trergn.MapObject;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.log.Logger;

public class ExtTypeAttributes {
    private static final Logger log = Logger.getLogger(ExtTypeAttributes.class);
    private final Map<String, String> attributes;
    private final String objectName;
    private byte[] extraBytes;
    private Label note;
    private Label intDesig;
    private Label localDesig;
    private Byte morseLetter;
    private static final int DISTANCE_FLAG_METRIC_INDEX = 0;
    private static final int DISTANCE_FLAG_TENTHS_INDEX = 1;
    private static final byte FLAGS0_RACON_BIT = 1;
    private static final byte FLAGS0_NOTE_BIT = 2;
    private static final byte FLAGS0_LOCAL_DESIG_BIT = 4;
    private static final byte FLAGS0_INT_DESIG_BIT = 8;
    private static final int[] ZERO_INT_ARRAY = new int[0];

    public ExtTypeAttributes(Map<String, String> attributes, String objectName) {
        this.attributes = attributes;
        this.objectName = objectName;
    }

    public void processLabels(LBLFile lbl) {
        String lds;
        String ids;
        String ns;
        if (this.note == null && (ns = this.attributes.get("note")) != null) {
            this.note = lbl.newLabel(ns, false);
        }
        if (this.intDesig == null && (ids = this.attributes.get("int-desig")) != null) {
            this.intDesig = lbl.newLabel(ids, false);
        }
        if (this.localDesig == null && (lds = this.attributes.get("local-desig")) != null) {
            this.localDesig = lbl.newLabel(lds, false);
        }
    }

    protected byte[] getExtTypeExtraBytes(MapObject mapObject) {
        try {
            return this.encodeExtraBytes(mapObject);
        }
        catch (Exception e) {
            log.error((Object)(this.objectName + " (" + e + ")"));
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] encodeExtraBytes(MapObject mapObject) {
        String sequence;
        if (this.extraBytes != null) {
            return this.extraBytes;
        }
        String eb = this.attributes.get("extra-bytes");
        if (eb != null) {
            this.extraBytes = new byte[(eb.length() + 1) / 2];
            for (int i = 0; i < eb.length(); ++i) {
                int d = Integer.parseInt(eb.substring(i, i + 1), 16);
                int n = i / 2;
                this.extraBytes[n] = (byte)(this.extraBytes[n] | (byte)(d << 4 * (1 - (i & 1))));
            }
            return this.extraBytes;
        }
        int type0to15 = mapObject.getType() & 0xFFFF;
        int type8to15 = type0to15 & 0xFF00;
        if (this.attributes.get("seamark:light:character") != null) {
            String[] parts = this.attributes.get("seamark:light:character").split(" ");
            String group = this.attributes.get("seamark:light:group");
            if (parts.length > 0) {
                String lt = null;
                int i = 1;
                if (parts[0].startsWith("Fl")) {
                    lt = "flashing";
                } else if (parts[0].startsWith("F")) {
                    lt = "fixed";
                } else if (parts[0].startsWith("LFL")) {
                    lt = "long flashing";
                } else if (parts[0].startsWith("Q")) {
                    lt = "quick";
                } else if (parts[0].startsWith("VQ")) {
                    lt = "very quick";
                } else if (parts[0].startsWith("UQ")) {
                    lt = "ultra quick";
                } else if (parts[0].startsWith("Iso")) {
                    lt = "isophase";
                } else if (parts[0].startsWith("Oc")) {
                    lt = "occulting";
                } else if (parts[0].startsWith("IQ")) {
                    lt = "interrupted quick";
                } else if (parts[0].startsWith("IVQ ")) {
                    lt = "interrupted very quick";
                } else if (parts[0].startsWith("IUQ")) {
                    lt = "interrupted ultra quick";
                } else if (parts[0].startsWith("AI")) {
                    lt = "alternating";
                } else if (parts[0].startsWith("Mo")) {
                    if (parts[0].indexOf(40) == 2) {
                        lt = parts[0].substring(3, 4);
                    } else if (parts.length > 1 && parts[i].startsWith("(")) {
                        lt = parts[i].substring(1, 2);
                        ++i;
                    }
                }
                String group2 = null;
                if (!parts[0].startsWith("Mo") && parts[0].indexOf(40) > 0) {
                    group2 = parts[0].substring(parts[0].indexOf(40) + 1, parts[0].length() - 1);
                } else if (i < parts.length && parts[i].startsWith("(")) {
                    group2 = parts[i].substring(1, parts[i].length() - 1);
                    ++i;
                }
                if (group2 != null) {
                    if (group != null && !group.equals(group2)) {
                        log.warn((Object)("Inconsistent light description - seamark:light:group = '" + group + "' but seamark:light:character contains '" + parts[0] + "'"));
                    } else {
                        group = group2;
                    }
                }
                if (lt != null) {
                    if (group != null) {
                        this.attributes.put("group", group);
                        lt = "group " + lt;
                        if (group.split("\\+").length > 1) {
                            lt = "composite " + lt;
                        }
                    }
                    this.attributes.put("type", lt);
                }
                String light = null;
                if (i < parts.length) {
                    String c = parts[i].toUpperCase();
                    if (c.startsWith("W")) {
                        light = "white";
                    } else if (c.startsWith("R")) {
                        light = "red";
                    } else if (c.startsWith("G")) {
                        light = "green";
                    } else if (c.startsWith("Y")) {
                        light = "yellow";
                    }
                    ++i;
                } else {
                    light = this.attributes.get("light");
                }
                String period = null;
                if (i + 1 < parts.length && "s".equals(parts[i + 1])) {
                    period = parts[i];
                    i += 2;
                }
                String height = null;
                if (i + 1 < parts.length && "m".equals(parts[i + 1])) {
                    height = parts[i];
                    i += 2;
                }
                Object var13_41 = null;
                if (i + 1 < parts.length && "M".equals(parts[i + 1])) {
                    String string = parts[i];
                    i += 2;
                } else {
                    String string = this.attributes.get("seamark:light:range");
                }
                if (light != null) {
                    void var13_44;
                    if (var13_44 != null) {
                        light = light + "," + (String)var13_44;
                    }
                    this.attributes.put("light", light);
                    if (period != null) {
                        this.attributes.put("period", period);
                    }
                    if (height != null) {
                        this.attributes.put("height-above-datum", height + "m");
                    }
                }
            }
        }
        if (this.attributes.get("seamark:light:1") != null) {
            String desc;
            class SeamarkLight
            implements Comparable<SeamarkLight> {
                String colour;
                int sectorStart;
                int sectorEnd;
                int range;

                SeamarkLight(String desc) {
                    String[] parts = desc.split(":");
                    if (parts.length == 4) {
                        this.colour = parts[0];
                        if ("shore".equalsIgnoreCase(parts[1]) || "shore".equalsIgnoreCase(parts[2])) {
                            log.error((Object)(ExtTypeAttributes.this.objectName + ": shore is no valid sector bound, please annotate a numeric value"));
                        } else {
                            this.sectorStart = Double.valueOf(parts[1]).intValue();
                            while (this.sectorStart >= 360) {
                                this.sectorStart -= 360;
                            }
                            this.sectorEnd = Double.valueOf(parts[2]).intValue();
                            while (this.sectorEnd >= 360) {
                                this.sectorEnd -= 360;
                            }
                            this.range = Double.valueOf(parts[3]).intValue();
                        }
                    }
                }

                @Override
                public int compareTo(SeamarkLight other) {
                    if (this.sectorStart == other.sectorStart) {
                        return 0;
                    }
                    return this.sectorStart > other.sectorStart ? 1 : -1;
                }
            }
            ArrayList<SeamarkLight> lights = new ArrayList<SeamarkLight>();
            for (int n = 1; n <= 100 && (desc = this.attributes.get("seamark:light:" + n)) != null; ++n) {
                lights.add(new SeamarkLight(desc));
            }
            lights.sort(null);
            StringBuilder light = null;
            for (int i = 0; i < lights.size(); ++i) {
                SeamarkLight sml = (SeamarkLight)lights.get(i);
                if (light == null) {
                    light = new StringBuilder();
                } else {
                    light.append('/');
                }
                light.append(sml.colour).append(',').append(sml.range).append(',').append(sml.sectorStart);
                if (i + 1 < lights.size()) {
                    if (sml.sectorEnd == ((SeamarkLight)lights.get((int)(i + 1))).sectorStart) continue;
                    light.append("/unlit,0,").append(sml.sectorEnd);
                    continue;
                }
                if (sml.sectorEnd == ((SeamarkLight)lights.get((int)0)).sectorStart) continue;
                light.append("/unlit,0,").append(sml.sectorEnd);
            }
            if (light != null) {
                this.attributes.put("light", light.toString());
                if (this.attributes.get("seamark:light:character") == null) {
                    this.attributes.put("type", "fixed");
                }
            }
        }
        if ((sequence = this.attributes.get("seamark:light:sequence")) != null) {
            StringBuilder periods = new StringBuilder();
            StringBuilder eclipse = new StringBuilder();
            for (String p : sequence.split("[+,]")) {
                if (p.startsWith("(") && p.endsWith(")")) {
                    p = p.substring(1, p.length() - 1);
                    if (eclipse.length() > 0) {
                        eclipse.append(",");
                    }
                    eclipse.append(Double.parseDouble(p));
                    continue;
                }
                if (periods.length() > 0) {
                    periods.append(",");
                }
                periods.append(Double.parseDouble(p));
            }
            this.attributes.put("period", periods.toString());
            this.attributes.put("eclipse", eclipse.toString());
        }
        if (mapObject instanceof Point) {
            String fs;
            int[] eclipse;
            Light[] lights = this.parseLights(this.attributes.get("light"));
            int[] periods = ExtTypeAttributes.parsePeriods(this.attributes.get("period"));
            if (periods.length != (eclipse = ExtTypeAttributes.parsePeriods(this.attributes.get("eclipse"))).length && 1 != periods.length) {
                log.error((Object)(this.objectName + ": number of light and eclipse phases has to be equal"));
            }
            if (type8to15 == 256) {
                int off;
                byte by;
                byte by2;
                byte flags0 = 0;
                int lightType = this.lightType("");
                if (ExtTypeAttributes.meansYes(this.attributes.get("racon"))) {
                    flags0 = (byte)(flags0 | 1);
                }
                int nob = 6;
                if (this.note != null) {
                    nob += 3;
                    flags0 = (byte)(flags0 | 2);
                }
                if (this.intDesig != null) {
                    nob += 3;
                    flags0 = (byte)(flags0 | 8);
                }
                if (this.localDesig != null) {
                    nob += 3;
                    flags0 = (byte)(flags0 | 4);
                }
                byte flags1 = 0;
                if (lights.length > 1) {
                    for (Light light : lights) {
                        nob += light.colour != 0 ? 3 : 2;
                    }
                    flags1 = (byte)(flags1 | 8);
                }
                if (0 != eclipse.length) {
                    int n;
                    int[] nArray = periods;
                    int n2 = nArray.length;
                    for (n = 0; n < n2; ++n) {
                        for (int i = nArray[n]; i > 63; i -= 63) {
                            ++nob;
                        }
                        ++nob;
                    }
                    int[] nArray2 = eclipse;
                    n2 = nArray2.length;
                    for (n = 0; n < n2; ++n) {
                        for (int i = nArray2[n]; i > 63; i -= 63) {
                            ++nob;
                        }
                        ++nob;
                    }
                    flags1 = (byte)(flags1 | 1);
                } else if (this.morseLetter != null) {
                    flags1 = (byte)(flags1 | 1);
                }
                int n = 34;
                String hafs = this.attributes.get("height-above-foundation");
                Integer hafi = null;
                if (hafs != null) {
                    boolean[] blArray = new boolean[2];
                    hafi = ExtTypeAttributes.parseDistance(hafs, blArray);
                    if (blArray[1]) {
                        hafi = hafi / 10;
                    }
                    nob += hafi > 255 ? 2 : 1;
                    if (hafi > 255) {
                        byte by3 = (byte)(n | 0x80);
                    } else {
                        byte by4 = (byte)(n | 0x40);
                    }
                    if (!blArray[0]) {
                        void var13_53;
                        by2 = (byte)(var13_53 & 0xFFFFFFDF);
                    }
                }
                String string = this.attributes.get("height-above-datum");
                Integer hadi = null;
                if (string != null) {
                    boolean[] hadsDistFlags = new boolean[2];
                    hadi = ExtTypeAttributes.parseDistance(string, hadsDistFlags);
                    if (hadsDistFlags[1]) {
                        hadi = hadi / 10;
                    }
                    nob += hadi > 255 ? 2 : 1;
                    if (hadi > 255) {
                        byte by5 = (byte)(by2 | 8);
                    } else {
                        byte by6 = (byte)(by2 | 4);
                    }
                    if (!hadsDistFlags[0]) {
                        void var13_57;
                        by = (byte)(var13_57 & 0xFFFFFFFD);
                    }
                }
                String las = this.attributes.get("leading-angle");
                Integer leadingAngle = null;
                if (las != null) {
                    leadingAngle = (int)(Double.parseDouble(las.trim()) * 10.0);
                    nob += 2;
                    flags1 = (byte)(flags1 | 2);
                }
                int period = 0;
                for (int p : periods) {
                    period += p;
                }
                for (int p : eclipse) {
                    period += p;
                }
                if (period > 255) {
                    lightType |= 0x40;
                } else if (period > 511) {
                    period = 511;
                    log.warn((Object)"Can't encode periods greater than 51.1 seconds for lights");
                }
                this.extraBytes = new byte[nob + 2];
                int i = 0;
                this.extraBytes[i++] = (byte)(0xE0 | flags0);
                this.extraBytes[i++] = (byte)(nob << 1 | 1);
                this.extraBytes[i++] = (byte)(0x80 | lightType);
                this.extraBytes[i++] = flags1;
                this.extraBytes[i++] = by;
                if (hafi != null) {
                    this.extraBytes[i++] = (byte)hafi.intValue();
                    if (hafi > 255) {
                        this.extraBytes[i++] = (byte)(hafi >> 8);
                    }
                }
                if (hadi != null) {
                    this.extraBytes[i++] = (byte)hadi.intValue();
                    if (hadi > 255) {
                        this.extraBytes[i++] = (byte)(hadi >> 8);
                    }
                }
                this.extraBytes[i++] = (byte)period;
                if (this.note != null) {
                    off = this.note.getOffset();
                    this.extraBytes[i++] = (byte)off;
                    this.extraBytes[i++] = (byte)(off >> 8);
                    this.extraBytes[i++] = (byte)(off >> 16);
                }
                if (this.localDesig != null) {
                    off = this.localDesig.getOffset();
                    this.extraBytes[i++] = (byte)off;
                    this.extraBytes[i++] = (byte)(off >> 8);
                    this.extraBytes[i++] = (byte)(off >> 16);
                }
                if (this.intDesig != null) {
                    off = this.intDesig.getOffset();
                    this.extraBytes[i++] = (byte)off;
                    this.extraBytes[i++] = (byte)(off >> 8);
                    this.extraBytes[i++] = (byte)(off >> 16);
                }
                if (leadingAngle != null) {
                    this.extraBytes[i++] = (byte)leadingAngle.intValue();
                    this.extraBytes[i++] = (byte)(leadingAngle >> 8);
                }
                if (lights.length > 1) {
                    for (int l = 0; l < lights.length; ++l) {
                        int val = lights[l].colour << 12 | (int)(lights[l].angle * 10.0);
                        if (l + 1 == lights.length) {
                            val |= 0x8000;
                        }
                        this.extraBytes[i++] = (byte)val;
                        this.extraBytes[i++] = (byte)(val >> 8);
                        if (lights[l].colour == 0) continue;
                        this.extraBytes[i++] = (byte)lights[l].range;
                    }
                } else {
                    int lc = 0;
                    int lr = 0;
                    if (lights.length > 0) {
                        lc = lights[0].colour;
                        lr = (int)lights[0].range & 0x1F;
                    }
                    this.extraBytes[i++] = (byte)(lc << 5 | lr);
                }
                if (periods.length > 1) {
                    int p;
                    int n3;
                    this.extraBytes[i++] = (byte)(128 + periods.length);
                    int[] nArray = periods;
                    int n4 = nArray.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        for (p = nArray[n3]; p > 63; p -= 63) {
                            this.extraBytes[i++] = 63;
                        }
                        this.extraBytes[i++] = (byte)p;
                    }
                    nArray = eclipse;
                    n4 = nArray.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        for (p = nArray[n3]; p > 63; p -= 63) {
                            this.extraBytes[i++] = 63;
                        }
                        this.extraBytes[i++] = (byte)p;
                    }
                } else {
                    this.extraBytes[i++] = this.morseLetter != null ? this.morseLetter : (byte)1;
                }
                return this.extraBytes;
            }
            if (type8to15 == 512) {
                void var13_75;
                byte by;
                int off;
                void var13_65;
                void var13_63;
                byte flags0 = 0;
                int lt = this.lightType("");
                if (ExtTypeAttributes.meansYes(this.attributes.get("racon"))) {
                    flags0 = (byte)(flags0 | 1);
                }
                int nob = 4;
                if (this.note != null) {
                    nob += 3;
                    flags0 = (byte)(flags0 | 2);
                }
                if (this.intDesig != null) {
                    nob += 3;
                    flags0 = (byte)(flags0 | 8);
                }
                if (this.localDesig != null) {
                    nob += 3;
                    flags0 = (byte)(flags0 | 4);
                }
                if (periods.length > 0) {
                    ++nob;
                }
                int flags1 = 0;
                if (periods.length > 1) {
                    int[] nArray = periods;
                    int hafs = nArray.length;
                    for (int hafi = 0; hafi < hafs; ++hafi) {
                        for (int i = nArray[hafi]; i > 63; i -= 63) {
                            ++nob;
                        }
                        ++nob;
                    }
                    flags1 = (byte)(flags1 | 2);
                } else if (this.morseLetter != null) {
                    flags1 = (byte)(flags1 | 2);
                }
                this.extraBytes = new byte[nob + 2];
                int n = 0;
                this.extraBytes[n] = (byte)(0xE0 | flags0);
                ++var13_63;
                this.extraBytes[++var13_62] = (byte)(nob << 1 | 1);
                int lc = 0;
                if (lights.length > 0) {
                    lc = lights[0].colour;
                }
                this.extraBytes[var13_63] = (byte)(lc << 6 | this.colour(""));
                flags1 = (byte)(flags1 | (byte)(lc >> 2 & 1));
                ++var13_65;
                this.extraBytes[++var13_64] = flags1;
                if (this.note != null) {
                    void var13_68;
                    off = this.note.getOffset();
                    this.extraBytes[var13_65] = (byte)off;
                    this.extraBytes[++var13_66] = (byte)(off >> 8);
                    ++var13_68;
                    this.extraBytes[++var13_67] = (byte)(off >> 16);
                }
                if (this.localDesig != null) {
                    void var13_71;
                    off = this.localDesig.getOffset();
                    this.extraBytes[var13_68] = (byte)off;
                    this.extraBytes[++var13_69] = (byte)(off >> 8);
                    ++var13_71;
                    this.extraBytes[++var13_70] = (byte)(off >> 16);
                }
                if (this.intDesig != null) {
                    void var13_74;
                    off = this.intDesig.getOffset();
                    this.extraBytes[var13_71] = (byte)off;
                    this.extraBytes[++var13_72] = (byte)(off >> 8);
                    ++var13_74;
                    this.extraBytes[++var13_73] = (byte)(off >> 16);
                }
                int period = 0;
                for (int p : periods) {
                    period += p;
                }
                if (period > 255) {
                    period = 255;
                    log.warn((Object)"Can't encode periods greater than 25.5 seconds for buoy lights");
                }
                int n5 = 0;
                if (periods.length > 0) {
                    by = (byte)(n5 | 0xFFFFFF80);
                }
                ++var13_75;
                this.extraBytes[var13_74] = (byte)(by | lt);
                if (periods.length > 0) {
                    void var13_76;
                    ++var13_76;
                    this.extraBytes[var13_75] = (byte)period;
                    if (periods.length > 1) {
                        if (periods.length > 2) {
                            void var13_77;
                            ++var13_77;
                            this.extraBytes[var13_76] = -126;
                        } else {
                            void var13_78;
                            ++var13_78;
                            this.extraBytes[var13_76] = -127;
                        }
                        int[] nArray = periods;
                        int n6 = nArray.length;
                        for (int i = 0; i < n6; ++i) {
                            int p;
                            for (p = nArray[i]; p > 63; p -= 63) {
                                this.extraBytes[var13_80++] = 63;
                            }
                            this.extraBytes[var13_80++] = (byte)p;
                        }
                    } else {
                        void var13_81;
                        ++var13_81;
                        this.extraBytes[var13_76] = 1;
                    }
                } else if (this.morseLetter != null) {
                    void var13_82;
                    ++var13_82;
                    this.extraBytes[var13_75] = this.morseLetter;
                } else {
                    void var13_83;
                    ++var13_83;
                    this.extraBytes[var13_75] = 1;
                }
                return this.extraBytes;
            }
            if (type8to15 == 768 || type8to15 == 1024) {
                boolean[] distFlags;
                Integer di;
                String ds = this.attributes.get("depth");
                if (ds == null) {
                    ds = this.attributes.get("height");
                }
                if (ds != null && (di = ExtTypeAttributes.parseDistance(ds, distFlags = new boolean[2])) != null) {
                    if (di > 255) {
                        this.extraBytes = new byte[3];
                        this.extraBytes[0] = -96;
                    } else {
                        this.extraBytes = new byte[2];
                        this.extraBytes[0] = -128;
                    }
                    if (distFlags[0]) {
                        this.extraBytes[0] = (byte)(this.extraBytes[0] | 0x10);
                    }
                    if (distFlags[1]) {
                        this.extraBytes[0] = (byte)(this.extraBytes[0] | 8);
                    }
                    if (type8to15 == 1024) {
                        this.extraBytes[0] = (byte)(this.extraBytes[0] | this.position());
                    }
                    this.extraBytes[1] = (byte)di.intValue();
                    if (di > 255) {
                        this.extraBytes[2] = (byte)(di >> 8);
                    }
                    return this.extraBytes;
                }
            } else if (type8to15 == 1280) {
                String ss = this.attributes.get("style");
                if (ss != null) {
                    int style = Integer.decode(ss.trim());
                    this.extraBytes = new byte[1];
                    this.extraBytes[0] = (byte)(style & 0xF);
                    return this.extraBytes;
                }
            } else if (type0to15 == 2307 && (fs = this.attributes.get("facilities")) != null) {
                int facilities = Integer.decode(fs.trim());
                this.extraBytes = new byte[3];
                this.extraBytes[0] = (byte)(0xA0 | facilities & 0x1F);
                this.extraBytes[1] = (byte)(facilities >> 5);
                this.extraBytes[2] = (byte)(facilities >> 13 & 7 | facilities >> 12 & 0x18);
                return this.extraBytes;
            }
        } else if (mapObject instanceof Polyline) {
            String ss;
            if (type8to15 == 768 || !(mapObject instanceof Polygon) && (type0to15 == 261 || type0to15 == 262 || type0to15 == 263)) {
                boolean[] distFlags;
                Integer di;
                String ds = this.attributes.get("depth");
                if (ds == null) {
                    ds = this.attributes.get("height");
                }
                if (ds != null && (di = ExtTypeAttributes.parseDistance(ds, distFlags = new boolean[2])) != null) {
                    if (di > 255) {
                        this.extraBytes = new byte[3];
                        this.extraBytes[0] = -96;
                    } else {
                        this.extraBytes = new byte[2];
                        this.extraBytes[0] = -128;
                    }
                    if (distFlags[0]) {
                        this.extraBytes[0] = (byte)(this.extraBytes[0] | 0x10);
                    }
                    if (distFlags[1]) {
                        this.extraBytes[0] = (byte)(this.extraBytes[0] | 8);
                    }
                    if (type8to15 == 4) {
                        this.extraBytes[0] = (byte)(this.extraBytes[0] | this.position());
                    }
                    this.extraBytes[1] = (byte)di.intValue();
                    if (di > 255) {
                        this.extraBytes[2] = (byte)(di >> 8);
                    }
                    return this.extraBytes;
                }
            } else if (!(mapObject instanceof Polygon || type8to15 != 1024 && type8to15 != 1280 && type8to15 != 1536 || (ss = this.attributes.get("style")) == null)) {
                int style = Integer.decode(ss.trim());
                if ((style & 0xFF00) == 0) {
                    this.extraBytes = new byte[1];
                    this.extraBytes[0] = (byte)(style & 0xF);
                } else {
                    this.extraBytes = new byte[2];
                    this.extraBytes[0] = (byte)(0x80 | style & 0xF);
                    this.extraBytes[1] = (byte)(style >> 9 & 0x18 | style >> 8 & 3);
                }
                return this.extraBytes;
            }
        }
        return null;
    }

    private static boolean meansYes(String s) {
        if (s == null) {
            return false;
        }
        return "yes".startsWith(s = s.toLowerCase()) || "true".startsWith(s) || "1".equals(s);
    }

    private static Integer parseDistance(String ds, boolean[] flags) {
        ParsePosition pp = new ParsePosition(0);
        Number dn = new DecimalFormat().parse(ds, pp);
        if (dn != null) {
            double dd = dn.doubleValue();
            int di = dn.intValue();
            flags[0] = true;
            flags[1] = false;
            if ("ft".equalsIgnoreCase(ds.substring(pp.getIndex()).trim())) {
                flags[0] = false;
            }
            if ((double)di != dd) {
                di = (int)(dd * 10.0);
                flags[1] = true;
            }
            return di;
        }
        return null;
    }

    private int colour(String prefix) {
        String c = this.attributes.get(prefix + "colour");
        if (c == null) {
            c = this.attributes.get(prefix + "color");
        }
        if (c == null) {
            return 0;
        }
        if (Character.isDigit((c = c.trim()).charAt(0))) {
            return Integer.decode(c);
        }
        String[] colours = new String[]{"", "red", "green", "yellow", "white", "black", "black-yellow", "white-red", "black-red", "white-green", "red-yellow", "red-green", "orange", "black-yellow-black", "yellow-black", "yellow-black-yellow", "red-white", "green-red-green", "red-green-red", "black-red-black", "yellow-red-yellow", "green-red", "black-white", "white-orange", "orange-white", "green-white"};
        c = c.toLowerCase().replaceAll("[;, ]+", "-");
        for (int i = 0; i < colours.length; ++i) {
            if (!colours[i].equals(c)) continue;
            return i;
        }
        return 0;
    }

    private int lightType(String prefix) {
        String lt = this.attributes.get(prefix + "type");
        if (lt == null) {
            return 0;
        }
        if (Character.isDigit((lt = lt.trim()).charAt(0))) {
            return Integer.decode(lt);
        }
        if (lt.length() == 1) {
            this.morseLetter = (byte)lt.charAt(0);
            return 11;
        }
        String[] types = new String[]{"", "fixed", "isophase", "flashing", "group flashing", "composite group flashing", "occulting", "group occulting", "composite group occulting", "long flashing", "group long flashing", "morse code letter", "quick", "group quick", "group quick and long flashing", "interrupted quick", "very quick", "group very quick", "group very quick and long flashing", "interrupted very quick", "ultra quick", "interrupted ultra quick", "fixed and occulting", "fixed and group occulting", "fixed and isophase", "fixed and flashing", "fixed and group flashing", "fixed and long flashing", "alternating", "alternating occulting", "alternating flashing", "alternating group flashing"};
        lt = lt.toLowerCase();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(lt)) continue;
            return i;
        }
        return 0;
    }

    private int position() {
        String ps = this.attributes.get("position");
        if (ps == null) {
            return 0;
        }
        if (Character.isDigit((ps = ps.trim()).charAt(0))) {
            return Integer.decode(ps);
        }
        String[] positions = new String[]{"unknown", "", "doubtful", "existence doubtful", "approximate", "reported"};
        ps = ps.toLowerCase();
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i].equals(ps)) continue;
            return i;
        }
        return 0;
    }

    private static int[] parsePeriods(String ps) {
        if (ps == null) {
            return ZERO_INT_ARRAY;
        }
        String[] psa = ps.split(",");
        int[] periods = new int[psa.length];
        for (int i = 0; i < psa.length; ++i) {
            periods[i] = (int)(Double.parseDouble(psa[i].trim()) * 10.0);
        }
        return periods;
    }

    private Light[] parseLights(String ls) {
        if (ls == null) {
            return new Light[0];
        }
        ls = ls.trim();
        String[] defs = new String[]{};
        if (ls.startsWith("(")) {
            ArrayList<String> out = new ArrayList<String>();
            int start = 0;
            while (start < ls.length()) {
                int end;
                for (end = ++start; end < ls.length() && ls.charAt(end) != ')'; ++end) {
                }
                out.add(ls.substring(start, end));
                for (start = end + 1; start < ls.length() && ls.charAt(start) != '('; ++start) {
                }
            }
            defs = out.toArray(defs);
        } else {
            defs = ls.split("[:;/]");
        }
        Light[] lights = new Light[defs.length];
        for (int i = 0; i < defs.length; ++i) {
            String def = defs[i].trim();
            if (def.length() <= 0) continue;
            lights[i] = new Light(def);
        }
        return lights;
    }

    class Light {
        private int colour;
        private double range;
        private double angle;
        final String[] colours = new String[]{"unlit", "red", "green", "white", "blue", "yellow", "violet", "amber"};

        public Light(String desc) {
            String[] parts = desc.split(",");
            if (parts.length > 0) {
                String lc = parts[0].trim().toLowerCase();
                if (Character.isDigit(lc.charAt(0))) {
                    this.colour = Integer.decode(lc);
                } else {
                    for (int i = 0; i < this.colours.length; ++i) {
                        if (!this.colours[i].equals(lc)) continue;
                        this.colour = i;
                        break;
                    }
                }
            }
            if (parts.length > 1 && this.colour != 0) {
                this.range = Double.parseDouble(parts[1]);
            }
            if (parts.length > 2) {
                this.angle = Double.parseDouble(parts[2]);
            }
        }

        public String toString() {
            return "(" + this.colours[this.colour] + "," + this.range + "," + this.angle + ")";
        }
    }
}

