/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.net.AngleChecker;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;
import uk.me.parabola.imgfmt.app.net.NOD1Part;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RoundaboutCheck;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.imgfmt.app.net.RouteCenter;
import uk.me.parabola.imgfmt.app.net.RouteNode;
import uk.me.parabola.imgfmt.app.net.RouteRestriction;
import uk.me.parabola.log.Logger;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.MultiHashMap;

public class RoadNetwork {
    private static final Logger log = Logger.getLogger(RoadNetwork.class);
    private static final int MAX_RESTRICTIONS_ARCS = 7;
    private final Map<Integer, RouteNode> nodes = new LinkedHashMap<Integer, RouteNode>();
    private final List<RouteNode> boundary = new ArrayList<RouteNode>();
    private final List<RoadDef> roadDefs = new ArrayList<RoadDef>();
    private List<RouteCenter> centers = new ArrayList<RouteCenter>();
    private AngleChecker angleChecker = new AngleChecker();
    private RoundaboutCheck roundaboutCheck = new RoundaboutCheck();
    private boolean reportSimilarArcs;
    private boolean routable;
    private boolean reportRoutingIslands;
    private long maxSumRoadLengths;
    private int visitId;

    public void config(EnhancedProperties props) {
        this.reportSimilarArcs = props.getProperty("report-similar-arcs", false);
        int checkRoutingIslandLengths = props.getProperty("check-routing-island-len", -1);
        if (checkRoutingIslandLengths >= 0) {
            Logger.defaultLogger.warn((Object)"The --check-routing-island-len option is deprecated. Please use --report-routing-islands and/or max-routing-island-len");
            this.maxSumRoadLengths = checkRoutingIslandLengths;
            this.reportRoutingIslands = log.isInfoEnabled();
        }
        this.maxSumRoadLengths = props.getProperty("max-routing-island-len", -1);
        this.reportRoutingIslands = props.getProperty("report-routing-islands", false);
        this.routable = props.containsKey("route");
        this.angleChecker.config(props);
        this.roundaboutCheck.config(props);
    }

    public void addRoad(RoadDef roadDef, List<Coord> coordList) {
        this.roadDefs.add(roadDef);
        int lastNodePos = -1;
        double roadLength = 0.0;
        double arcLength = 0.0;
        int pointsHash = 0;
        int npoints = coordList.size();
        int numCoordNodes = 0;
        int numNumberNodes = 0;
        BitSet nodeFlags = new BitSet();
        for (int index = 0; index < npoints; ++index) {
            Coord co = coordList.get(index);
            pointsHash += co.hashCode();
            if (index > 0) {
                double segLenth = co.distance(coordList.get(index - 1));
                arcLength += segLenth;
                roadLength += segLenth;
            }
            if (co.getId() > 0) {
                nodeFlags.set(numNumberNodes);
                ++numCoordNodes;
                if (!roadDef.skipAddToNOD()) {
                    if (lastNodePos < 0) {
                        roadDef.setNode(this.getOrAddNode(co.getId(), co));
                    } else {
                        this.createDirectArcs(roadDef, coordList, lastNodePos, index, roadLength, arcLength, pointsHash);
                    }
                    lastNodePos = index;
                    arcLength = 0.0;
                    pointsHash = co.hashCode();
                }
            }
            if (!co.isNumberNode()) continue;
            ++numNumberNodes;
        }
        if (roadDef.hasHouseNumbers()) {
            roadDef.setNumNodes(numNumberNodes);
            roadDef.setNod2BitSet(nodeFlags);
        } else {
            roadDef.setNumNodes(numCoordNodes);
        }
        roadDef.setLength(roadLength);
        if (coordList.get(0).getId() == 0) {
            roadDef.setStartsWithNode(false);
        }
    }

    private void createDirectArcs(RoadDef roadDef, List<Coord> coordList, int prevPos, int currPos, double roadLength, double arcLength, int pointsHash) {
        RouteNode node2;
        RouteNode node1;
        Coord prevNode = coordList.get(prevPos);
        Coord currNode = coordList.get(currPos);
        int lastId = prevNode.getId();
        int currId = currNode.getId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("lastId = " + lastId + " curId = " + currId));
            log.debug((Object)("from " + prevNode + " to " + currNode));
            log.debug((Object)("arclength=" + arcLength + " roadlength=" + roadLength));
        }
        if ((node1 = this.getOrAddNode(lastId, prevNode)) == (node2 = this.getOrAddNode(currId, currNode))) {
            log.error((Object)("Road " + roadDef + " contains consecutive identical nodes at " + currNode.toOSMURL() + " - routing will be broken"));
        } else if (arcLength == 0.0) {
            log.warn((Object)("Road " + roadDef + " contains zero length arc at " + currNode.toOSMURL()));
        }
        double directLength = prevPos + 1 == currPos ? arcLength : prevNode.distance(currNode);
        Coord forwardBearingPoint = coordList.get(prevPos + 1);
        if (prevNode.equals(forwardBearingPoint) || forwardBearingPoint.isAddedNumberNode()) {
            for (int bi = prevPos + 2; bi <= currPos; ++bi) {
                Coord coTest = coordList.get(bi);
                if (coTest.isAddedNumberNode() || prevNode.equals(coTest)) continue;
                forwardBearingPoint = coTest;
                break;
            }
        }
        double forwardInitialBearing = prevNode.bearingTo(forwardBearingPoint);
        double forwardDirectBearing = currNode == forwardBearingPoint ? forwardInitialBearing : prevNode.bearingTo(currNode);
        RouteArc arc = new RouteArc(roadDef, node1, node2, forwardInitialBearing, forwardDirectBearing, arcLength, arcLength, directLength, pointsHash);
        arc.setForward();
        node1.addArc(arc);
        Coord reverseBearingPoint = coordList.get(currPos - 1);
        if (currNode.equals(reverseBearingPoint) || reverseBearingPoint.isAddedNumberNode()) {
            for (int bi = currPos - 2; bi >= prevPos; --bi) {
                Coord coTest = coordList.get(bi);
                if (coTest.isAddedNumberNode() || currNode.equals(coTest)) continue;
                reverseBearingPoint = coTest;
                break;
            }
        }
        double reverseInitialBearing = currNode.bearingTo(reverseBearingPoint);
        double reverseDirectBearing = 0.0;
        if (directLength > 0.0) {
            reverseDirectBearing = forwardDirectBearing + 180.0;
        }
        RouteArc reverseArc = new RouteArc(roadDef, node2, node1, reverseInitialBearing, reverseDirectBearing, arcLength, arcLength, directLength, pointsHash);
        node2.addArc(reverseArc);
        arc.setReverseArc(reverseArc);
        reverseArc.setReverseArc(arc);
    }

    private RouteNode getOrAddNode(int id, Coord coord) {
        return this.nodes.computeIfAbsent(id, key -> new RouteNode(coord));
    }

    public List<RoadDef> getRoadDefs() {
        return this.roadDefs;
    }

    private void splitCenters() {
        if (this.nodes.isEmpty()) {
            return;
        }
        assert (this.centers.isEmpty()) : "already subdivided into centers";
        ArrayList<RouteNode> nodeList = new ArrayList<RouteNode>(this.nodes.values());
        this.nodes.clear();
        nodeList.forEach(this::performChecks);
        NOD1Part nod1 = new NOD1Part();
        nodeList.stream().filter(node -> node.getArcs().isEmpty()).forEach(nod1::addNode);
        this.centers.addAll(nod1.subdivide());
        nodeList.removeIf(node -> node.getArcs().isEmpty());
        for (int group = 0; group <= 4; ++group) {
            nod1 = new NOD1Part();
            for (RouteNode node2 : nodeList) {
                if (node2.getGroup() != group) continue;
                nod1.addNode(node2);
            }
            this.centers.addAll(nod1.subdivide());
        }
    }

    private void performChecks(RouteNode node) {
        if (!node.isBoundary()) {
            this.roundaboutCheck.check(node);
            if (this.reportSimilarArcs) {
                node.reportSimilarArcs();
            }
        }
    }

    public List<RouteCenter> getCenters() {
        if (this.routable && this.centers.isEmpty()) {
            this.checkRoutingIslands();
            for (RouteNode n : this.nodes.values()) {
                if (!n.isBoundary()) continue;
                this.boundary.add(n);
            }
            this.angleChecker.check(this.nodes);
            this.addArcsToMajorRoads();
            for (RoadDef rd : this.roadDefs) {
                if (rd.skipAddToNOD() || !rd.getNode().getArcs().isEmpty()) continue;
                rd.getNode().setRoadClass(Math.max(rd.getRoadClass(), rd.getNode().getNodeClass()));
            }
            this.splitCenters();
        }
        return this.centers;
    }

    private void checkRoutingIslands() {
        if (this.maxSumRoadLengths <= 0L && !this.reportRoutingIslands) {
            return;
        }
        long t1 = System.currentTimeMillis();
        List<List<RouteNode>> islands = this.searchIslands();
        long t2 = System.currentTimeMillis();
        log.info("Search for routing islands found", islands.size(), "islands in", t2 - t1, "ms");
        if (!islands.isEmpty()) {
            this.analyseIslands(islands);
        }
        if (this.maxSumRoadLengths > 0L) {
            long t3 = System.currentTimeMillis();
            log.info("routing island removal took", t3 - t2, "ms");
        }
    }

    private List<List<RouteNode>> searchIslands() {
        int myVisitId = ++this.visitId;
        ArrayList<List<RouteNode>> islands = new ArrayList<List<RouteNode>>();
        for (RouteNode firstNode : this.nodes.values()) {
            if (firstNode.getVisitID() == myVisitId) continue;
            ArrayList<RouteNode> island = new ArrayList<RouteNode>();
            firstNode.visitNet(myVisitId, island);
            if (!island.stream().noneMatch(RouteNode::isBoundary)) continue;
            islands.add(island);
        }
        return islands;
    }

    private void analyseIslands(List<List<RouteNode>> islands) {
        MultiHashMap<RouteNode, RoadDef> nodeToRoadMap = new MultiHashMap<RouteNode, RoadDef>();
        this.roadDefs.forEach(rd -> {
            if (rd.getNode() != null) {
                nodeToRoadMap.add(rd.getNode(), (RoadDef)rd);
            }
        });
        boolean cleanNodes = false;
        for (List<RouteNode> island : islands) {
            HashSet<RoadDef> visitedRoads = new HashSet<RoadDef>();
            long sumOfRoadLengths = RoadNetwork.calcIslandSize(island, nodeToRoadMap, visitedRoads);
            if (this.reportRoutingIslands) {
                log.diagnostic("Routing island " + visitedRoads.iterator().next() + " at " + island.get(0).getCoord() + " with " + island.size() + " routing node(s) and total length of " + sumOfRoadLengths + "m");
            }
            if (sumOfRoadLengths >= this.maxSumRoadLengths) continue;
            island.forEach(RouteNode::discard);
            visitedRoads.forEach(rd -> rd.skipAddToNOD(true));
            cleanNodes = true;
        }
        if (cleanNodes) {
            Iterator<Map.Entry<Integer, RouteNode>> iter = this.nodes.entrySet().iterator();
            while (iter.hasNext()) {
                RouteNode n = iter.next().getValue();
                if (!n.isDiscarded()) continue;
                iter.remove();
            }
        }
    }

    private static long calcIslandSize(Collection<RouteNode> islandNodes, MultiHashMap<RouteNode, RoadDef> nodeToRoadMap, Set<RoadDef> visitedRoads) {
        double sumLen = 0.0;
        for (RouteNode node : islandNodes) {
            for (RouteArc arc : node.arcsIteration()) {
                if (!arc.isDirect() || !arc.isForward()) continue;
                visitedRoads.add(arc.getRoadDef());
            }
            Iterator<RouteArc> iterator = nodeToRoadMap.get(node).iterator();
            while (iterator.hasNext()) {
                RoadDef rd = (RoadDef)((Object)iterator.next());
                visitedRoads.add(rd);
            }
        }
        for (RoadDef rd : visitedRoads) {
            sumLen += rd.getLenInMeter();
        }
        return Math.round(sumLen);
    }

    private void addArcsToMajorRoads() {
        long t1 = System.currentTimeMillis();
        for (RoadDef rd : this.roadDefs) {
            if (rd.skipAddToNOD() || rd.getRoadClass() < 1) continue;
            rd.getNode().addArcsToMajorRoads(rd);
        }
        log.info((Object)(" added major road arcs in " + (System.currentTimeMillis() - t1) + " ms"));
    }

    public List<RouteNode> getBoundary() {
        return Collections.unmodifiableList(this.boundary);
    }

    public int addRestriction(GeneralRouteRestriction grr) {
        List toArcs;
        List<RouteArc> fromArcs;
        if (grr.getType() == GeneralRouteRestriction.RestrType.TYPE_NO_TROUGH) {
            return this.addNoThroughRoute(grr);
        }
        String sourceDesc = grr.getSourceDesc();
        ArrayList<RouteNode> viaNodes = new ArrayList<RouteNode>();
        for (CoordNode via : grr.getViaNodes()) {
            RouteNode vn = this.nodes.get(via.getId());
            if (vn == null) {
                log.error(sourceDesc, "can't locate 'via' RouteNode with id", via.getId());
                return 0;
            }
            viaNodes.add(vn);
        }
        int firstViaId = grr.getViaNodes().get(0).getId();
        int lastViaId = grr.getViaNodes().get(grr.getViaNodes().size() - 1).getId();
        RouteNode firstViaNode = this.nodes.get(firstViaId);
        RouteNode lastViaNode = this.nodes.get(lastViaId);
        ArrayList<Object> viaArcsList = new ArrayList<Object>();
        if (grr.getViaNodes().size() != grr.getViaWayIds().size() + 1) {
            log.error(sourceDesc, "internal error: number of via nodes and via ways doesn't fit");
            return 0;
        }
        for (int i = 1; i < grr.getViaNodes().size(); ++i) {
            RouteNode vn = (RouteNode)viaNodes.get(i - 1);
            Long viaWayId = grr.getViaWayIds().get(i - 1);
            List<RouteArc> viaArcs = vn.getDirectArcsTo((RouteNode)viaNodes.get(i), viaWayId);
            if (viaArcs.isEmpty()) {
                log.error(sourceDesc, "can't locate arc from 'via' node at", vn.getCoord().toOSMURL(), "to next 'via' node on way", viaWayId);
                return 0;
            }
            viaArcsList.add(viaArcs);
        }
        int fromId = 0;
        RouteNode fn = null;
        if (grr.getFromNode() != null) {
            fromId = grr.getFromNode().getId();
            fn = this.nodes.get(fromId);
            if (fn == null) {
                log.error(sourceDesc, "can't locate 'from' RouteNode with id", fromId);
                return 0;
            }
        } else {
            List<RouteArc> possibleFromArcs = firstViaNode.getDirectArcsOnWay(grr.getFromWayId());
            for (RouteArc arc : possibleFromArcs) {
                if (fn == null) {
                    fn = arc.getDest();
                    continue;
                }
                if (fn == arc.getDest()) continue;
                log.warn(sourceDesc, "found different 'from' arcs for way", grr.getFromWayId(), "restriction is ignored");
                return 0;
            }
            if (fn == null) {
                log.warn(sourceDesc, "can't locate 'from' RouteNode for 'from' way", grr.getFromWayId());
                return 0;
            }
            fromId = fn.getCoord().getId();
        }
        if ((fromArcs = fn.getDirectArcsTo(firstViaNode, grr.getFromWayId())).isEmpty()) {
            log.error(sourceDesc, "can't locate arc from 'from' node", fromId, "to 'via' node", firstViaId, "on way", grr.getFromWayId());
            return 0;
        }
        RouteNode tn = null;
        int toId = 0;
        if (grr.getToNode() != null) {
            toId = grr.getToNode().getId();
            tn = this.nodes.get(toId);
            if (tn == null) {
                log.error(sourceDesc, "can't locate 'to' RouteNode with id", toId);
                return 0;
            }
            toArcs = lastViaNode.getDirectArcsTo(tn, grr.getToWayId());
        } else {
            List<RouteArc> possibleToArcs = lastViaNode.getDirectArcsOnWay(grr.getToWayId());
            Iterator<RouteArc> fromArc = fromArcs.get(0);
            boolean ignoreAngle = false;
            if ((double)((RouteArc)((Object)fromArc)).getLengthInMeter() <= 1.0E-4) {
                ignoreAngle = true;
            }
            if (grr.getDirIndicator() == '?') {
                ignoreAngle = true;
            }
            log.info(sourceDesc, "found", possibleToArcs.size(), "candidates for to-arc");
            TreeMap<Integer, List> angleMap = new TreeMap<Integer, List>();
            for (RouteArc arc : possibleToArcs) {
                if ((double)arc.getLengthInMeter() <= 1.0E-4) {
                    ignoreAngle = true;
                }
                Integer angle = Math.round(RoadNetwork.getAngle(fromArc, arc));
                angleMap.computeIfAbsent(angle, k -> new ArrayList()).add(arc);
            }
            Iterator iter = angleMap.entrySet().iterator();
            Integer bestAngle = null;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!ignoreAngle && !RoadNetwork.matchDirectionInfo(((Integer)entry.getKey()).intValue(), grr.getDirIndicator())) continue;
                if (bestAngle == null) {
                    bestAngle = (Integer)entry.getKey();
                    continue;
                }
                bestAngle = RoadNetwork.getBetterAngle(bestAngle, (Integer)entry.getKey(), grr.getDirIndicator());
            }
            if (bestAngle == null) {
                log.warn(sourceDesc, "the angle of the from and to way don't match the restriction");
                return 0;
            }
            toArcs = (List)angleMap.get(bestAngle);
        }
        if (toArcs.isEmpty()) {
            log.error(sourceDesc, "can't locate arc from 'via' node", lastViaId, "to 'to' node", toId, "on way", grr.getToWayId());
            return 0;
        }
        ArrayList<RouteArc> badArcs = new ArrayList<RouteArc>();
        if (grr.getType() == GeneralRouteRestriction.RestrType.TYPE_NOT) {
            for (RouteArc toArc : toArcs) {
                badArcs.add(toArc);
            }
        } else if (grr.getType() == GeneralRouteRestriction.RestrType.TYPE_ONLY) {
            for (RouteArc badArc : lastViaNode.arcsIteration()) {
                if (!badArc.isDirect() || toArcs.contains(badArc)) continue;
                badArcs.add(badArc);
            }
            if (badArcs.isEmpty()) {
                log.warn(sourceDesc, "restriction ignored because it has no effect");
                return 0;
            }
        }
        ArrayList<Object> arcLists = new ArrayList<Object>();
        arcLists.add(fromArcs);
        arcLists.addAll(viaArcsList);
        arcLists.add(badArcs);
        if (arcLists.size() > 7) {
            log.warn(sourceDesc, "has more than", 7, "arcs, this is not supported");
            return 0;
        }
        for (int i = 0; i < arcLists.size(); ++i) {
            List arcs = (List)arcLists.get(i);
            int countNoEffect = 0;
            int countOneway = 0;
            for (int j = arcs.size() - 1; j >= 0; --j) {
                RouteArc arc = (RouteArc)arcs.get(j);
                if (!RoadNetwork.isUsable(arc.getRoadDef().getAccess(), grr.getExceptionMask())) {
                    ++countNoEffect;
                    arcs.remove(j);
                    continue;
                }
                if (!arc.getRoadDef().isOneway() || arc.isForward()) continue;
                ++countOneway;
                arcs.remove(j);
            }
            String arcType = null;
            if (!arcs.isEmpty()) continue;
            arcType = i == 0 ? "from way is" : (i == arcLists.size() - 1 ? (grr.getType() == GeneralRouteRestriction.RestrType.TYPE_ONLY ? "all possible other ways are" : "to way is") : "via way is");
            String reason = countNoEffect > 0 && countOneway > 0 ? "wrong direction in oneway or not accessible for restricted vehicles" : (countNoEffect > 0 ? "not accessible for restricted vehicles" : "wrong direction in oneway");
            log.warn(sourceDesc, "restriction ignored because", arcType, reason);
            return 0;
        }
        if (viaNodes.contains(fn)) {
            log.warn(sourceDesc, "restriction not written because from node appears also as via node");
            return 0;
        }
        int numCombis = 1;
        int[] indexes = new int[arcLists.size()];
        for (int i = 0; i < indexes.length; ++i) {
            List arcs = (List)arcLists.get(i);
            numCombis *= arcs.size();
        }
        ArrayList<RouteArc> path = new ArrayList<RouteArc>();
        int added = 0;
        for (int i = 0; i < numCombis; ++i) {
            for (RouteNode vn : viaNodes) {
                path.clear();
                boolean viaNodeFound = false;
                int pathNoAccessMask = 0;
                for (int j = 0; j < indexes.length; ++j) {
                    RouteArc arc = (RouteArc)((List)arcLists.get(j)).get(indexes[j]);
                    if (!viaNodeFound || arc.getDest() == vn) {
                        arc = arc.getReverseArc();
                    }
                    if (arc.getSource() == vn) {
                        viaNodeFound = true;
                    }
                    if (arc.getDest() == vn) {
                        if (added > 0) {
                            log.error(sourceDesc, "restriction incompletely written because dest in arc is via node");
                        } else {
                            log.warn(sourceDesc, "restriction not written because dest in arc is via node");
                        }
                        return added;
                    }
                    pathNoAccessMask = (byte)(pathNoAccessMask | ~arc.getRoadDef().getAccess());
                    path.add(arc);
                }
                byte pathAccessMask = (byte)(~pathNoAccessMask);
                if (!RoadNetwork.isUsable(pathAccessMask, grr.getExceptionMask())) continue;
                vn.addRestriction(new RouteRestriction(vn, path, grr.getExceptionMask()));
                ++added;
            }
            int n = indexes.length - 1;
            indexes[n] = indexes[n] + 1;
            for (int j = indexes.length - 1; j > 0; --j) {
                if (indexes[j] < ((List)arcLists.get(j)).size()) continue;
                indexes[j] = 0;
                int n2 = j - 1;
                indexes[n2] = indexes[n2] + 1;
            }
        }
        if (indexes[0] != ((List)arcLists.get(0)).size()) {
            log.error(sourceDesc, "failed to generate all possible paths");
        }
        log.info(sourceDesc, "added", added, "route restriction(s) to img file");
        return added;
    }

    private static boolean isUsable(byte roadAccess, byte exceptionMask) {
        return (roadAccess & (byte)(~exceptionMask)) != 0;
    }

    private int addNoThroughRoute(GeneralRouteRestriction grr) {
        assert (grr.getViaNodes() != null);
        assert (grr.getViaNodes().size() == 1);
        int viaId = grr.getViaNodes().get(0).getId();
        RouteNode vn = this.nodes.get(viaId);
        if (vn == null) {
            log.error(grr.getSourceDesc(), "can't locate 'via' RouteNode with id", viaId);
            return 0;
        }
        int added = 0;
        for (RouteArc out : vn.arcsIteration()) {
            if (!out.isDirect()) continue;
            for (RouteArc in : vn.arcsIteration()) {
                if (!in.isDirect() || in == out || in.getDest() == out.getDest()) continue;
                byte pathAccessMask = (byte)(out.getRoadDef().getAccess() & in.getRoadDef().getAccess());
                if (RoadNetwork.isUsable(pathAccessMask, grr.getExceptionMask())) {
                    vn.addRestriction(new RouteRestriction(vn, Arrays.asList(in, out), grr.getExceptionMask()));
                    ++added;
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug(grr.getSourceDesc(), "ignored no-through-route", in, "to", out);
            }
        }
        return added;
    }

    private static float getAngle(RouteArc fromArc, RouteArc toArc) {
        float angle;
        float headingFrom = fromArc.getFinalHeading();
        float headingTo = toArc.getInitialHeading();
        for (angle = headingTo - headingFrom; angle > 180.0f; angle -= 360.0f) {
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static Integer getBetterAngle(Integer angle1, Integer angle2, char dirIndicator) {
        switch (dirIndicator) {
            case 'l': {
                if (Math.abs(-90 - angle2) >= Math.abs(-90 - angle1)) break;
                return angle2;
            }
            case 'r': {
                if (Math.abs(90 - angle2) >= Math.abs(90 - angle1)) break;
                return angle2;
            }
            case 'u': {
                double d2;
                double d1 = angle1 < 0 ? (double)(-180 - angle1) : (double)(180 - angle1);
                double d = d2 = angle2 < 0 ? (double)(-180 - angle2) : (double)(180 - angle2);
                if (!(Math.abs(d2) < Math.abs(d1))) break;
                return angle2;
            }
            case 's': {
                if (Math.abs(angle2) >= Math.abs(angle1)) break;
                return angle2;
            }
        }
        return angle1;
    }

    private static boolean matchDirectionInfo(float angle, char dirIndicator) {
        switch (dirIndicator) {
            case 'l': {
                if (!(angle < -3.0f) || !(angle > -177.0f)) break;
                return true;
            }
            case 'r': {
                if (!(angle > 3.0f) || !(angle < 177.0f)) break;
                return true;
            }
            case 'u': {
                if (!(angle < -87.0f) && !(angle > 93.0f)) break;
                return true;
            }
            case 's': {
                if (!(angle > -87.0f) || !(angle < 87.0f)) break;
                return true;
            }
            case '?': {
                return true;
            }
        }
        return false;
    }
}

