/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.io.ByteArrayOutputStream;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.net.Abandon;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;

class CityZipWriter {
    private ByteArrayOutputStream buf;
    private final String type;
    private final int numItems;
    private final int defaultIndex;
    int[] lastEncodedIndexes = new int[]{-1, -1};

    public CityZipWriter(String type, int defIndex, int numItems) {
        this.type = type;
        this.defaultIndex = defIndex;
        this.numItems = numItems;
        this.buf = new ByteArrayOutputStream();
    }

    public ByteArrayOutputStream getBuffer() {
        return this.buf;
    }

    public boolean compile(List<Numbers> numbers) {
        try {
            int[] indexes = new int[]{this.defaultIndex, this.defaultIndex};
            int[] refIndexes = new int[]{this.defaultIndex, this.defaultIndex};
            int lastEncodedNodeIndex = -1;
            boolean needsWrite = false;
            for (Numbers num : numbers) {
                block11: for (int side = 0; side < 2; ++side) {
                    indexes[side] = this.defaultIndex;
                    boolean left = side == 0;
                    switch (this.type) {
                        case "zip": {
                            ZipCodeInfo zipInfo = num.getZipCodeInfo(left);
                            if (zipInfo == null || zipInfo.getImgZip() == null) continue block11;
                            indexes[side] = zipInfo.getImgZip().getIndex();
                            continue block11;
                        }
                        case "city": {
                            CityInfo cityInfo = num.getCityInfo(left);
                            if (cityInfo == null || cityInfo.getImgCity() == null) continue block11;
                            indexes[side] = cityInfo.getImgCity().getIndex();
                            continue block11;
                        }
                    }
                }
                if (indexes[0] == refIndexes[0] && indexes[1] == refIndexes[1]) continue;
                needsWrite = true;
                if (num.getIndex() > 0) {
                    int range = num.getIndex() - 1;
                    if (lastEncodedNodeIndex > 0) {
                        range -= lastEncodedNodeIndex;
                    }
                    this.encode(range, refIndexes);
                }
                refIndexes[0] = indexes[0];
                refIndexes[1] = indexes[1];
                lastEncodedNodeIndex = num.getIndex();
            }
            if (needsWrite) {
                int lastIndexWithNumbers = numbers.get(numbers.size() - 1).getIndex();
                int range = lastIndexWithNumbers - lastEncodedNodeIndex;
                this.encode(range, indexes);
            } else {
                this.buf.reset();
            }
        }
        catch (Abandon e) {
            return false;
        }
        return true;
    }

    private void encode(int skip, int[] indexes) {
        int initFlag;
        int sidesFlag = 0;
        if (indexes[0] <= 0 && indexes[1] <= 0) {
            sidesFlag |= 4;
            if (indexes[0] == 0) {
                sidesFlag |= 1;
            }
            if (indexes[1] == 0) {
                sidesFlag |= 2;
            }
        } else if (indexes[1] != indexes[0]) {
            if (indexes[0] > 0 && indexes[0] != this.lastEncodedIndexes[0]) {
                sidesFlag |= 1;
            }
            if (indexes[1] > 0 && indexes[1] != this.lastEncodedIndexes[1]) {
                sidesFlag |= 2;
            }
        }
        if ((initFlag = skip) > 31) {
            this.buf.write((byte)(initFlag & 0x1F | 0xE0));
            initFlag >>= 5;
        }
        this.buf.write((byte)((initFlag |= sidesFlag << 5) & 0xFF));
        if ((sidesFlag & 4) == 0) {
            if (indexes[0] > 0 && (sidesFlag == 0 || (sidesFlag & 1) == 1)) {
                this.writeIndex(indexes[0]);
            }
            if (indexes[1] > 0 && (sidesFlag & 2) != 0) {
                this.writeIndex(indexes[1]);
            }
        }
        this.lastEncodedIndexes[0] = indexes[0];
        this.lastEncodedIndexes[1] = indexes[1];
    }

    void writeIndex(int val) {
        if (val <= 0) {
            return;
        }
        int ptrSize = Utils.numberToPointerSize(this.numItems);
        this.buf.write(val);
        if (ptrSize <= 1) {
            return;
        }
        this.buf.write(val >> 8);
        if (ptrSize <= 2) {
            return;
        }
        this.buf.write(val >> 16);
    }
}

