/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;

public class ExitFacility {
    private final int index;
    private final Label description;
    private final int type;
    private final int direction;
    private final int facilities;
    private final boolean last;

    public ExitFacility(int type, char direction, int facilities, Label description, boolean last, int index) {
        this.type = type;
        this.direction = this.directionCode(direction);
        this.facilities = facilities;
        this.description = description;
        this.last = last;
        this.index = index;
    }

    void write(ImgFileWriter writer) {
        int word = 0;
        word |= this.description.getOffset();
        if (this.last) {
            word |= 0x800000;
        }
        word |= this.type << 24;
        writer.put4(word |= this.direction << 29);
        writer.put1u(this.facilities);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean getOvernightParking() {
        return false;
    }

    private int directionCode(char direction) {
        int code = "NSEWIOB".indexOf(direction);
        if (code < 0) {
            code = 7;
        }
        return code;
    }
}

