/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Sized;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.FileLink;
import uk.me.parabola.log.Logger;

public class FileBackedImgFileWriter
implements ImgFileWriter,
Sized {
    private final ImgChannel outputChan;
    private final File tmpFile;
    private final BufferedOutputStream file;
    private final FileChannel tmpChannel;
    private long finalSize;

    public FileBackedImgFileWriter(ImgChannel chan, File outputDir) {
        this.outputChan = chan;
        try {
            this.tmpFile = File.createTempFile("img", null, outputDir);
            this.tmpFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(this.tmpFile);
            this.tmpChannel = out.getChannel();
            this.file = new BufferedOutputStream(out, 16384);
        }
        catch (IOException e) {
            throw new MapFailedException("Could not create temporary file");
        }
        if (chan instanceof FileLink) {
            ((FileLink)((Object)chan)).link(this, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        this.finalSize = this.getSize();
        this.file.close();
        try (FileInputStream is = new FileInputStream(this.tmpFile);
             FileChannel channel = is.getChannel();){
            channel.transferTo(0L, channel.size(), this.outputChan);
        }
        finally {
            if (!this.tmpFile.delete()) {
                Logger.defaultLogger.error((Object)("could not delete temporary file " + this.tmpFile.getPath()));
            }
        }
    }

    @Override
    public int position() {
        try {
            this.file.flush();
            return (int)this.tmpChannel.position();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public void position(long pos) {
        try {
            this.file.flush();
            this.tmpChannel.position(pos);
        }
        catch (IOException e) {
            throw new MapFailedException("could not set position in temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void put(byte b) {
        try {
            this.file.write(b);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write byte to mdr tmp file");
        }
    }

    @Override
    public void put1s(int val) {
        assert (val >= -128 && val <= 127) : val;
        try {
            this.file.write(val);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void put2s(int val) {
        assert (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) : val;
        try {
            this.file.write(val);
            this.file.write(val >> 8);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void put3s(int val) {
        assert (val >= -8388608 && val <= 0x7FFFFF) : val;
        try {
            this.file.write(val);
            this.file.write(val >> 8);
            this.file.write(val >> 16);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void put1u(int val) {
        assert (val >= 0 && val <= 255) : val;
        try {
            this.file.write(val);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void put2u(int val) {
        assert (val >= 0 && val <= 65535) : val;
        try {
            this.file.write(val);
            this.file.write(val >> 8);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void put3u(int val) {
        assert (val >= 0 && val <= 0xFFFFFF) : val;
        try {
            this.file.write(val);
            this.file.write(val >> 8);
            this.file.write(val >> 16);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void putNu(int nBytes, int val) {
        assert (nBytes >= 1 && nBytes <= 4) : nBytes;
        try {
            this.file.write(val);
            if (nBytes <= 1) {
                assert (val >= 0 && val <= 255) : val;
                return;
            }
            this.file.write(val >> 8);
            if (nBytes <= 2) {
                assert (val >= 0 && val <= 65535) : val;
                return;
            }
            this.file.write(val >> 16);
            if (nBytes <= 3) {
                assert (val >= 0 && val <= 0xFFFFFF) : val;
                return;
            }
            this.file.write(val >> 24);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void put4(int val) {
        try {
            this.file.write(val);
            this.file.write(val >> 8);
            this.file.write(val >> 16);
            this.file.write(val >> 24);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void put(byte[] val) {
        try {
            this.file.write(val);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void put(byte[] src, int start, int length) {
        try {
            this.file.write(src, start, length);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void put(ByteBuffer src) {
        try {
            this.file.flush();
            this.tmpChannel.write(src);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write to temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public long getSize() {
        if (this.finalSize > 0L) {
            return this.finalSize;
        }
        try {
            this.file.flush();
            return this.tmpChannel.size();
        }
        catch (IOException e) {
            throw new MapFailedException("could not get size of temporary file " + this.tmpFile.getPath());
        }
    }

    @Override
    public void close() throws IOException {
        this.sync();
    }
}

