/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface UnaryOperatorWithThrowable<T, E extends Throwable>
extends UnaryOperator<T> {
    public static <T, E extends Throwable> UnaryOperatorWithThrowable<T, E> castUnaryOperatorWithThrowable(UnaryOperatorWithThrowable<T, E> unaryoperatorwiththrowable) {
        return unaryoperatorwiththrowable;
    }

    public static <T, E extends Throwable> UnaryOperator<T> aUnaryOperatorThatUnsafelyThrowsUnchecked(UnaryOperatorWithThrowable<T, E> unaryoperatorwiththrowable) throws E {
        return unaryoperatorwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> UnaryOperatorWithThrowable<T, E> asUnaryOperatorWithThrowable(UnaryOperator<T> unaryoperator) {
        return unaryoperator::apply;
    }

    @Override
    default public T apply(T v1) {
        try {
            return this.applyWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public T applyWithThrowable(T var1) throws E;

    default public UnaryOperator<T> thatReturnsOnCatch(T defaultReturnValue) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public UnaryOperator<T> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return null;
            }
        };
    }

    default public UnaryOperatorWithThrowable<T, E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public UnaryOperatorWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in UnaryOperatorWithThrowable with the argument [{}]");
    }

    default public UnaryOperatorWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public UnaryOperatorWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public UnaryOperatorWithThrowable<T, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

