/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.ToLongBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface ToLongBiFunctionWithThrowable<T, U, E extends Throwable>
extends ToLongBiFunction<T, U> {
    public static <T, U, E extends Throwable> ToLongBiFunctionWithThrowable<T, U, E> castToLongBiFunctionWithThrowable(ToLongBiFunctionWithThrowable<T, U, E> tolongbifunctionwiththrowable) {
        return tolongbifunctionwiththrowable;
    }

    public static <T, U, E extends Throwable> ToLongBiFunction<T, U> aToLongBiFunctionThatUnsafelyThrowsUnchecked(ToLongBiFunctionWithThrowable<T, U, E> tolongbifunctionwiththrowable) throws E {
        return tolongbifunctionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, U, E extends Throwable> ToLongBiFunctionWithThrowable<T, U, E> asToLongBiFunctionWithThrowable(ToLongBiFunction<T, U> tolongbifunction) {
        return tolongbifunction::applyAsLong;
    }

    @Override
    default public long applyAsLong(T v1, U v2) {
        try {
            return this.applyAsLongWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public long applyAsLongWithThrowable(T var1, U var2) throws E;

    default public BiFunction<T, U, OptionalLong> thatReturnsOptional() {
        return (v1, v2) -> {
            try {
                return OptionalLong.of(this.applyAsLongWithThrowable(v1, v2));
            }
            catch (Throwable throwable) {
                return OptionalLong.empty();
            }
        };
    }

    default public ToLongBiFunction<T, U> thatReturnsOnCatch(long defaultReturnValue) {
        return (v1, v2) -> {
            try {
                return this.applyAsLongWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public ToLongBiFunction<T, U> thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                return this.applyAsLongWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0L;
            }
        };
    }

    default public ToLongBiFunctionWithThrowable<T, U, E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                return this.applyAsLongWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public ToLongBiFunctionWithThrowable<T, U, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in ToLongBiFunctionWithThrowable with the arguments [{}, {}]");
    }

    default public ToLongBiFunctionWithThrowable<T, U, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public ToLongBiFunctionWithThrowable<T, U, E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyAsLongWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public ToLongBiFunctionWithThrowable<T, U, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyAsLongWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

