/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface ToIntBiFunctionWithThrowable<T, U, E extends Throwable>
extends ToIntBiFunction<T, U> {
    public static <T, U, E extends Throwable> ToIntBiFunctionWithThrowable<T, U, E> castToIntBiFunctionWithThrowable(ToIntBiFunctionWithThrowable<T, U, E> tointbifunctionwiththrowable) {
        return tointbifunctionwiththrowable;
    }

    public static <T, U, E extends Throwable> ToIntBiFunction<T, U> aToIntBiFunctionThatUnsafelyThrowsUnchecked(ToIntBiFunctionWithThrowable<T, U, E> tointbifunctionwiththrowable) throws E {
        return tointbifunctionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, U, E extends Throwable> ToIntBiFunctionWithThrowable<T, U, E> asToIntBiFunctionWithThrowable(ToIntBiFunction<T, U> tointbifunction) {
        return tointbifunction::applyAsInt;
    }

    @Override
    default public int applyAsInt(T v1, U v2) {
        try {
            return this.applyAsIntWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public int applyAsIntWithThrowable(T var1, U var2) throws E;

    default public BiFunction<T, U, OptionalInt> thatReturnsOptional() {
        return (v1, v2) -> {
            try {
                return OptionalInt.of(this.applyAsIntWithThrowable(v1, v2));
            }
            catch (Throwable throwable) {
                return OptionalInt.empty();
            }
        };
    }

    default public ToIntBiFunction<T, U> thatReturnsOnCatch(int defaultReturnValue) {
        return (v1, v2) -> {
            try {
                return this.applyAsIntWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public ToIntBiFunction<T, U> thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                return this.applyAsIntWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0;
            }
        };
    }

    default public ToIntBiFunctionWithThrowable<T, U, E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                return this.applyAsIntWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public ToIntBiFunctionWithThrowable<T, U, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in ToIntBiFunctionWithThrowable with the arguments [{}, {}]");
    }

    default public ToIntBiFunctionWithThrowable<T, U, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public ToIntBiFunctionWithThrowable<T, U, E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyAsIntWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public ToIntBiFunctionWithThrowable<T, U, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyAsIntWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

