/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface SupplierWithThrowable<T, E extends Throwable>
extends Supplier<T> {
    public static <T, E extends Throwable> SupplierWithThrowable<T, E> castSupplierWithThrowable(SupplierWithThrowable<T, E> supplierwiththrowable) {
        return supplierwiththrowable;
    }

    public static <T, E extends Throwable> Supplier<T> aSupplierThatUnsafelyThrowsUnchecked(SupplierWithThrowable<T, E> supplierwiththrowable) throws E {
        return supplierwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> SupplierWithThrowable<T, E> asSupplierWithThrowable(Supplier<T> supplier) {
        return supplier::get;
    }

    @Override
    default public T get() {
        try {
            return this.getWithThrowable();
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public T getWithThrowable() throws E;

    default public Supplier<Optional<T>> thatReturnsOptional() {
        return () -> {
            try {
                return Optional.ofNullable(this.getWithThrowable());
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
        };
    }

    default public Supplier<T> thatReturnsOnCatch(T defaultReturnValue) {
        return () -> {
            try {
                return this.getWithThrowable();
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public Supplier<T> thatUnsafelyThrowsUnchecked() throws E {
        return () -> {
            try {
                return this.getWithThrowable();
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return null;
            }
        };
    }

    default public SupplierWithThrowable<T, E> withLogging(Logger logger, String message) {
        return () -> {
            try {
                return this.getWithThrowable();
            }
            catch (Throwable throwable) {
                logger.error(message, throwable);
                throw throwable;
            }
        };
    }

    default public SupplierWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in SupplierWithThrowable");
    }

    default public SupplierWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public SupplierWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return () -> {
            try {
                return this.getWithThrowable();
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }
}

