/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface ObjIntConsumerWithThrowable<T, E extends Throwable>
extends ObjIntConsumer<T> {
    public static <T, E extends Throwable> ObjIntConsumerWithThrowable<T, E> castObjIntConsumerWithThrowable(ObjIntConsumerWithThrowable<T, E> objintconsumerwiththrowable) {
        return objintconsumerwiththrowable;
    }

    public static <T, E extends Throwable> ObjIntConsumer<T> aObjIntConsumerThatUnsafelyThrowsUnchecked(ObjIntConsumerWithThrowable<T, E> objintconsumerwiththrowable) throws E {
        return objintconsumerwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, E extends Throwable> ObjIntConsumerWithThrowable<T, E> asObjIntConsumerWithThrowable(ObjIntConsumer<T> objintconsumer) {
        return objintconsumer::accept;
    }

    @Override
    default public void accept(T v1, int v2) {
        try {
            this.acceptWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public void acceptWithThrowable(T var1, int var2) throws E;

    default public ObjIntConsumer<T> thatThrowsNothing() {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    default public ObjIntConsumer<T> thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
            }
        };
    }

    default public ObjIntConsumerWithThrowable<T, E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public ObjIntConsumerWithThrowable<T, E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in ObjIntConsumerWithThrowable with the arguments [{}, {}]");
    }

    default public ObjIntConsumerWithThrowable<T, E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public ObjIntConsumerWithThrowable<T, E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public ObjIntConsumerWithThrowable<T, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                this.acceptWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

